/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;

public final class ValidaCNPJ {
    private static final String formatoCNPJ = "##.###.###/####-##";

    private ValidaCNPJ() {
    }

    public static boolean validaCnpj(String cnpj) {
        int soma = 0;
        try {
            Long.parseLong(cnpj);
        }
        catch (Exception e) {
            throw new FormatoInvalidoException((Object)cnpj, 6, new Object[]{cnpj});
        }
        if (cnpj.length() > 8 && cnpj.length() < 14) {
            while (cnpj.length() < 14) {
                cnpj = "0" + cnpj;
            }
        }
        if (cnpj.length() == 14) {
            int i;
            int j = 5;
            for (i = 0; i < 12; ++i) {
                soma += j-- * (cnpj.charAt(i) - 48);
                if (j >= 2) continue;
                j = 9;
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == cnpj.charAt(12) - 48) {
                soma = 0;
                j = 6;
                for (i = 0; i < 13; ++i) {
                    soma += j-- * (cnpj.charAt(i) - 48);
                    if (j >= 2) continue;
                    j = 9;
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == cnpj.charAt(13) - 48) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean validaCnpjSemExcecao(String cnpj) {
        try {
            return ValidaCNPJ.validaCnpj(ValidaCNPJ.getCnpjNumeros(cnpj));
        }
        catch (RuntimeException e) {
            System.err.println("ValidaCNPJ: err: " + e);
            return false;
        }
    }

    public static String getCnpjNumeros(String cnpj) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < cnpj.length(); ++i) {
            char c = cnpj.charAt(i);
            if (c == '.' || c == '/' || c == '-') continue;
            ret.append(c);
        }
        if (ret.length() > 8 && ret.length() < 14) {
            while (ret.length() < 14) {
                ret.insert(0, "0");
            }
        }
        return ret.toString();
    }

    public static String formataCnpj(String cnpj) {
        char[] chrs = formatoCNPJ.toCharArray();
        StringBuffer cnpjFormatado = new StringBuffer();
        int offSet = 0;
        cnpj = ValidaCNPJ.getCnpjNumeros(cnpj);
        for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] != '#') {
                cnpjFormatado.append(chrs[index]);
                continue;
            }
            cnpjFormatado.append(cnpj.substring(offSet, offSet + 1));
            ++offSet;
        }
        return new String(cnpjFormatado);
    }
}

