/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import https.wsresponsaveis_tce_rs_gov.EntidadeSatbWSPojo;
import java.util.HashMap;
import java.util.List;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiscadUtil {
    private static final Log log = LogFactory.getLog(SiscadUtil.class);
    private static boolean doCommit = false;
    public static final Integer buscaEntidadesNroAnos = 1000;

    public static void atualizaEntidades(List<EntidadeSatbWSPojo> entidades, BindingContext binding) {
        if (entidades == null) {
            return;
        }
        HashMap<Integer, EntidadeSatbWSPojo> entMap = new HashMap<Integer, EntidadeSatbWSPojo>();
        for (EntidadeSatbWSPojo e : entidades) {
            entMap.put(e.getCdEntidade(), e);
        }
        boolean deveAtualizar = false;
        int countVoEntidades = 0;
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
        ViewObject voEntidades = ser.findViewObject("TodasEntidadesView");
        voEntidades.setWhereClause(null);
        voEntidades.setWhereClauseParams(null);
        voEntidades.executeQuery();
        voEntidades.first();
        voEntidades.previous();
        while (voEntidades.hasNext()) {
            voEntidades.next();
            Row row = voEntidades.getCurrentRow();
            Integer cdEntidade = (Integer)row.getAttribute("CdEntidade");
            EntidadeSatbWSPojo estb = (EntidadeSatbWSPojo)entMap.get(cdEntidade);
            if (estb != null) {
                log.debug((Object)("- entidade SATB: " + estb.getCdEntidade() + " / " + estb.getTipoSetorGov() + " / " + estb.getNome() + " [dt-situacao=" + estb.getDtSituacaoAtual() + "] ?"));
                int situacao = estb.getCdSituacaoOrgao();
                if (situacao != 1 && situacao != 3) {
                    log.info((Object)("-> deveria desabilitar [" + estb.getCdEntidade() + "]: situacao = " + situacao + " / " + estb.getDsSituacaoOrgao()));
                } else {
                    Object cdEntidadePai = row.getAttribute("CdEntidadePai");
                    if (!row.getAttribute("Rpps").equals(estb.getRpps()) && !"P".equals(estb.getTipoSetorGov())) {
                        log.info((Object)("- atualizar\u00e1 RPPS: " + estb.getRpps() + " [anterior=" + row.getAttribute("Rpps") + "] [" + estb.getCdEntidade() + "/" + estb.getNome() + "]"));
                        ser.atualizaRppsEntidade(estb.getCdEntidade(), estb.getRpps());
                    }
                    if (cdEntidadePai != null && !cdEntidadePai.equals(estb.getCdEntidadePai())) {
                        log.info((Object)("- atualizar\u00e1 EntidadePai: " + estb.getCdEntidadePai() + " [anterior=" + row.getAttribute("CdEntidadePai") + "] [" + estb.getCdEntidade() + "/" + estb.getNome() + "]"));
                        ser.atualizaCdEntidadePaiDaEntidade(estb.getCdEntidade(), estb.getCdEntidadePai());
                    }
                    if (!row.getAttribute("TipoSetorGov").equals(estb.getTipoSetorGov())) {
                        log.info((Object)("- atualizar\u00e1 TipoSetorGov: " + estb.getTipoSetorGov() + " [anterior=" + row.getAttribute("TipoSetorGov") + "] [" + estb.getCdEntidade() + "/" + estb.getNome() + "]"));
                        ser.atualizaTipoSetorGov(estb.getCdEntidade(), estb.getTipoSetorGov());
                    }
                }
                entMap.remove(cdEntidade);
            }
            ++countVoEntidades;
        }
        log.info((Object)("countVoEntidades = " + countVoEntidades + " / entidades[Satb].size() = " + entidades.size()));
        for (EntidadeSatbWSPojo estb : entMap.values()) {
            int situacao = estb.getCdSituacaoOrgao();
            log.info((Object)("-> adicionar entidade " + estb.getCdEntidade() + " / " + estb.getTipoSetorGov() + " / " + estb.getNome() + " [situacao=" + situacao + " / dt-situacao=" + estb.getDtSituacaoAtual() + "] ?"));
            if (situacao != 1 && situacao != 2 && situacao != 3 && situacao != 8) {
                log.info((Object)("---> n\u00e3o ir\u00e1 incluir: situacao = " + situacao + " / " + estb.getDsSituacaoOrgao()));
                continue;
            }
            if (!deveAtualizar) {
                if (doCommit) {
                    ser.getTransaction().commit();
                }
                deveAtualizar = true;
            }
            String sql = "insert into entidades ( cd_entidade, tipo_setor_gov, cnpj, nome, cod_municipio, rpps, cd_entidade_pai, nome_ordem ) values ( " + estb.getCdEntidade() + ", '" + estb.getTipoSetorGov() + "', '" + estb.getCnpj() + "', '" + estb.getNome() + "', " + estb.getCodMunicipio() + ", " + estb.getRpps() + ", " + estb.getCdEntidadePai() + ", '" + estb.getNomeOrdem() + "' )";
            ser.getTransaction().executeCommand(sql);
        }
        if (deveAtualizar && doCommit) {
            ser.getTransaction().commit();
        }
        voEntidades.clearCache();
    }
}

