/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.Formato;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.util.ResolveStringConstantes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImportacaoHelper {
    protected static Log log = LogFactory.getLog(ImportacaoHelper.class);

    private ImportacaoHelper() {
    }

    static Object extraiDadoCampoCalculado(MetadadosArquivoContabil metadadosArquivo, Remessa remessa, StringBuilder linha, Campo campo) {
        Object valorCampo = null;
        String argumentos = null;
        String operacao = null;
        argumentos = campo.getArgumentos();
        operacao = campo.getOperacao();
        if (operacao.equals("concatenar")) {
            valorCampo = ImportacaoHelper.executaCampoCalculadoOperacaoConcatenar(metadadosArquivo, remessa, linha, argumentos);
        } else {
            log.warn((Object)("opera\u00e7\u00e3o desconhecida: " + operacao));
        }
        return valorCampo;
    }

    public static Object executaCampoCalculadoOperacaoConcatenar(MetadadosArquivoContabil metadadosArquivo, Remessa remessa, StringBuilder linha, String argumentos) {
        Object stringConstanteValor = null;
        String[] splitArgumentos = null;
        StringBuilder valorCampo = new StringBuilder(20);
        int[] posicoes = null;
        try {
            splitArgumentos = ImportacaoHelper.realizaSplit(argumentos, ',');
            for (int index = 0; index < splitArgumentos.length; ++index) {
                if (Character.isDigit(splitArgumentos[index].charAt(0))) {
                    posicoes = ImportacaoHelper.interpretaPosicoes(splitArgumentos[index]);
                    if (posicoes[0] > posicoes[1]) {
                        throw new ConfiguracaoException("Sintaxe de campo calculado inv\u00e1lida, posi\u00e7\u00e3o inicial > posi\u00e7\u00e3o final");
                    }
                    valorCampo.append(linha.substring(posicoes[0] - 1, posicoes[1]));
                    continue;
                }
                if (splitArgumentos[index].startsWith("SIGNIFICATIVO")) {
                    valorCampo.append(ImportacaoHelper.getSignificativo(linha, ImportacaoHelper.criaArgumentos(splitArgumentos[index])));
                    continue;
                }
                if (splitArgumentos[index].startsWith("FIXO")) {
                    valorCampo.append(ImportacaoHelper.getFixo(linha, ImportacaoHelper.criaArgumentos(splitArgumentos[index])));
                    continue;
                }
                stringConstanteValor = ResolveStringConstantes.getValorString(splitArgumentos[index], remessa, metadadosArquivo.getCabecalho());
                valorCampo.append(stringConstanteValor);
            }
        }
        catch (ConfiguracaoException e) {
            throw e;
        }
        catch (StringIndexOutOfBoundsException e) {
            String message = "Erro concatenar (StringIndexOutOfBoundsException) - valor: " + valorCampo + " ; " + (posicoes != null ? (posicoes.length > 1 ? "pos: " + posicoes[0] + "-" + posicoes[1] : "#pos: " + posicoes.length) : "posicoes null") + " ; ex: " + e.getMessage();
            log.debug((Object)message);
        }
        return valorCampo.toString();
    }

    static final int[] interpretaPosicoes(String splitArgumentos) {
        int[] posicoes = new int[2];
        String[] splitPosicoes = new String[2];
        splitPosicoes = ImportacaoHelper.realizaSplit(splitArgumentos, '-');
        try {
            posicoes[0] = Integer.parseInt(splitPosicoes[0]);
        }
        catch (NumberFormatException e) {
            throw new ConfiguracaoException("Formato de n\u00famero inv\u00e1lido - \"" + splitPosicoes[0] + "\"");
        }
        try {
            posicoes[1] = Integer.parseInt(splitPosicoes[1]);
        }
        catch (NumberFormatException e) {
            throw new ConfiguracaoException("Formato de n\u00famero inv\u00e1lido - \"" + splitPosicoes[1] + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return posicoes;
    }

    public static final String[] realizaSplit(String valor, char caractere) {
        String[] valores = null;
        valores = StringUtils.split((String)valor, (char)caractere);
        return valores;
    }

    public static String criaArgumentos(String argumentos) {
        return argumentos.substring(argumentos.indexOf("(") + 1, argumentos.indexOf(")"));
    }

    public static String getSignificativo(StringBuilder linha, String argumentos) {
        String[] splitArgumentos = null;
        StringBuffer valorSignificativo = null;
        int tamanho = 0;
        splitArgumentos = ImportacaoHelper.realizaSplit(argumentos, ';');
        int[] posicoes = ImportacaoHelper.interpretaPosicoes(splitArgumentos[0]);
        try {
            tamanho = Integer.parseInt(splitArgumentos[1]);
        }
        catch (NumberFormatException nfe) {
            throw new ConfiguracaoException("Sintaxe fun\u00e7\u00e3o getSignificativo inv\u00e1lida: " + argumentos);
        }
        try {
            valorSignificativo = new StringBuffer(linha.substring(posicoes[0] - 1, posicoes[1]));
        }
        catch (IndexOutOfBoundsException e) {
            log.warn((Object)("Sintaxe fun\u00e7\u00e3o getSignificativo inv\u00e1lida, verifique as posi\u00e7\u00f5es indicadas. [" + (posicoes[0] - 1) + "-" + posicoes[1] + " :: " + linha + "]"));
            throw e;
        }
        while (linha.charAt(posicoes[0] - 1) == '0') {
            posicoes[0] = posicoes[0] + 1;
        }
        String valorRetorno = null;
        try {
            posicoes[0] = posicoes[0] - 1;
            valorRetorno = linha.substring(posicoes[0], posicoes[0] + tamanho);
            if (valorRetorno.length() != tamanho) {
                throw new IllegalArgumentException("H\u00e1 um erro cr\u00edtico na rotina getSignificativo.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConfiguracaoException("Sintaxe fun\u00e7\u00e3o getSignificativo inv\u00e1lida, verifique as posi\u00e7\u00f5es indicadas.");
        }
        return valorRetorno;
    }

    public static String getFixo(StringBuilder linha, String argumentos) {
        return argumentos;
    }

    private String[] buscaColunasChavePrimaria(Tabela tabela) {
        String[] nomeColunas = null;
        nomeColunas = new String[tabela.getChavePrimaria().length];
        nomeColunas = tabela.getChavePrimaria();
        return nomeColunas;
    }

    public static Object parseValorCampo(MetadadosArquivoContabil metadadosArquivo, Remessa remessa, StringBuilder linha, Campo campo) {
        Object valorCampo = null;
        valorCampo = campo.getCalculado() ? ImportacaoHelper.extraiDadoCampoCalculado(metadadosArquivo, remessa, linha, campo) : ImportacaoHelper.extraiDadoCampo(linha, campo);
        return valorCampo;
    }

    public static String extraiDadoCampo(StringBuilder linha, Campo campo) {
        String valorCampo = "";
        int posicaoInicio = 0;
        int posicaoFim = 0;
        int tamLinha = linha.length();
        posicaoInicio = campo.getInicio();
        if (posicaoInicio > (posicaoFim = campo.getFinal())) {
            throw new ConfiguracaoException("Sintaxe de campo calculado inv\u00e1lida, posi\u00e7\u00e3o inicial > posi\u00e7\u00e3o final");
        }
        try {
            if (tamLinha >= posicaoInicio) {
                valorCampo = tamLinha >= posicaoFim ? linha.substring(posicaoInicio, posicaoFim) : linha.substring(--posicaoInicio, tamLinha);
            } else {
                int size = posicaoFim - posicaoInicio + 1;
                valorCampo = StringUtils.repeat((String)" ", (int)size);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConfiguracaoException("Sintaxe de campo calculado inv\u00e1lida, posi\u00e7\u00e3o inicial > posi\u00e7\u00e3o final - (" + e.getMessage() + ")");
        }
        return valorCampo;
    }

    public static Campo[] buscaCampos(MetadadosArquivoContabil metadadosArquivo) {
        Formato formato = metadadosArquivo.getArquivo().getFormato();
        Campo[] campos = formato.getCampo();
        return campos;
    }
}

