/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.emp;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;

public class EMP80
extends RegraLinha {
    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        String licitacaoCompartilhada = valoresCampos.getValorCampo("licitacaoCompartilhada").toString();
        String cnpjOrgaoLicitacao = valoresCampos.getValorCampo("cnpjOrgaoLicitacao").toString();
        if ("S".equals(licitacaoCompartilhada)) {
            boolean valido = false;
            try {
                valido = cnpjOrgaoLicitacao.matches("\\d+");
            }
            catch (FormatoInvalidoException formatoInvalidoException) {
                // empty catch block
            }
            if (!valido) {
                Object[] argumentos = new Object[]{numeroLinha, cnpjOrgaoLicitacao};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "cnpjOrgaoLicitacao", numeroLinha, evento.getArquivo(), argumentos);
            }
        } else if (!"00000000000000".equals(cnpjOrgaoLicitacao)) {
            Object[] argumentos = new Object[]{numeroLinha, cnpjOrgaoLicitacao};
            this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "cnpjOrgaoLicitacao", numeroLinha, evento.getArquivo(), argumentos);
        }
    }
}

