/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.cre;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.util.ValidaCPF;

public class CRE16
extends RegraLinha {
    public static final String CONTADOR_CRE16 = "verificacao.CRE16.contador";
    public static final String CONTADOR_GERAL_CRE16 = "verificacao.CRE16.contadorGeral";

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        Integer contador = (Integer)contexto.getAtributo(CONTADOR_CRE16);
        Integer contadorGeral = (Integer)contexto.getAtributo(CONTADOR_GERAL_CRE16);
        if (contador == null) {
            contador = 0;
        }
        if (contadorGeral == null) {
            contadorGeral = 0;
        }
        if (evento.getTipoEvento() == 3) {
            Long cnpjCpfCredor = (Long)valoresCampos.getValorCampo("cnpjCpfCredor");
            contadorGeral = contadorGeral + 1;
            contexto.adicionaAtributo(CONTADOR_GERAL_CRE16, contadorGeral);
            if (!ValidaCNPJ.validaCnpj(String.valueOf(cnpjCpfCredor)) && !ValidaCPF.validaCPF(String.valueOf(cnpjCpfCredor))) {
                boolean ehTudoIgual = true;
                String total = cnpjCpfCredor.toString();
                String inicial = total.substring(0, 1);
                int qntd = total.length();
                for (int i = 0; i < qntd; ++i) {
                    if (i == qntd - 1) {
                        if (inicial.equalsIgnoreCase(total.substring(i))) continue;
                        ehTudoIgual = false;
                        break;
                    }
                    if (inicial.equalsIgnoreCase(total.substring(i, i + 1))) continue;
                    ehTudoIgual = false;
                    break;
                }
                if (ehTudoIgual) {
                    contador = contador + 1;
                    contexto.adicionaAtributo(CONTADOR_CRE16, contador);
                }
            }
        } else if (evento.getTipoEvento() == 1) {
            Double percentual;
            if (contador > 0 && (percentual = Double.valueOf((double)contador.intValue() * 100.0 / (double)contadorGeral.intValue())) > 0.0) {
                Object[] argumentos = new Object[]{percentual.intValue()};
                if (percentual.intValue() > 10) {
                    this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos, "J");
                } else {
                    this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
                }
            }
            contexto.removeAtributo(CONTADOR_CRE16);
            contexto.removeAtributo(CONTADOR_GERAL_CRE16);
        }
    }
}

