/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.bva;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import br.gov.rs.tce.pad.modelo.verificacao.regras.bav.BAV16;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BVA18
extends RegraLinha {
    protected static final Log log = LogFactory.getLog(BVA18.class);
    static final BigDecimal NOVES = BAV16.NOVES;

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        BigDecimal saldoAtualContaDevedora = ((BigDecimal)valoresCampos.getValorCampo("saldoAtualContaDevedora")).setScale(2, 6);
        BigDecimal saldoAtualContaCredora = ((BigDecimal)valoresCampos.getValorCampo("saldoAtualContaCredora")).setScale(2, 6);
        BigDecimal saldoAntContaDevedora = ((BigDecimal)valoresCampos.getValorCampo("saldoAntContaDevedora")).setScale(2, 6);
        BigDecimal saldoAntContaCredora = ((BigDecimal)valoresCampos.getValorCampo("saldoAntContaCredora")).setScale(2, 6);
        BigDecimal movimDebito = ((BigDecimal)valoresCampos.getValorCampo("movimDebito")).setScale(2, 6);
        BigDecimal movimCredito = ((BigDecimal)valoresCampos.getValorCampo("movimCredito")).setScale(2, 6);
        String codContaBalVerSG = valoresCampos.getValorCampo("codContaBalVerSG").toString();
        BigDecimal saldo = saldoAntContaDevedora.subtract(saldoAntContaCredora).add(movimDebito).subtract(movimCredito).subtract(saldoAtualContaDevedora).add(saldoAtualContaCredora);
        if (saldo.doubleValue() != 0.0) {
            if (saldoAtualContaDevedora.equals(NOVES) || saldoAtualContaCredora.equals(NOVES) || saldoAntContaDevedora.equals(NOVES) || saldoAntContaCredora.equals(NOVES) || movimDebito.equals(NOVES) || movimCredito.equals(NOVES)) {
                log.debug((Object)("  BVA18: linha == " + numeroLinha + " ; valor com NOVES"));
                return;
            }
            Object[] argumentos = new Object[]{numeroLinha, codContaBalVerSG};
            this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "", numeroLinha, evento.getArquivo(), argumentos);
        }
    }
}

