/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.bav;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraConsultaBanco;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import org.apache.commons.dbutils.ResultSetHandler;

public class BAV34
extends RegraConsultaBanco {
    public static String CONSULTA_NR_EMPENHOS = "select distinct e.nr_empenho from rubricas r, contas_remessa c, empenhos e where c.cd_conta = r.cd_rubrica and e.cd_rubrica = r.cd_rubrica and r.exercicio = ? and e.ano_empenho = ? and c.status = 'S' and cd_TIPO = 985";
    public static String CONSULTA_VLR_BAL_VER = "select sum(vl_saldo_atual_cre - vl_saldo_atual_dev) bal_ver from bal_verificacoes b, contas_remessa c where c.cd_conta = b.cd_conta_bver and cd_tipo = 970 and c.status = 'S'";

    @Override
    public void executaRegraVerificacao(ImportacaoEvento evento) {
        Remessa rem = evento.getSituacaoVerificacao().getRemessa();
        System.out.println("Buscando empenhos");
        String nrEmpenhos = this.getNrEmpenhos(rem.getAnoExercicio());
        if (nrEmpenhos.equals("")) {
            return;
        }
        System.out.println("Calculando vlrLiquidacao");
        String consultaVlrLiquidacao = "select sum(vl_liquidacao) liquidacao from liquidacoes l where l.nr_empenho in (" + nrEmpenhos + ")";
        Double vlrLiquidacao = this.getValorConsulta(consultaVlrLiquidacao);
        System.out.println("Calculando vlrPagamento");
        String consultaVlrPagamento = "select sum(vl_pagamento) pagamento from pagamentos p where p.nr_empenho in (" + nrEmpenhos + ")";
        Double vlrPagamento = this.getValorConsulta(consultaVlrPagamento);
        System.out.println("Calculando vlrBalVer (saldo)");
        Double vlrBalVer = this.getValorConsulta(CONSULTA_VLR_BAL_VER);
        NumberFormat format = NumberFormat.getCurrencyInstance();
        String vlrDespesas = format.format(vlrLiquidacao - vlrPagamento);
        String vlrSaldo = format.format(vlrBalVer);
        System.out.println("Valores calculados: vlrLiquidacao:" + vlrLiquidacao + " vlrPagamento:" + vlrPagamento + " vlrBalVer:" + vlrBalVer);
        System.out.println("Valores comparados: vlrDespesas:'" + vlrDespesas + "' vlrSaldo:'" + vlrSaldo + "'");
        if (!vlrDespesas.equals(vlrSaldo)) {
            this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), this._metaDadosArquivo.getArquivo(), new Object[]{vlrSaldo, vlrDespesas});
        }
    }

    private String getNrEmpenhos(Integer anoExercicio) {
        try {
            return (String)this._queryRunner.query(this._conexao, CONSULTA_NR_EMPENHOS, new Object[]{anoExercicio, anoExercicio}, (ResultSetHandler)new HandlerNrEmpenhos());
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
    }

    private Double getValorConsulta(String consulta) {
        try {
            return (Double)this._queryRunner.query(this._conexao, consulta, (ResultSetHandler)new HandlerValor());
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
    }

    private final class HandlerValor
    implements ResultSetHandler {
        public Object handle(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return new Double(rs.getDouble(1));
            }
            return null;
        }
    }

    private final class HandlerNrEmpenhos
    implements ResultSetHandler {
        public Object handle(ResultSet rs) throws SQLException {
            StringBuffer s = new StringBuffer("");
            if (rs.next()) {
                s.append(rs.getString(1));
                if (rs.next()) {
                    do {
                        s.append(",");
                        s.append(rs.getString(1));
                    } while (rs.next());
                }
            }
            return s.toString();
        }
    }
}

