/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.bav;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import java.math.BigDecimal;

public class BAV16
extends RegraLinha {
    public static final BigDecimal NOVES = BigDecimal.valueOf(9.999999999999E10);

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        BigDecimal saldoAtualDev = (BigDecimal)valoresCampos.getValorCampo("saldoAtualDev");
        BigDecimal saldoAtualCre = (BigDecimal)valoresCampos.getValorCampo("saldoAtualCre");
        BigDecimal saldoAntDev = (BigDecimal)valoresCampos.getValorCampo("saldoAntDev");
        BigDecimal saldoAntCre = (BigDecimal)valoresCampos.getValorCampo("saldoAntCre");
        BigDecimal movContaDeb = (BigDecimal)valoresCampos.getValorCampo("movContaDeb");
        BigDecimal movContaCre = (BigDecimal)valoresCampos.getValorCampo("movContaCre");
        String codContaBalVer = valoresCampos.getValorCampo("codContaBalVer").toString();
        BigDecimal saldoAnt = saldoAntDev.subtract(saldoAntCre).add(movContaDeb).subtract(movContaCre).subtract(saldoAtualDev).add(saldoAtualCre);
        if (saldoAnt.doubleValue() != 0.0) {
            if (saldoAtualDev.equals(NOVES) || saldoAtualCre.equals(NOVES) || saldoAntDev.equals(NOVES) || saldoAntCre.equals(NOVES) || movContaDeb.equals(NOVES) || movContaCre.equals(NOVES)) {
                System.out.println("BAV16: linha == " + numeroLinha + " ; valor com NOVES");
                return;
            }
            Object[] argumentos = new Object[]{numeroLinha, codContaBalVer};
            this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "", numeroLinha, evento.getArquivo(), argumentos);
        }
    }
}

