/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.io.Serializable;
import java.sql.Date;
import java.text.Collator;
import java.util.Comparator;

public class Igual
extends BaseRegraCampo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _valor;
    protected static Comparator<Object> _comparador = new Comparador();

    public String getValor() {
        return this._valor;
    }

    public void setValor(String valor) {
        this._valor = valor;
    }

    @Override
    public void executaLogicaVerificacaoCampo(ValoresCampos valoresCampo, Campo definicaoCampo, SituacaoVerificacao situacao, MetadadosArquivoContabil metaDados, Long linhaAtual, Integer colunaAtual) throws VerificacaoException {
        Object valorCampo;
        Object valorRegra = Igual.resolveValorAtributo(situacao.getRemessa(), metaDados, this._valor, definicaoCampo.getNome(), definicaoCampo.getTipoDadoId(), definicaoCampo.isInteiro(), definicaoCampo.getMascara(), valoresCampo);
        if (_comparador.compare(valorRegra, valorCampo = Igual.getValorCampo(valoresCampo, definicaoCampo)) != 0) {
            Object[] args = new Object[]{linhaAtual, valorRegra, valorCampo, definicaoCampo.getLabel()};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(), metaDados.getArquivo(), linhaAtual, colunaAtual, args);
        }
    }

    public static final class Comparador
    implements Comparator<Object> {
        private static final Collator collator = Collator.getInstance();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String) {
                return collator.compare((String)o1, (String)o2);
            }
            if (o1 instanceof Number) {
                double n2;
                double n1 = ((Number)o1).doubleValue();
                return n1 < (n2 = ((Number)o2).doubleValue()) ? -1 : (n1 == n2 ? 0 : 1);
            }
            if (o1 instanceof Date) {
                Date d1 = (Date)o1;
                Date d2 = (Date)o2;
                long diff = d1.getTime() - d2.getTime();
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
            throw new IllegalArgumentException("Tipo de dado desconhecido pelo Comparador: " + o1 + " - " + o2);
        }
    }
}

