/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.io.Serializable;

public final class Constante
extends BaseRegraCampo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] _conjunto;
    private int[] _conjuntoInteiro;

    public String[] getConjunto() {
        return this._conjunto;
    }

    public void setConjunto(String conjunto) {
        this._conjunto = conjunto.split(",");
    }

    @Override
    public void executaLogicaVerificacaoCampo(ValoresCampos valoresCampo, Campo definicaoCampo, SituacaoVerificacao situacao, MetadadosArquivoContabil metaDados, Long linhaAtual, Integer colunaAtual) throws VerificacaoException {
        boolean valorOK = false;
        int tipoDado = definicaoCampo.getTipoDadoId();
        Object valorCampoObj = Constante.getValorCampo(valoresCampo, definicaoCampo);
        if (tipoDado == 3) {
            if (this.getSubstring() != null) {
                throw new IllegalArgumentException("Regra Constante com tipo de dado '" + tipoDado + "' n\u00e3o permite argumento 'substring'");
            }
            if (this._conjuntoInteiro == null) {
                this._conjuntoInteiro = new int[this._conjunto.length];
                for (int i = 0; i < this._conjunto.length; ++i) {
                    this._conjuntoInteiro[i] = Integer.parseInt(this._conjunto[i]);
                }
            }
            int valorCampo = (Integer)valorCampoObj;
            for (int i = 0; i < this._conjuntoInteiro.length; ++i) {
                if (this._conjuntoInteiro[i] != valorCampo) continue;
                valorOK = true;
                break;
            }
        } else if (tipoDado == 4) {
            if (this.getSubstring() != null) {
                throw new IllegalArgumentException("Regra Constante com tipo de dado '" + tipoDado + "' n\u00e3o permite argumento 'substring'");
            }
            if (this._conjuntoInteiro == null) {
                this._conjuntoInteiro = new int[this._conjunto.length];
                for (int i = 0; i < this._conjunto.length; ++i) {
                    this._conjuntoInteiro[i] = Integer.parseInt(this._conjunto[i]);
                }
            }
            long valorCampo = ((Long)valorCampoObj).intValue();
            for (int i = 0; i < this._conjuntoInteiro.length; ++i) {
                if ((long)this._conjuntoInteiro[i] != valorCampo) continue;
                valorOK = true;
                break;
            }
        } else if (tipoDado == 1) {
            String valorCampo = (String)valorCampoObj;
            if (this.getSubstring() != null) {
                String[] substr = this.getSubstring().split(",");
                if (substr.length != 2) {
                    throw new IllegalArgumentException("Regra Constante com argumento 'substring' deveria conter dois \u00edndices: " + this.getSubstring());
                }
                Integer i1 = Constante.intOrNull(substr[0]);
                Integer i2 = Constante.intOrNull(substr[1]);
                if (i1 == null || i2 == null) {
                    throw new IllegalArgumentException("Regra Constante com argumento 'substring' deveria conter dois \u00edndices inteiros: " + substr[0] + " / " + substr[1]);
                }
                try {
                    valorCampo = valorCampo.substring(i1, i2);
                }
                catch (StringIndexOutOfBoundsException e) {
                    log.warn((Object)("StringIndexOutOfBoundsException: valorCampo='" + valorCampo + "' i1=" + i1 + " i2=" + i2));
                    valorCampo = "";
                }
            }
            for (int i = 0; i < this._conjunto.length; ++i) {
                if (!this._conjunto[i].trim().equals(valorCampo)) continue;
                valorOK = true;
                break;
            }
        } else {
            throw new IllegalArgumentException("Regra Constante n\u00e3o reconhece o tipo de dado: " + tipoDado + ". Tipo suportados: java.lang.Integer, java.lang.String");
        }
        if (!valorOK) {
            Object[] args = new Object[]{linhaAtual, valorCampoObj};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(), metaDados.getArquivo(), linhaAtual, colunaAtual, args);
        }
    }

    static Integer intOrNull(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

