/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.RegrasAssociadas;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.CondicaoComando;
import br.gov.rs.tce.pad.beans.types.EventoImportacao;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.NumeroMaximoMensagemException;
import br.gov.rs.tce.pad.excecao.RegraDesabilitadaException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.importacao.BaseRepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDBImpl;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDerbyDBImpl;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.verificacao.ExecutorRegras;
import br.gov.rs.tce.pad.modelo.verificacao.RegraAbstrata;
import br.gov.rs.tce.pad.modelo.verificacao.RegraConsultaBanco;
import br.gov.rs.tce.pad.modelo.verificacao.RegrasFactory;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jbo.ApplicationModule;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerificacaoArquivosControle {
    private Map<IdentificadorArquivo, RegrasVerificacao> _regrasArquivos = new HashMap<IdentificadorArquivo, RegrasVerificacao>();
    private Map<String, String> _regrasDesabilitadasJaAvisadas = null;
    private ImportacaoControle _importacaoControle;
    static MensagemFactory msgFactory = MensagemFactory.getInstancia();
    private static final Log log = LogFactory.getLog(VerificacaoArquivosControle.class);
    private static final boolean LOG_DEBUG_ENABLED = log.isDebugEnabled();
    private Arquivos _arquivos;
    private boolean _validaDependencias = true;

    public VerificacaoArquivosControle(Arquivos arquivos) {
        this._arquivos = arquivos;
        this._importacaoControle = new ImportacaoControle(arquivos);
        this._regrasDesabilitadasJaAvisadas = new HashMap<String, String>();
    }

    public VerificacaoArquivosControle() {
    }

    public void verificaArquivos(SituacaoVerificacao situacaoVerificacao, Connection conexao, ImportacaoListener listenerImportacao) {
        Remessa remessa = situacaoVerificacao.getRemessa();
        String lei = TipoEntidadesList.getLeiPorTipoSetor(remessa.getTipoSetor());
        List<Arquivo> arqSelecionados = this._arquivos.getArquivosPorLeiEntidade(lei, remessa.getTipoSetor(), remessa.getPeriodoInformacoes(), remessa.getMes(), remessa.getTipoOperacao());
        this.verificaArquivos(situacaoVerificacao, conexao, listenerImportacao, arqSelecionados);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verificaArquivos(SituacaoVerificacao situacaoVerificacao, Connection conexao, ImportacaoListener listenerImportacao, RepositorioArquivosControle repostiroio, List<Arquivo> arquivosSelecionados, List<File> arquivosFisicos, Integer cdRecebimento, Long cgc, ApplicationModule pioApplicationModule) {
        try {
            if (conexao == null || conexao.isClosed()) {
                throw new VerificacaoException("10018", new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new VerificacaoException("10018", new Object[0], e);
        }
        RepositorioArquivosControle repositorioArquivosControle = null;
        ContextoVerificacao contextoVerificacao = this.criaContextoVerificacao();
        try {
            ExecutorRegras executorRegras = this.constroiExecutorRegras(listenerImportacao);
            situacaoVerificacao.inicializaMetadadosArquivos(arquivosSelecionados, arquivosFisicos);
            repositorioArquivosControle = repostiroio;
            QueryRunner queryRunner = new QueryRunner();
            repositorioArquivosControle.inicializaRepositorioControle(conexao, queryRunner);
            long codigoCabecalhoBase = 0L;
            for (int index = 0; index < arquivosSelecionados.size(); ++index) {
                Long sequencial = 0L;
                contextoVerificacao.adicionaAtributo("pio.sequencial", sequencial);
                contextoVerificacao.adicionaAtributo("pio.cd.recebimento", cdRecebimento);
                contextoVerificacao.adicionaAtributo("pio.cgc", cgc);
                contextoVerificacao.adicionaAtributo("pio.app.module", pioApplicationModule);
                contextoVerificacao.adicionaAtributo("pad.conexaoDB", conexao);
                Arquivo arquivo = arquivosSelecionados.get(index);
                MetadadosArquivoContabil metadadosArquivo = situacaoVerificacao.getArquivoPorIdentificador(arquivo.getIdentificador());
                boolean dependenciasOK = true;
                if (this._validaDependencias) {
                    dependenciasOK = this._arquivos.validaDependencias(metadadosArquivo, situacaoVerificacao, msgFactory, arquivosSelecionados);
                }
                if (dependenciasOK) {
                    this._importacaoControle.importaArquivo(repositorioArquivosControle, situacaoVerificacao, contextoVerificacao, metadadosArquivo, executorRegras, listenerImportacao);
                    conexao.commit();
                    if (metadadosArquivo.getSituacao() != 3) {
                        if (codigoCabecalhoBase == 0L) {
                            codigoCabecalhoBase = metadadosArquivo.getCabecalho().getCrc32();
                        } else if (codigoCabecalhoBase != metadadosArquivo.getCabecalho().getCrc32()) {
                            try {
                                situacaoVerificacao.adicionaMensagem(msgFactory.constroiMensagem("VER_04", metadadosArquivo.getArquivo(), new Object[]{metadadosArquivo.getArquivo().getNome()}));
                            }
                            catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {}
                        }
                    }
                } else {
                    Arquivo arq = metadadosArquivo.getArquivo();
                    log.info((Object)("Arquivo '" + arq.getNome() + "' n\u00e3o importado devido a erro com dependencias. Deps: " + Arrays.asList(arq.getDependencias())));
                }
                ImportacaoEvento evento = new ImportacaoEvento(metadadosArquivo, contextoVerificacao, situacaoVerificacao, 7);
                listenerImportacao.trataEvento(evento);
                contextoVerificacao.limpaContexto();
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
        }
        finally {
            if (repositorioArquivosControle != null) {
                repositorioArquivosControle.finalizaRespositorioControle();
            }
            if (contextoVerificacao != null) {
                contextoVerificacao.limpaContexto();
            }
        }
    }

    public void verificaArquivos(SituacaoVerificacao situacaoVerificacao, Connection conexao, ImportacaoListener listenerImportacao, List<Arquivo> arquivosSelecionados) {
        try {
            if (conexao == null || conexao.isClosed()) {
                throw new VerificacaoException("10018", new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new VerificacaoException("10018", new Object[0], e);
        }
        RepositorioArquivosControle repositorioArquivosControle = null;
        ContextoVerificacao contextoVerificacao = this.criaContextoVerificacao();
        try {
            ExecutorRegras executorRegras = this.constroiExecutorRegras(listenerImportacao);
            Remessa remessa = situacaoVerificacao.getRemessa();
            situacaoVerificacao.inicializaMetadadosArquivos(arquivosSelecionados, remessa.getDiretorioOrigem());
            repositorioArquivosControle = VerificacaoArquivosControle.criaRepositorioArquivoControle(conexao);
            QueryRunner queryRunner = new QueryRunner();
            repositorioArquivosControle.inicializaRepositorioControle(conexao, queryRunner);
            long codigoCabecalhoBase = 0L;
            for (int index = 0; index < arquivosSelecionados.size(); ++index) {
                contextoVerificacao.adicionaAtributo("pad.conexaoDB", conexao);
                Arquivo arquivo = arquivosSelecionados.get(index);
                MetadadosArquivoContabil metadadosArquivo = situacaoVerificacao.getArquivoPorIdentificador(arquivo.getIdentificador());
                boolean dependenciasOK = true;
                if (this._validaDependencias) {
                    dependenciasOK = this._arquivos.validaDependencias(metadadosArquivo, situacaoVerificacao, msgFactory, arquivosSelecionados);
                }
                if (dependenciasOK) {
                    this._importacaoControle.importaArquivo(repositorioArquivosControle, situacaoVerificacao, contextoVerificacao, metadadosArquivo, executorRegras, listenerImportacao);
                    if (metadadosArquivo.getSituacao() != 3) {
                        if (codigoCabecalhoBase == 0L) {
                            codigoCabecalhoBase = metadadosArquivo.getCabecalho().getCrc32();
                        } else if (codigoCabecalhoBase != metadadosArquivo.getCabecalho().getCrc32()) {
                            try {
                                situacaoVerificacao.adicionaMensagem(msgFactory.constroiMensagem("VER_04", metadadosArquivo.getArquivo(), new Object[]{metadadosArquivo.getArquivo().getNome()}));
                            }
                            catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {}
                        }
                    }
                } else {
                    Arquivo arq = metadadosArquivo.getArquivo();
                    log.info((Object)("Arquivo '" + arq.getNome() + "' n\u00e3o importado devido a erro com dependencias. Deps: " + Arrays.asList(arq.getDependencias())));
                }
                ImportacaoEvento evento = new ImportacaoEvento(metadadosArquivo, contextoVerificacao, situacaoVerificacao, 7);
                listenerImportacao.trataEvento(evento);
                contextoVerificacao.limpaContexto();
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof OutOfMemoryError) {
                log.info((Object)("Erro OutOfMemoryError: used mem=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
            }
            throw new RuntimeException(e);
        }
        finally {
            if (repositorioArquivosControle != null) {
                repositorioArquivosControle.finalizaRespositorioControle();
            }
            if (contextoVerificacao != null) {
                contextoVerificacao.limpaContexto();
            }
        }
    }

    public static synchronized RepositorioArquivosControle criaRepositorioArquivoControle(Connection conexao) {
        BaseRepositorioArquivosControle repositorioArquivosControle;
        TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(conexao);
        if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
            repositorioArquivosControle = new RepositorioArquivosControleDBImpl();
        } else if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
            repositorioArquivosControle = new RepositorioArquivosControleDerbyDBImpl();
        } else {
            throw new ConfiguracaoException("Tipo de banco de dados desconhecido -> " + tipoBanco);
        }
        return repositorioArquivosControle;
    }

    private ContextoVerificacao criaContextoVerificacao() {
        return new ContextoVerificacao();
    }

    private RegrasVerificacao getRegrasAssociadasArquivo(IdentificadorArquivo idArquivo, RegrasAssociadas regrasAssociadas) {
        RegrasVerificacao regras = this._regrasArquivos.get(idArquivo);
        if (regras == null) {
            regras = new RegrasVerificacao();
            if (regrasAssociadas != null) {
                regras.regrasExecucaoFK = regrasAssociadas.getRegrasAssociadas(EventoImportacao.FK_CONSULTA, CondicaoComando.APOS);
                regras.regrasAposCarga = regrasAssociadas.getRegrasAssociadas(EventoImportacao.CARGA, CondicaoComando.APOS);
                regras.regrasAntesCarga = regrasAssociadas.getRegrasAssociadas(EventoImportacao.CARGA, CondicaoComando.ANTES);
                regras.regrasAposLL = regrasAssociadas.getRegrasAssociadas(EventoImportacao.LEITURA_LINHA, CondicaoComando.APOS);
                regras.regrasAntesLL = regrasAssociadas.getRegrasAssociadas(EventoImportacao.LEITURA_LINHA, CondicaoComando.ANTES);
                this._regrasArquivos.put(idArquivo, regras);
            }
        }
        return regras;
    }

    public ExecutorRegras constroiExecutorRegras(ImportacaoListener listener) {
        return new ExecutorRegrasVerificacao(listener);
    }

    public void setValidaDependencias(boolean validaDependencias) {
        this._validaDependencias = validaDependencias;
    }

    public boolean isValidaDependencias() {
        return this._validaDependencias;
    }

    private class RegrasVerificacao {
        private List<String> regrasAposCarga = Collections.emptyList();
        private List<String> regrasAntesCarga = Collections.emptyList();
        private List<String> regrasAntesLL = Collections.emptyList();
        private List<String> regrasAposLL = Collections.emptyList();
        private List<String> regrasExecucaoFK = Collections.emptyList();

        private RegrasVerificacao() {
        }

        protected Iterator<String> recuperaListaRegras(ImportacaoEvento evento) {
            Iterator<String> regras = null;
            switch (evento.getTipoEvento()) {
                case 2: {
                    regras = this.regrasAntesLL.iterator();
                    break;
                }
                case 3: {
                    regras = this.regrasAposLL.iterator();
                    break;
                }
                case 0: {
                    regras = this.regrasAntesCarga.iterator();
                    break;
                }
                case 1: {
                    regras = this.regrasAposCarga.iterator();
                    break;
                }
                case 8: {
                    regras = this.regrasExecucaoFK.iterator();
                }
            }
            return regras;
        }
    }

    public class ExecutorRegrasVerificacao
    implements ExecutorRegras {
        private ImportacaoListener _listener;
        private QueryRunner _queryRunner;
        static final long APOS_CARGA_ELAPSED_LIMIT = 0L;

        public ExecutorRegrasVerificacao(ImportacaoListener listener) {
            this._listener = listener;
            this._queryRunner = new QueryRunner();
        }

        @Override
        public boolean executaRegraVerificacao(String nomeRegra, ImportacaoEvento evento) throws RegraDesabilitadaException {
            Remessa remessa;
            RegraAbstrata regra = null;
            RegrasFactory regrasFactory = null;
            boolean executou = false;
            regrasFactory = RegrasFactory.getInstancia();
            regra = regrasFactory.constroiRegra(nomeRegra);
            String codigoRegra = regra.getCodigoMensagem();
            if (regra instanceof RegraConsultaBanco) {
                ((RegraConsultaBanco)regra).setConexao((Connection)evento.getContextoVerificacao().getAtributo("pad.conexaoDB"));
                ((RegraConsultaBanco)regra).setQueryRunner(this._queryRunner);
            }
            if ((remessa = evento.getSituacaoVerificacao().getRemessa()).isRegraDesabilitada(codigoRegra)) {
                if (!VerificacaoArquivosControle.this._regrasDesabilitadasJaAvisadas.containsKey(codigoRegra)) {
                    VerificacaoArquivosControle.this._regrasDesabilitadasJaAvisadas.put(codigoRegra, codigoRegra);
                    throw new RegraDesabilitadaException(codigoRegra, "manual");
                }
            } else if (this.execucaoPermitida(regra, evento.getSituacaoVerificacao())) {
                if (LOG_DEBUG_ENABLED) {
                    log.debug((Object)("   Executando regra: " + codigoRegra + " para o arquivo: " + evento.getNomeArquivo()));
                }
                this._listener.trataEvento(evento);
                regra.executaRegra(evento);
                executou = true;
            }
            return executou;
        }

        private boolean execucaoPermitida(RegraAbstrata regra, SituacaoVerificacao situacao) {
            boolean isPermitido = false;
            Remessa remessa = situacao.getRemessa();
            isPermitido = regra.executaParaEntidade(remessa.getTipoSetor());
            if (LOG_DEBUG_ENABLED) {
                log.debug((Object)("Execu\u00e7\u00e3o " + isPermitido + " para entidade: " + remessa.getTipoSetor()));
            }
            if (isPermitido) {
                isPermitido = this.validaDependencias(situacao, regra);
                if (isPermitido) {
                    isPermitido = regra.executarParaPeriodo(remessa.getPeriodoInformacoes());
                }
                if (isPermitido) {
                    isPermitido = regra.executarParaMes(remessa.getMes());
                }
                if (LOG_DEBUG_ENABLED) {
                    log.debug((Object)("Execu\u00e7\u00e3o " + isPermitido + " para periodo: " + remessa.getPeriodoInformacoes()));
                }
            }
            return isPermitido;
        }

        private boolean validaDependencias(SituacaoVerificacao verificacao, RegraAbstrata regra) {
            boolean dependenciaOk = true;
            if (regra._configuracao.getDependencias() != null) {
                IdentificadorArquivo[] dependencias = regra._configuracao.getDependencias();
                for (int index = 0; index < dependencias.length; ++index) {
                    if (verificacao.containsArquivoPorIdentificador(dependencias[index])) {
                        MetadadosArquivoContabil metadadosArquivoContabil = verificacao.getArquivoPorIdentificador(dependencias[index]);
                        if (metadadosArquivoContabil != null) {
                            if (metadadosArquivoContabil.getSituacao() != 2 && metadadosArquivoContabil.getSituacao() != 3) continue;
                            dependenciaOk = false;
                            break;
                        }
                        dependenciaOk = false;
                        break;
                    }
                    dependenciaOk = false;
                    break;
                }
            }
            return dependenciaOk;
        }

        @Override
        public boolean executaRegrasVerificacao(Arquivo arquivo, ImportacaoEvento evento) {
            RegrasAssociadas regrasAssociadas = arquivo.getRegrasAssociadas();
            RegrasVerificacao regras = VerificacaoArquivosControle.this.getRegrasAssociadasArquivo(arquivo.getIdentificador(), regrasAssociadas);
            boolean executou = false;
            Iterator<String> regrasIterator = regras.recuperaListaRegras(evento);
            if (regrasIterator != null) {
                while (regrasIterator.hasNext()) {
                    long elapsed;
                    String nomeRegra = regrasIterator.next();
                    long init = System.currentTimeMillis();
                    try {
                        String tipoEvento;
                        if (evento.getTipoEvento() == 1) {
                            this._listener.trataEvento(new ImportacaoEvento(evento.getMetadadosArquivoAtual(), evento.getContextoVerificacao(), evento.getSituacaoVerificacao(), nomeRegra));
                        }
                        executou = this.executaRegraVerificacao(nomeRegra, evento);
                        if (evento.getTipoEvento() != 1 && evento.getTipoEvento() != 8) continue;
                        String string = tipoEvento = evento.getTipoEvento() == 1 ? "APOS_CARGA" : "FK_CONSULTA";
                        if (executou) {
                            elapsed = System.currentTimeMillis() - init;
                            log.info((Object)("   [" + tipoEvento + "] Executou regra " + nomeRegra + " para o arquivo " + evento.getNomeArquivo() + " em " + elapsed + "ms"));
                            continue;
                        }
                        log.info((Object)("   [" + tipoEvento + "] N\u00e3o executou regra " + nomeRegra + " para o arquivo " + evento.getNomeArquivo()));
                    }
                    catch (RegraDesabilitadaException e) {
                        SituacaoVerificacao situacao = evento.getSituacaoVerificacao();
                        situacao.adicionaMensagem(msgFactory.constroiMensagem("VER_07", arquivo, new String[]{nomeRegra, e.getFormaDesabilitacao()}));
                    }
                    catch (NumeroMaximoMensagemException e) {
                        elapsed = System.currentTimeMillis() - init;
                        if (elapsed > 0L) {
                            log.info((Object)("   [NumeroMaximoMensagemException(#" + e.getQuantidade() + ")] Executou regra " + nomeRegra + " para o arquivo " + evento.getNomeArquivo() + " em " + elapsed + "ms [>" + 0L + "ms]"));
                        }
                        if (VersaoUtils.isDebugModeEnabled()) continue;
                        throw e;
                    }
                    catch (VerificacaoException e) {
                        elapsed = System.currentTimeMillis() - init;
                        log.info((Object)("   [VerificacaoException] Executou regra " + nomeRegra + " para o arquivo " + evento.getNomeArquivo() + " em " + elapsed + "ms [>" + 0L + "ms]"));
                        log.info((Object)("   [Exception] Regra " + nomeRegra + " para o arquivo " + evento.getNomeArquivo() + " gerou erro: "), (Throwable)((Object)e));
                        throw e;
                    }
                }
            }
            return executou;
        }
    }
}

