/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.servico.negocio;

import br.gov.rs.tce.adf.modelo.negocio.TCEEntityImpl;
import br.gov.rs.tce.pad.excecao.CampoInvalidoException;
import br.gov.rs.tce.pad.modelo.servico.negocio.RemessasImpl;
import br.gov.rs.tce.pad.util.ValidaCPF;
import java.math.BigDecimal;
import java.sql.Date;
import oracle.jbo.Key;
import oracle.jbo.RowIterator;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.TransactionEvent;

public class ResponsaveisImpl
extends TCEEntityImpl {
    public static final int CODMUNICIPIO = 0;
    public static final int CDREMESSA = 1;
    public static final int CDENTIDADE = 2;
    public static final int CPF = 3;
    public static final int BAIRRO = 4;
    public static final int CARGO = 5;
    public static final int CEP = 6;
    public static final int COMPL = 7;
    public static final int DTATO = 8;
    public static final int DTINICIO = 9;
    public static final int DTNASCIMENTO = 10;
    public static final int DTTERMINO = 11;
    public static final int EMAIL = 12;
    public static final int ESTADOCIVIL = 13;
    public static final int IDPREFEITURACAMARA = 14;
    public static final int LOGRADOURO = 15;
    public static final int NACIONALIDADE = 16;
    public static final int NMMAE = 17;
    public static final int NMPAI = 18;
    public static final int NOME = 19;
    public static final int NR = 20;
    public static final int RG = 21;
    public static final int TELEFONE = 22;
    public static final int TPATO = 23;
    public static final int TPRESPONSAVEL = 24;
    public static final int REMESSAS = 25;
    public static final int SUBSTITUICOES = 26;
    public static final int SUBSTITUICOES1 = 27;
    private static EntityDefImpl mDefinitionObject;

    public static synchronized EntityDefImpl getDefinitionObject() {
        if (mDefinitionObject == null) {
            mDefinitionObject = EntityDefImpl.findDefObject((String)"br.gov.rs.tce.pad.modelo.servico.negocio.Responsaveis");
        }
        return mDefinitionObject;
    }

    public BigDecimal getCodMunicipio() {
        return (BigDecimal)this.getAttributeInternal(0);
    }

    public BigDecimal getCdRemessa() {
        return (BigDecimal)this.getAttributeInternal(1);
    }

    public void setCdRemessa(BigDecimal value) {
        this.setAttributeInternal(1, value);
    }

    public BigDecimal getCdEntidade() {
        return (BigDecimal)this.getAttributeInternal(2);
    }

    public void setCdEntidade(BigDecimal value) {
        this.setAttributeInternal(2, value);
    }

    public BigDecimal getCpf() {
        return (BigDecimal)this.getAttributeInternal(3);
    }

    public void setCpf(BigDecimal value) {
        if (value == null || String.valueOf(value.intValue()).length() > 11) {
            throw new CampoInvalidoException("Campo CPF deve estar preenchido adequadamente.");
        }
        if (!ValidaCPF.validaCPF(value)) {
            throw new CampoInvalidoException("O CPF informado \u00e9 inv\u00e1lido");
        }
        this.setAttributeInternal(3, value);
    }

    protected Object getAttrInvokeAccessor(int index, AttributeDefImpl attrDef) throws Exception {
        switch (index) {
            case 0: {
                return this.getCodMunicipio();
            }
            case 1: {
                return this.getCdRemessa();
            }
            case 2: {
                return this.getCdEntidade();
            }
            case 3: {
                return this.getCpf();
            }
            case 4: {
                return this.getBairro();
            }
            case 5: {
                return this.getCargo();
            }
            case 6: {
                return this.getCep();
            }
            case 7: {
                return this.getCompl();
            }
            case 8: {
                return this.getDtAto();
            }
            case 9: {
                return this.getDtInicio();
            }
            case 10: {
                return this.getDtNascimento();
            }
            case 11: {
                return this.getDtTermino();
            }
            case 12: {
                return this.getEmail();
            }
            case 13: {
                return this.getEstadoCivil();
            }
            case 14: {
                return this.getIdPrefeituraCamara();
            }
            case 15: {
                return this.getLogradouro();
            }
            case 16: {
                return this.getNacionalidade();
            }
            case 17: {
                return this.getNmMae();
            }
            case 18: {
                return this.getNmPai();
            }
            case 19: {
                return this.getNome();
            }
            case 20: {
                return this.getNr();
            }
            case 21: {
                return this.getRg();
            }
            case 22: {
                return this.getTelefone();
            }
            case 23: {
                return this.getTpAto();
            }
            case 24: {
                return this.getTpResponsavel();
            }
            case 26: {
                return this.getSubstituicoes();
            }
            case 27: {
                return this.getSubstituicoes1();
            }
            case 25: {
                return this.getRemessas();
            }
        }
        return super.getAttrInvokeAccessor(index, attrDef);
    }

    protected void setAttrInvokeAccessor(int index, Object value, AttributeDefImpl attrDef) throws Exception {
        switch (index) {
            case 0: {
                this.setCodMunicipio((BigDecimal)value);
                return;
            }
            case 1: {
                this.setCdRemessa((BigDecimal)value);
                return;
            }
            case 2: {
                this.setCdEntidade((BigDecimal)value);
                return;
            }
            case 3: {
                this.setCpf((BigDecimal)value);
                return;
            }
            case 4: {
                this.setBairro((String)value);
                return;
            }
            case 5: {
                this.setCargo((String)value);
                return;
            }
            case 6: {
                this.setCep((BigDecimal)value);
                return;
            }
            case 7: {
                this.setCompl((String)value);
                return;
            }
            case 8: {
                this.setDtAto((Date)value);
                return;
            }
            case 9: {
                this.setDtInicio((Date)value);
                return;
            }
            case 10: {
                this.setDtNascimento((Date)value);
                return;
            }
            case 11: {
                this.setDtTermino((Date)value);
                return;
            }
            case 12: {
                this.setEmail((String)value);
                return;
            }
            case 13: {
                this.setEstadoCivil((BigDecimal)value);
                return;
            }
            case 14: {
                this.setIdPrefeituraCamara((String)value);
                return;
            }
            case 15: {
                this.setLogradouro((String)value);
                return;
            }
            case 16: {
                this.setNacionalidade((String)value);
                return;
            }
            case 17: {
                this.setNmMae((String)value);
                return;
            }
            case 18: {
                this.setNmPai((String)value);
                return;
            }
            case 19: {
                this.setNome((String)value);
                return;
            }
            case 20: {
                this.setNr((String)value);
                return;
            }
            case 21: {
                this.setRg((String)value);
                return;
            }
            case 22: {
                this.setTelefone((String)value);
                return;
            }
            case 23: {
                this.setTpAto((String)value);
                return;
            }
            case 24: {
                this.setTpResponsavel((String)value);
                return;
            }
        }
        super.setAttrInvokeAccessor(index, value, attrDef);
    }

    public RemessasImpl getRemessas() {
        return (RemessasImpl)((Object)this.getAttributeInternal(25));
    }

    public void setRemessas(RemessasImpl value) {
        this.setAttributeInternal(25, (Object)value);
    }

    public String getBairro() {
        return (String)this.getAttributeInternal(4);
    }

    public void setBairro(String value) {
        if (value.equals("")) {
            throw new CampoInvalidoException("\u00c9 necess\u00e1rio informar o Bairro.");
        }
        if (!this.validateTamanhoMinimo(value)) {
            throw new CampoInvalidoException("O Campo Bairro deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(4, value);
    }

    public String getCargo() {
        return (String)this.getAttributeInternal(5);
    }

    public void setCargo(String value) {
        this.setAttributeInternal(5, value);
    }

    public BigDecimal getCep() {
        return (BigDecimal)this.getAttributeInternal(6);
    }

    public void setCep(BigDecimal value) {
        if (value == null || String.valueOf(Math.abs(value.intValue())).length() != 8) {
            throw new CampoInvalidoException("O CEP informado \u00e9 inv\u00e1lido. Deve ter 8 D\u00edgitos.");
        }
        this.setAttributeInternal(6, value);
    }

    public String getCompl() {
        return (String)this.getAttributeInternal(7);
    }

    public void setCompl(String value) {
        this.setAttributeInternal(7, value);
    }

    public Date getDtAto() {
        return (Date)this.getAttributeInternal(8);
    }

    public void setDtAto(Date value) {
        if (value == null) {
            throw new CampoInvalidoException("Campo Data do Ato deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(8, value);
    }

    public Date getDtInicio() {
        return (Date)this.getAttributeInternal(9);
    }

    public void setDtInicio(Date value) {
        if (value == null) {
            throw new CampoInvalidoException("Campo Data de In\u00edcio de Mandato deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(9, value);
    }

    public Date getDtNascimento() {
        return (Date)this.getAttributeInternal(10);
    }

    public void setDtNascimento(Date value) {
        if (value == null) {
            throw new CampoInvalidoException("Campo Data de Nascimento deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(10, value);
    }

    public Date getDtTermino() {
        return (Date)this.getAttributeInternal(11);
    }

    public void setDtTermino(Date value) {
        if (value == null) {
            throw new CampoInvalidoException("Campo Data de T\u00e9rmino de mandato deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(11, value);
    }

    public String getEmail() {
        return (String)this.getAttributeInternal(12);
    }

    public void setEmail(String value) {
        if (!this.validateEmail(value)) {
            throw new CampoInvalidoException("O Campo E-mail deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(12, value);
    }

    public BigDecimal getEstadoCivil() {
        return (BigDecimal)this.getAttributeInternal(13);
    }

    public void setEstadoCivil(BigDecimal value) {
        this.setAttributeInternal(13, value);
    }

    public String getIdPrefeituraCamara() {
        return (String)this.getAttributeInternal(14);
    }

    public void setIdPrefeituraCamara(String value) {
        this.setAttributeInternal(14, value);
    }

    public String getLogradouro() {
        return (String)this.getAttributeInternal(15);
    }

    public void setLogradouro(String value) {
        if (value.trim().equals("")) {
            throw new CampoInvalidoException("\u00c9 necess\u00e1rio informar o Logradouro.");
        }
        if (!this.validateMinimoSequenciasCaracter(value)) {
            throw new CampoInvalidoException("O Campo Logradouro deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(15, value);
    }

    public String getNacionalidade() {
        return (String)this.getAttributeInternal(16);
    }

    public void setNacionalidade(String value) {
        if (!this.validateTamanhoMinimo(value)) {
            throw new CampoInvalidoException("O Campo Nacionalidade deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(16, value);
    }

    public String getNmMae() {
        return (String)this.getAttributeInternal(17);
    }

    public void setNmMae(String value) {
        if (!this.validateNome(value)) {
            throw new CampoInvalidoException("O Campo Nome M\u00e3e deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(17, value);
    }

    public String getNmPai() {
        return (String)this.getAttributeInternal(18);
    }

    public void setNmPai(String value) {
        if (value.equals("")) {
            throw new CampoInvalidoException("\u00c9 necess\u00e1rio informar o Nome Pai.");
        }
        if (!this.validateNome(value)) {
            throw new CampoInvalidoException("O Campo Nome Pai deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(18, value);
    }

    public String getNome() {
        return (String)this.getAttributeInternal(19);
    }

    public void setNome(String value) {
        if (value.equals("")) {
            throw new CampoInvalidoException("\u00c9 necess\u00e1rio informar o Nome.");
        }
        if (!this.validateNome(value)) {
            throw new CampoInvalidoException("O Campo Nome deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(19, value);
    }

    public String getNr() {
        return (String)this.getAttributeInternal(20);
    }

    public void setNr(String value) {
        this.setAttributeInternal(20, value);
    }

    public String getRg() {
        return (String)this.getAttributeInternal(21);
    }

    public void setRg(String value) {
        if (value == null || value.length() > 10) {
            throw new CampoInvalidoException("Campo RG deve estar preenchido adequadamente.");
        }
        this.setAttributeInternal(21, value);
    }

    public String getTelefone() {
        return (String)this.getAttributeInternal(22);
    }

    public void setTelefone(String value) {
        this.setAttributeInternal(22, value);
    }

    public String getTpAto() {
        return (String)this.getAttributeInternal(23);
    }

    public void setTpAto(String value) {
        if (value.equals("")) {
            throw new CampoInvalidoException("\u00c9 necess\u00e1rio informar o Tipo do Ato.");
        }
        this.setAttributeInternal(23, value);
    }

    public String getTpResponsavel() {
        return (String)this.getAttributeInternal(24);
    }

    public void setTpResponsavel(String value) {
        this.setAttributeInternal(24, value);
    }

    protected void validateEntity() {
        super.validateEntity();
    }

    public void lock() {
        super.lock();
    }

    protected void doDML(int operation, TransactionEvent e) {
        super.doDML(operation, e);
    }

    public RowIterator getSubstituicoes() {
        return (RowIterator)this.getAttributeInternal(26);
    }

    public RowIterator getSubstituicoes1() {
        return (RowIterator)this.getAttributeInternal(27);
    }

    public void setCodMunicipio(BigDecimal value) {
        this.setAttributeInternal(0, value);
    }

    public static Key createPrimaryKey(BigDecimal cdRemessa, BigDecimal cdEntidade, BigDecimal cpf, String idPrefeituraCamara, String tpResponsavel) {
        return new Key(new Object[]{cdRemessa, cdEntidade, cpf, idPrefeituraCamara, tpResponsavel});
    }
}

