/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.servico.negocio;

import br.gov.rs.tce.adf.modelo.negocio.TCEEntityImpl;
import br.gov.rs.tce.pad.excecao.CampoInvalidoException;
import br.gov.rs.tce.pad.modelo.servico.negocio.RemessasImpl;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import oracle.jbo.AttributeList;
import oracle.jbo.Key;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.EntityDefImpl;

public class EntIndiretasImpl
extends TCEEntityImpl {
    public static final int CDENTIDADE = 0;
    public static final int REMESSAS1 = 9;
    public static final int CDREMESSA = 1;
    public static final int CNPJ = 2;
    public static final int NOMEENTIDADE = 3;
    public static final int RPPS = 4;
    public static final int CODORGAO = 5;
    public static final int STATUS = 6;
    public static final int STATUSCONSOLIDACAO = 7;
    public static final int TIPOSETORGOV = 8;
    private static EntityDefImpl mDefinitionObject;

    public static synchronized EntityDefImpl getDefinitionObject() {
        if (mDefinitionObject == null) {
            mDefinitionObject = EntityDefImpl.findDefObject((String)"br.gov.rs.tce.pad.modelo.servico.negocio.EntIndiretas");
        }
        return mDefinitionObject;
    }

    public Integer getCdEntidade() {
        return (Integer)this.getAttributeInternal(0);
    }

    public void setCdEntidade(Integer value) {
        this.setAttributeInternal(0, value);
    }

    public Integer getCdRemessa() {
        return (Integer)this.getAttributeInternal(1);
    }

    public void setCdRemessa(Integer value) {
        this.setAttributeInternal(1, value);
    }

    public String getCnpj() {
        return (String)this.getAttributeInternal(2);
    }

    public void setCnpj(String value) {
        if (value == null || value.length() > 14 || value.length() == 0) {
            throw new CampoInvalidoException("O CNPJ informado \u00e9 inv\u00e1lido.");
        }
        if (!ValidaCNPJ.validaCnpj(value)) {
            throw new CampoInvalidoException("O CNPJ informado \u00e9 inv\u00e1lido");
        }
        this.setAttributeInternal(2, value);
    }

    public String getNomeEntidade() {
        return (String)this.getAttributeInternal(3);
    }

    public void setNomeEntidade(String value) {
        if (value == null || value.length() < 3) {
            throw new CampoInvalidoException("O nome da entidade deve possui no m\u00ednimo 3 caracteres.");
        }
        this.setAttributeInternal(3, value);
    }

    public Integer getRpps() {
        return (Integer)this.getAttributeInternal(4);
    }

    public void setRpps(Integer value) {
        this.setAttributeInternal(4, value);
    }

    public Integer getCodOrgao() {
        return (Integer)this.getAttributeInternal(5);
    }

    public void setCodOrgao(Integer value) {
        this.setAttributeInternal(5, value);
    }

    public String getStatus() {
        return (String)this.getAttributeInternal(6);
    }

    public void setStatus(String value) {
        this.setAttributeInternal(6, value);
    }

    public Integer getStatusConsolidacao() {
        return (Integer)this.getAttributeInternal(7);
    }

    public void setStatusConsolidacao(Integer value) {
        this.setAttributeInternal(7, value);
    }

    protected Object getAttrInvokeAccessor(int index, AttributeDefImpl attrDef) throws Exception {
        switch (index) {
            case 0: {
                return this.getCdEntidade();
            }
            case 1: {
                return this.getCdRemessa();
            }
            case 2: {
                return this.getCnpj();
            }
            case 3: {
                return this.getNomeEntidade();
            }
            case 4: {
                return this.getRpps();
            }
            case 5: {
                return this.getCodOrgao();
            }
            case 6: {
                return this.getStatus();
            }
            case 7: {
                return this.getStatusConsolidacao();
            }
            case 8: {
                return this.getTipoSetorGov();
            }
        }
        return super.getAttrInvokeAccessor(index, attrDef);
    }

    protected void setAttrInvokeAccessor(int index, Object value, AttributeDefImpl attrDef) throws Exception {
        switch (index) {
            case 0: {
                this.setCdEntidade((Integer)value);
                return;
            }
            case 1: {
                this.setCdRemessa((Integer)value);
                return;
            }
            case 2: {
                this.setCnpj((String)value);
                return;
            }
            case 3: {
                this.setNomeEntidade((String)value);
                return;
            }
            case 4: {
                this.setRpps((Integer)value);
                return;
            }
            case 5: {
                this.setCodOrgao((Integer)value);
                return;
            }
            case 6: {
                this.setStatus((String)value);
                return;
            }
            case 7: {
                this.setStatusConsolidacao((Integer)value);
                return;
            }
            case 8: {
                this.setTipoSetorGov((String)value);
                return;
            }
        }
        super.setAttrInvokeAccessor(index, value, attrDef);
    }

    public String getTipoSetorGov() {
        return (String)this.getAttributeInternal(8);
    }

    public void setTipoSetorGov(String value) {
        this.setAttributeInternal(8, value);
    }

    public void remove() {
        if ("P".equals(this.getStatus())) {
            this.setStatus("E");
        }
        super.remove();
    }

    public boolean validateCNPJ(String cnpj) {
        return ValidaCNPJ.validaCnpj(cnpj);
    }

    public RemessasImpl getRemessas1() {
        return (RemessasImpl)((Object)this.getAttributeInternal(9));
    }

    public void setRemessas1(RemessasImpl value) {
        this.setAttributeInternal(9, (Object)value);
    }

    protected void create(AttributeList attributeList) {
        super.create(attributeList);
    }

    public static Key createPrimaryKey(Integer cdEntidade, Integer cdRemessa, String cnpj, String status) {
        return new Key(new Object[]{cdEntidade, cdRemessa, cnpj, status});
    }
}

