/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.seguranca.test;

import br.gov.rs.tce.assdigital.excecao.AssinaturaDigitalException;
import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.util.Base64Utils;
import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class AssinaturaDigitalControleTest {
    @Test
    public void testCreateDigitalSign() {
        AssinaturaDigitalControle.CertificationChainAndSignature cc;
        String dir = "R:/priv";
        File file = new File(dir + "/arquivos.xml");
        File ksFile = new File(dir + "/saop_cert.pfx");
        try {
            cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(file, ksFile, "GPHE6-ENKJ6-YOUE7");
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        Assert.assertNotNull((Object)cc);
        System.out.println("\n" + cc.getSignature());
        System.out.println(cc.getCertificationChain());
    }

    @Test
    public void testCreateDigitalSignStep() {
        boolean ok;
        AssinaturaDigitalControle.CertificationChainAndSignature cc;
        String dirsrc = "../PAD-Modelo/src";
        String dir = "R:/priv";
        File file = new File(dirsrc + "/arquivos.xml");
        File ksFile = new File(dir + "/saop_cert.pfx");
        try {
            cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(file, ksFile, "GPHE6-ENKJ6-YOUE7");
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        Assert.assertNotNull((Object)cc);
        byte[] signature = Base64Utils.base64Decode(cc.getSignature());
        try {
            ok = AssinaturaDigitalControle.validaAssinaturaDigital(file, cc.getCertificationChain(), signature);
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        Assert.assertTrue((String)"Assinatura deve conferir !!!", (boolean)ok);
        signature = Base64Utils.base64Decode(cc.getSignature());
        signature[1] = 2;
        try {
            ok = AssinaturaDigitalControle.validaAssinaturaDigital(file, cc.getCertificationChain(), signature);
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        Assert.assertFalse((String)"Assinatura deve n\u00e3o conferir !!!", (boolean)ok);
    }

    @Test
    public void testCreateDigest() {
        byte[] digest;
        String dirsrc = "../PAD-Modelo/src";
        File file = new File(dirsrc + "/arquivos.xml");
        try {
            digest = AssinaturaDigitalControle.calculaDigest(file);
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        Assert.assertNotNull((Object)digest);
        Assert.assertEquals((Object)"tgwVDZKCYcXAFV76giJm+gf6tbc=", (Object)Base64Utils.base64Encode(digest));
    }

    @Test
    public void testManualSignatureCriptAssimetric() {
    }
}

