/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.relatorio;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.test.AbstractImportacaoRegras;
import br.gov.rs.tce.pad.modelo.relatorio.RelatorioAbstractTest;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.junit.After;
import org.junit.Test;

public class RelatorioIntegracaoTest
extends RelatorioAbstractTest {
    AbstractImportacaoRegras imp = new AbstractImportacaoRegras(){};
    final String derbyNetUrl = "localhost:1527/database";
    String dirTaquarucu2013b6 = "../PAD-Desktop/src_test/2013b6-taquarucu";
    static final String dirBase14 = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi";
    static final String dirBase15 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI";
    static final String dirBase16 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16";
    String dirPmGuapore2014b6 = "R:\\misc\\casos de uso\\Vers\u00e3o 14.2 - demonstrativos\\Exemplo 2014\\PM\\6\u00ba bi\\PM DE GUAPOR\u00c9";
    String dirPmBento2014b6 = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Bento Gon\u00e7alves_Origem_6\u00babi2013_real/Arquivos testes";
    String dirPmPassoFundo2014b6 = "R:\\misc\\casos de uso\\Vers\u00e3o 14.2 - demonstrativos\\Exemplo 2014\\PM\\6\u00ba bi\\PM de Passo Fundo_Origem_6\u00babi2013_real\\Arquivos testes";
    String dirPmSapucaia2014b6 = "R:\\misc\\casos de uso\\Vers\u00e3o 14.2 - demonstrativos\\Exemplo 2014\\PM\\6\u00ba bi\\PM DE SAPUCAIA DO SUL";
    String dirPmVilaNovaDoSul2014b6 = "R:\\misc\\casos de uso\\Vers\u00e3o 14.2 - demonstrativos\\Exemplo 2014\\PM\\6\u00ba bi\\PM DE VILA NOVA DO SUL";
    String dirPMTioHugo = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Tio Hugo_Origem_6\u00babi2013_real/Arquivos testes";
    String dirPMPortoXavier = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Porto Xavier_Origem_6\u00babi2013_real/Arquivos testes";
    String dirPMNovaBoaVista = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Nova Boa Vista_Origem_Tch\u00ea/Arquivos TEstes";
    String dirPMSantaTereza = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Santa Tereza_Origem_ Infotec/Arquivos Testes";
    String dirPMSelbach = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/Exemplo RCL/PAD_SELBACH";
    String dirPMNovaCandelaria = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/Exemplos Abase/arquivos_txt";
    static String dirPmVenancioAires = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM VENANCIO AIRES_Origem_Thema/Arquivos de testes";
    static String dirPmCruzaltense = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/PM de Cruzaltense_Origem_Systempro/Arquivos Teste";
    static String dirCMBento2014b6 = "R:/misc/casos de uso/Vers\u00e3o 14.2 - demonstrativos/Exemplo 2014/PM/6\u00ba bi/../../CM/6\u00ba Bi/CM de Bento Gon\u00e7alves_Origem_6\u00babi2013_real/Arquivos testes";
    static String dirPMNovaCandelaria2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM Nova Candel\u00e1ria _origem_6\u00babi";
    static String dirPmMostardas2015 = "R:\\misc\\casos de uso\\Vers\u00e3o 15\\PM\\6\u00ba BI\\PM de Mostardas";
    static String dirPmCoronelBicaco2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM Coronel Bicaco_origem_6\u00babi2014/Alterado BAL_REC";
    static String dirPmHorizontina2015 = "R:\\misc\\casos de uso\\Vers\u00e3o 15\\PM\\6\u00ba BI\\PM de Horizontina";
    static String dirPmItaqui2015 = "R:\\misc\\casos de uso\\Vers\u00e3o 15\\PM\\6\u00ba BI\\PM Itaqui";
    static String dirPmTapes2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM de Tapes com BVER_ENC";
    static String dirPmRioGrande2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM Rio Grande_origem_6\u00b0 BI 2014";
    static String dirPmSantaRosa2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM Santa Rosa_6\u00ba_origem BI 2014";
    static String dirPmSantaBarbara2015 = "R:/misc/casos de uso/Vers\u00e3o 15/PM/6\u00ba BI/PM Santa B\u00e1rbara_origem_6\u00ba Bi 2014";
    static String dirPmBento2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Bento Gon\u00e7alves_origem_6\u00ba bi_2015";
    static String dirPmPortoXavier2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Porto Xavier";
    static String dirPmNovoHamburgo2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Novo Hamburgo/MesReferencia12";
    boolean removeTabelas = false;
    int versao = 47;
    static String dirPmVenancio2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Venancio Aires_origem_contador";
    static String dirPmSantaRosa2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Santa Rosa_origem_6\u00babi_2015";
    static String dirPmTucunduva2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Tucunduva_origem_6\u00babi_2015 - erros corrigidos";
    static String dirPmTucunduvaRv2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Tucunduva_origem_6\u00babi_2015 - inclus\u00e3o RV";
    static String dirPmQuevedos2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Quevedo_origem_6\u00babi_2015";
    static String dirPmAlegria2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Alegria_origem_6\u00babi_2015_alterado";
    static String dirPmCacapava2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM Ca\u00e7apava do Sul_origem_6\u00ba_BI 2015";
    static String dirPmRioGrande2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM Rio Grande_origem_6\u00ba_Bi_2015";
    static String dirPmTresForquilhas2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Tr\u00eas Forquilhas_origem_6\u00ba Bi_2015";
    static String dirPmSantoCristo2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de Santo Cristo_origem_jurisdicionado";
    static String dirPmSaoLuizGonzaga2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/PM/6\u00ba Bi/PM de S\u00e3o Luiz Gonzaga_6oBi_2016/BIMESTRE6";
    static String dirInstPanambi2016 = "/mnt/R/misc/casos de uso/Vers\u00e3o 16/Autarquia/6\u00ba Bi/Inst Panambi geracao_arquivo_20170126_(1)";
    String[] IDS_ARQUIVOS_PADRAO = new String[]{"ORGAO", "UNIORCAM", "RECURSO", "FUNCAO", "SUBFUNC", "PROGRAMA", "PROJATIV", "RUBRICA", "CREDOR", "EMPENHO", "LIQUIDAC", "PAGAMENT", "BAL_VER", "BVER_ENC", "BAL_REC", "BAL_DESP", "CTA_DISP"};

    public void before() {
        this.imp.setupGenericoRede("localhost:1527/database", this.removeTabelas);
    }

    @After
    public void after() {
        this.imp.teardown();
    }

    public void testDcBalPatrimonial() throws IOException, TransformerException {
        String[] ids = this.IDS_ARQUIVOS_PADRAO;
        this.removeTabelas = true;
        SituacaoVerificacao sitv = null;
        this.imp.setupGenericoRede("localhost:1527/database", this.removeTabelas);
        String idOrgao = "55100";
        sitv = this.imp.verificaArquivos(ids, 2016, 6, 55100, "87613667000148", dirPmPortoXavier2016);
        RelatorioIntegracaoTest.showMessages(sitv);
        String xmlOutputFile = "dc-balpat-v" + this.versao + "_" + idOrgao + ".xml";
        this.geraXML("consultas-dc-balpat.xml", null, xmlOutputFile, null);
        RelatorioIntegracaoTest.runXslt(new File("output/test/" + xmlOutputFile), new File("../PAD-Modelo/xsl/pad-dc-balpat.xsl"), new File("output/test/dc-balpat-v" + this.versao + "_" + idOrgao + ".csv"));
        this.geraPDF("dc-balpat-v" + this.versao + "_" + idOrgao + ".pdf", xmlOutputFile, "dc-balpat.xsl");
    }

    @Test
    public void testDcBalOrcamentario() throws IOException, TransformerException {
        String[] ids = this.IDS_ARQUIVOS_PADRAO;
        SituacaoVerificacao sitv = null;
        this.imp.setupGenericoRede("localhost:1527/database", this.removeTabelas);
        String idOrgao = "87996";
        sitv = this.imp.verificaArquivos(ids, 2016, 6, 87996, "01871402000124", dirInstPanambi2016, "A");
        RelatorioIntegracaoTest.showMessages(sitv);
        String xmlOutputFile = "dc-balorc-v" + this.versao + "." + idOrgao + ".xml";
        this.geraXML("consultas-dc-balorc.xml", null, xmlOutputFile, null);
        RelatorioIntegracaoTest.runXslt(new File("output/test/" + xmlOutputFile), new File("../PAD-Modelo/xsl/pad-dc-balorc.xsl"), new File("output/test/dc-balorc-v" + this.versao + "." + idOrgao + ".csv"));
        this.geraPDF("dc-balorc-v" + this.versao + "." + idOrgao + ".pdf", xmlOutputFile, "dc-balorc.xsl");
    }

    public void testDcDemonstracaoVariacoesPatrimoniais() throws IOException, TransformerException {
        SituacaoVerificacao sitv = null;
        String[] ids = this.IDS_ARQUIVOS_PADRAO;
        this.imp.setupGenericoRede("localhost:1527/database", this.removeTabelas);
        String idOrgao = "79600";
        sitv = this.imp.verificaArquivos(ids, 2016, 6, 79600, "94444122000110", dirPmQuevedos2016);
        RelatorioIntegracaoTest.showMessages(sitv);
        String xmlOutputFile = "dc-dvp-v" + this.versao + "." + idOrgao + ".xml";
        this.geraXML("consultas-dc-dvp.xml", null, xmlOutputFile, null);
        RelatorioIntegracaoTest.runXslt(new File("output/test/" + xmlOutputFile), new File("../PAD-Modelo/xsl/pad-dc-dvp.xsl"), new File("output/test/dc-dvp-v" + this.versao + "." + idOrgao + ".csv"));
        this.geraPDF("dc-dvp-v" + this.versao + "." + idOrgao + ".pdf", xmlOutputFile, "dc-dvp.xsl");
    }

    static void showMessages(SituacaoVerificacao sitv) {
        if (sitv == null) {
            System.out.println("showMessages: nenhuma mensagem a exibir (null)");
            return;
        }
        for (int i = 0; i < sitv.getMensagens().size(); ++i) {
            MensagemInstancia mi = sitv.getMensagens().get(i);
            System.out.println("[" + i + "] " + mi.getTipo() + ":" + mi.getCodigoMensagem() + " : " + mi);
        }
    }
}

