/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.test.AbstractImportacaoRegras;
import br.gov.rs.tce.pad.modelo.importacao.test.ImportacaoTestUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ImportacaoRegrasCTV
extends AbstractImportacaoRegras {
    public static final String[] codigosAIgnorar = new String[]{"BER_46", "BER_53"};
    @Rule
    public TestName name = new TestName();

    @Override
    @Before
    public void setup() {
        super.setup();
        System.out.println("->> test:: " + this.name.getMethodName());
    }

    @Test
    public void testCTV() {
        this.setupVerificacaoArquivosControle(new String[]{"ORGAO", "UNIORCAM", "RECURSO", "BAL_VER", "BAL_REC", "CTA_DISP"});
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    @Ignore(value="regra obsoleta")
    public void testCTV_31erro() {
        this.setupVerificacaoArquivosControle(new String[]{"ORGAO", "UNIORCAM", "RECURSO", "BAL_VER", "BAL_REC", "CTA_DISP"});
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/ctv_31-erro"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)1L, (long)msgs.size());
        Assert.assertEquals((Object)"CTV_31", (Object)msgs.get(0).getCodigoMensagem());
    }

    @Test
    public void testCTV_31sintetica() {
        this.setupVerificacaoArquivosControle(new String[]{"ORGAO", "UNIORCAM", "RECURSO", "BAL_VER", "BAL_REC", "CTA_DISP"});
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/ctv_31-sintetica"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }
}

