/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.test.AbstractImportacaoRegras;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ImportacaoRegrasBVM
extends AbstractImportacaoRegras {
    String baseDir = "../PAD-Desktop/src_test/2013b6-taquarucu/bvm";
    String[] arqs = new String[]{"ORGAO", "UNIORCAM", "RECURSO", "BAL_VER", "BAL_REC", "CTA_DISP", "BVER_ANT", "BVMOVANT"};
    @Rule
    public TestName name = new TestName();

    @Override
    @Before
    public void setup() {
        super.setup();
        System.out.println("->> test:: " + this.name.getMethodName());
    }

    @Test
    public void testBVM() {
        this.setupVerificacaoArquivosControle(this.arqs);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", this.baseDir));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    public void testBVM_17erro() {
        this.setupVerificacaoArquivosControle(this.arqs);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", this.baseDir + "/bvm_17-erro"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        this.showMessages(msgs);
        Assert.assertEquals((long)1L, (long)this.contaErrosPorCodigo(msgs, "BVM_17"));
        Assert.assertEquals((long)1L, (long)msgs.size());
    }

    @Test
    public void testBVA_28erro() {
        this.setupVerificacaoArquivosControle(this.arqs);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", this.baseDir + "/bva_28-erro"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        this.showMessages(msgs);
        Assert.assertEquals((long)1L, (long)this.contaErrosPorCodigo(msgs, "BVA_28"));
        Assert.assertEquals((long)1L, (long)msgs.size());
    }
}

