/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaExtracao;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.ConsultasQuadrosList;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.test.AbstractImportacaoRegras;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ConsultasTest
extends AbstractImportacaoRegras {
    @Rule
    public TestName name = new TestName();
    static final String DERBY_SUFFIX = "-DERBY";

    @Override
    @Before
    public void setup() {
        super.setup();
        System.out.println("->> test:: " + this.name.getMethodName());
    }

    ConsultasExtracaoList getConsultas(String arquivoConsultasXml) {
        boolean geraXML = true;
        return (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File(arquivoConsultasXml), geraXML);
    }

    ConsultasQuadrosList getConsultasQuadros(String arquivoConsultasXml) {
        return (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros");
    }

    void validaCosultas(ConsultasExtracaoList consultas) throws SQLException {
        Remessa remessa = this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu");
        List<ConsultaExtracao> consl = consultas.getConsultasExtracao();
        for (ConsultaExtracao ce : consl) {
            ConsultaSQL sql = ce.recuperaConsultaSQL(remessa, null, TipoBancoDados.DERBY_DB);
            PreparedStatement ps = this.conexao.prepareStatement(sql.getSql());
            ps.getMetaData();
        }
    }

    void validaCosultasQuadros(ConsultasQuadrosList consultas) throws SQLException {
        Collection<ConsultaSQL> consl = consultas.getConsultasCollection();
        int errors = 0;
        HashSet<String> codigos = new HashSet<String>();
        for (ConsultaSQL sql : consl) {
            codigos.add(sql.getCodigo());
        }
        for (ConsultaSQL sql : consl) {
            String cod = sql.getCodigo();
            if (cod.endsWith(DERBY_SUFFIX) || !codigos.contains(cod + DERBY_SUFFIX)) {
                try {
                    PreparedStatement ps = this.conexao.prepareStatement(sql.getSql());
                    ps.getMetaData();
                }
                catch (SQLException e) {
                    ++errors;
                    System.err.println("ConsultasTest: validaCosultasQuadros: Erro na consulta [" + cod + "]: " + e + "\n" + sql.getSql());
                }
                continue;
            }
            System.out.println("ConsultasTest: validaCosultasQuadros: Ignorando consulta [" + cod + "][consulta c/ sufixo '" + DERBY_SUFFIX + "': " + codigos.contains(cod + DERBY_SUFFIX) + "]");
        }
        if (errors > 0) {
            throw new RuntimeException(errors + " erros na validaCosultasQuadros()");
        }
    }

    @Test
    public void consultasDcBalorc() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-balorc.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasDcBalpat() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-balpat.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasDcDvp() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasExtracao() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasModelo14() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasModelo9() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasRdi() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasRveLeg() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasRveLig() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasRve() throws SQLException {
        String arquivoConsultasXml = "consultas-dc-dvp.xml";
        this.validaCosultas(this.getConsultas(arquivoConsultasXml));
    }

    @Test
    public void consultasQuadros() throws SQLException {
        String arquivoConsultasXml = "consultas-quadros.xml";
        this.validaCosultasQuadros(this.getConsultasQuadros(arquivoConsultasXml));
    }
}

