/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ValidacaoException;
import br.gov.rs.tce.pad.modelo.importacao.ProcessaCarga;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.jbo.ApplicationModule;
import oracle.xml.parser.v2.XMLElement;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ImportaDados {
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_CP1252 = "Cp1252";
    public static final String ENCODING_SYSTEM = "SYSTEM";
    Map _processadores;
    ApplicationModule _app;

    public ImportaDados(ApplicationModule app) {
        this._app = app;
    }

    public void setProcessadores(Map processadores) {
        this._processadores = processadores;
    }

    public void importaArquivoPrefeitura(File arq, Remessa remessa, String encoding) {
        int lastLine = -1;
        int lastColumn = -1;
        boolean reincidencia = false;
        boolean parseDoc = false;
        if (arq == null) {
            throw new IllegalArgumentException("O arquivo de origem n\u00e3o pode ser nulo");
        }
        if (!arq.exists()) {
            throw new IllegalArgumentException("Arquivo n\u00e3o encontrado");
        }
        if (this._processadores == null) {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 processadores registrados para a opera\u00e7\u00e3o");
        }
        while (!parseDoc && !reincidencia) {
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                dbf.setAttribute("oracle.xml.parser.DOMParser.DebugMode", Boolean.TRUE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = null;
                if (encoding.equalsIgnoreCase(ENCODING_SYSTEM)) {
                    encoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
                }
                doc = db.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(arq), encoding)));
                parseDoc = true;
                reincidencia = true;
                Element elem = doc.getDocumentElement();
                NodeList nl = elem.getChildNodes();
                this.importacao(nl, remessa);
            }
            catch (SAXParseException e) {
                StringBuffer sb = new StringBuffer(e.toString());
                sb.append("\n Erro no parse do arquivo XML. (Arquivo com erro de fomata\u00e7\u00e3o ou caracter inv\u00e1lido)");
                sb.append("\n  Line number: " + e.getLineNumber());
                sb.append("\nColumn number: " + e.getColumnNumber());
                sb.append("\n Public ID: " + e.getPublicId());
                sb.append("\n System ID: " + e.getSystemId() + "\n");
                if (lastLine == e.getLineNumber() && lastColumn == e.getColumnNumber()) {
                    reincidencia = true;
                    throw new IllegalArgumentException(sb.toString());
                }
                lastLine = e.getLineNumber();
                lastColumn = e.getColumnNumber();
                this.removeError(arq, lastLine, lastColumn, encoding);
            }
            catch (SAXException e) {
                throw new IllegalArgumentException("Erro no processamento do arquivo XML. (Arquivo com erro de fomata\u00e7\u00e3o ou caracter inv\u00e1lido)");
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void importaArquivoPrefeitura(File arq, Remessa remessa) {
        if (arq == null) {
            throw new IllegalArgumentException("O arquivo de origem n\u00e3o pode ser nulo");
        }
        if (!arq.exists()) {
            throw new IllegalArgumentException("Arquivo n\u00e3o encontrado");
        }
        if (this._processadores == null) {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 processadores registrados para a opera\u00e7\u00e3o");
        }
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(arq), ENCODING_ISO_8859_1)));
            Element elem = doc.getDocumentElement();
            NodeList nl = elem.getChildNodes();
            this.importacao(nl, remessa);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Erro no processamento do arquivo XML. (Arquivo com erro de fomata\u00e7\u00e3o ou caracter inv\u00e1lido)");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importacao(NodeList nl, Remessa remessa) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            String nome = node.getNodeName();
            ProcessaCarga carga = (ProcessaCarga)this._processadores.get(nome);
            if (carga != null && node.getChildNodes().getLength() > 0) {
                carga.processaNodo((Element)((XMLElement)node), remessa);
            }
            if (node.getChildNodes().getLength() <= 0) continue;
            this.importacao(node.getChildNodes(), remessa);
        }
    }

    public void importaArquivo(File arq, Remessa remessa) {
        if (arq == null) {
            throw new IllegalArgumentException("O arquivo de origem n\u00e3o pode ser nulo");
        }
        if (!arq.exists()) {
            throw new IllegalArgumentException("Arquivo n\u00e3o encontrado");
        }
        if (this._processadores == null) {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 processadores registrados para a opera\u00e7\u00e3o");
        }
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            DOMParser parser = new DOMParser();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(arq), ENCODING_ISO_8859_1)));
            Element elem = doc.getDocumentElement();
            NodeList nl = elem.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                String nome = node.getNodeName();
                System.out.println("node.getNodeName: " + nome);
                ProcessaCarga carga = (ProcessaCarga)this._processadores.get(nome);
                if (carga == null) continue;
                carga.processaNodo((Element)node, remessa);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new ValidacaoException("Erro na leitura do XML.", e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new ValidacaoException("Erro na leitura do XML.", e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ValidacaoException("Erro na leitura do XML.", e.getMessage());
        }
    }

    public void removeError(File arq, int linha, int coluna, String encoding) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arq), encoding));
            String line = null;
            StringBuffer xmlFileStringBuffer = new StringBuffer();
            int i = 0;
            while ((line = in.readLine()) != null) {
                line = line.replaceAll("\t", " ");
                line = line.replaceAll("\n", " ");
                line = line.replaceAll("\r", " ");
                line = line.replaceAll("\u0000", " ");
                if (++i == linha && line != null && coluna < line.length()) {
                    line = line.replace(line.charAt(coluna - 1), ' ');
                }
                xmlFileStringBuffer.append(line);
            }
            in.close();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(arq), encoding));
            bw.write(xmlFileStringBuffer.toString());
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

