/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.decisao;

import br.gov.rs.tce.pad.beans.ConfigTelas;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.excecao.DecisaoTelaException;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.excecao.TelaNaoEncontradaException;
import br.gov.rs.tce.pad.modelo.decisao.DecisaoNavegacaoFactory;
import br.gov.rs.tce.pad.modelo.decisao.DecisaoProximaTela;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DecisaoNavegacaoTelas {
    private Map<String, DecisaoProximaTela> _decisaoProximaTela;
    private static Log log = LogFactory.getLog(DecisaoNavegacaoTelas.class);
    private static final String ARQUIVO_PROPERTIES = "conf/pad.properties";
    public static String TELA_APRESENTACAO = "UC035";
    private final String telasAPularStr = DecisaoNavegacaoTelas.getProperty("pad.telasAPular");
    private final String[] telasAPular;
    private final String telaAIniciar = DecisaoNavegacaoTelas.getProperty("pad.telaAIniciar");
    private static DecisaoNavegacaoTelas _instancia;
    private ConfigTelas _config;

    private DecisaoNavegacaoTelas() {
        if (this.telasAPularStr != null) {
            Object[] arr = this.telasAPularStr.split(",");
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = ((String)arr[i]).trim();
            }
            Arrays.sort(arr);
            this.telasAPular = arr;
            log.info((Object)("telasAPular: " + Arrays.asList(this.telasAPular)));
        } else {
            this.telasAPular = new String[0];
        }
        this._decisaoProximaTela = new HashMap<String, DecisaoProximaTela>();
        this._config = DecisaoNavegacaoFactory.getInstancia().getConfigTelas();
    }

    public static DecisaoNavegacaoTelas getInstancia() {
        if (_instancia == null) {
            _instancia = new DecisaoNavegacaoTelas();
        }
        return _instancia;
    }

    public Tela escolheProximaTela(String codigoTelaAtual, BindingContext binding) throws DecisaoTelaException {
        Tela tela = null;
        String codigo = null;
        DecisaoProximaTela dec = this._decisaoProximaTela.get(codigoTelaAtual);
        if (dec != null) {
            codigo = dec.escolheProximaTela(codigoTelaAtual, binding);
            if (codigo == null || codigo.length() < 2) {
                throw new IllegalStateException("A classe de decis\u00e3o " + dec.getClass().getName() + " n\u00e3o retornou nenhum c\u00f3digo de tela, verifique a l\u00f3gica da classe de decis\u00e3o!");
            }
            tela = this._config.getTelaPorCodigo(codigo);
        } else {
            tela = this._config.getTelaPorCodigo(codigoTelaAtual);
            if (tela != null) {
                if (tela.getProximaTela() != null) {
                    tela = this._config.getTelaPorCodigo(tela.getProximaTela());
                } else {
                    if (tela.getDecisaoProxima() == null) {
                        throw new DecisaoTelaException("O arquivo _config-telas deve conter pelo menos um valor para uma das tags \"proxima-tela\" ou \"decisao-proxima\" : " + tela.getCodigo());
                    }
                    dec = this.retornaClasseDecisaoTela(tela.getDecisaoProxima());
                    this._decisaoProximaTela.put(codigoTelaAtual, dec);
                    codigo = dec.escolheProximaTela(codigoTelaAtual, binding);
                    tela = this._config.getTelaPorCodigo(codigo);
                }
            }
        }
        if (tela.isVirtual()) {
            log.info((Object)("DecisaoNavegacaoTelas: escolheProximaTela[virtual]: codigo = " + tela.getCodigo()));
            return this.escolheProximaTela(tela.getCodigo(), binding);
        }
        if (Arrays.binarySearch(this.telasAPular, tela.getCodigo()) >= 0) {
            log.info((Object)("DecisaoNavegacaoTelas: escolheProximaTela[telaAPular]: codigo = " + tela.getCodigo()));
            return this.escolheProximaTela(tela.getCodigo(), binding);
        }
        if (codigoTelaAtual.equals(TELA_APRESENTACAO) && this.telaAIniciar != null) {
            log.info((Object)("DecisaoNavegacaoTelas: codigoTelaAtual==" + TELA_APRESENTACAO + " && telaAIniciar!=null: codigo = " + this.telaAIniciar));
            return this._config.getTelaPorCodigo(this.telaAIniciar);
        }
        return tela;
    }

    private DecisaoProximaTela retornaClasseDecisaoTela(String nome) {
        DecisaoProximaTela tela = null;
        try {
            tela = (DecisaoProximaTela)Class.forName(nome).newInstance();
        }
        catch (Exception e) {
            throw new DecisaoTelaException("Erro ao instanciar classe: " + nome);
        }
        return tela;
    }

    public Tela getTelaPorCodigo(String codigoTela) {
        Tela tela = this._config.getTelaPorCodigo(codigoTela);
        if (tela == null) {
            throw new DecisaoTelaException("Tela n\u00e3o encontrada com c\u00f3digo: '" + codigoTela + "'");
        }
        return tela;
    }

    public ConfigTelas getConfigTelas() {
        return this._config;
    }

    public Tela getTelaInicial() {
        String telaInicial = this._config.getTelaInicial();
        if (telaInicial == null) {
            throw new TelaNaoEncontradaException(new PADRuntimeException("Tela inicial nao definida no ConfigTelas."));
        }
        Tela t = this._config.getTelaPorCodigo(telaInicial);
        return t;
    }

    public Tela getTelaFinal() {
        String tela = this._config.getTelaFinal();
        if (tela == null) {
            throw new TelaNaoEncontradaException(new PADRuntimeException("Tela final nao definida no ConfigTelas."));
        }
        Tela t = this._config.getTelaPorCodigo(tela);
        return t;
    }

    private static String getProperty(String s) {
        String value = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            value = props.getProperty(s);
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

