/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.consolidacao;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.modelo.importacao.ProcessaCarga;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessaCargaRemessaSimples
extends ProcessaCarga {
    public static final String VO_IMPLEMENTATION = "br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasView";

    public ProcessaCargaRemessaSimples(ApplicationModule app) {
        super(app);
    }

    @Override
    public void processaNodo(Element nodo, Remessa remessa) {
        try {
            String codEnt = this.retornaEntidade(nodo, remessa);
            if (!this.verificaeEntidade(codEnt, remessa)) {
                throw new ImportacaoException("Tipo de entidade do backup n\u00e3o corresponde ao tipo de entidade selecionada.", new Object[0]);
            }
            ViewObject vo = this.criaViewObject(nodo, "Remessas", VO_IMPLEMENTATION, 0);
            vo.executeQuery();
        }
        catch (JboException e) {
            e.printStackTrace();
            throw new PADRuntimeException(e);
        }
        finally {
            ViewObject vo = this._app.findViewObject("Remessas");
            if (vo != null) {
                vo.remove();
            }
        }
    }

    private String retornaEntidade(Element nodo, Remessa remessa) {
        NodeList n = nodo.getElementsByTagName("CD_ENTIDADE").item(0).getChildNodes();
        System.out.println("getNodeValue: " + n.item(0).getNodeValue());
        return n.item(0).getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verificaeEntidade(String codEnt, Remessa remessa) {
        boolean retorno = false;
        try {
            ViewObject vo = this._app.createViewObjectFromQueryStmt("ValidaEntidade", "select * from entidades ");
            vo.setWhereClause("cd_entidade = " + Integer.parseInt(codEnt) + "");
            vo.executeQuery();
            Row r = null;
            while (vo.hasNext()) {
                r = vo.next();
                System.out.println("'" + remessa.getTipoSetor() + "' == '" + r.getAttribute("TIPO_SETOR_GOV").toString() + "'");
                if (!remessa.getTipoSetor().trim().equals(r.getAttribute("TIPO_SETOR_GOV").toString().trim())) continue;
                retorno = true;
                break;
            }
        }
        catch (Exception e) {
            retorno = false;
            e.printStackTrace();
        }
        finally {
            if (this._app.findViewObject("ValidaEntidade") != null) {
                this._app.findViewObject("ValidaEntidade").remove();
            }
        }
        return retorno;
    }
}

