/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action.quadros;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloEvent;
import br.gov.rs.tce.pad.modelo.action.ActionModeloListener;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionCarregaDadosQuadro {
    private static Log log = LogFactory.getLog(ActionCarregaDadosQuadro.class);

    public final void carregaDadosQuadro(String codigoTela, Remessa remessa, TipoBancoDados tpBanco, QuadroContas quadro, IdentificadorConta identificadorConta, BindingContext binding, ContasModule contasModule, ActionModeloListener listener) {
        String sqlInsercao = null;
        Integer[] paramsTipoContas = null;
        ConsultaSQL consultaSQL = null;
        try {
            consultaSQL = this.recuperaConsultaSQL(quadro, tpBanco, remessa);
        }
        catch (ConfiguracaoException ce) {
            throw new ConfiguracaoException("Erro ao recuperar consulta do quadro " + quadro.getNome() + " da tela: " + codigoTela, (Exception)((Object)ce));
        }
        if (consultaSQL != null) {
            sqlInsercao = consultaSQL.getSql();
            log.debug((Object)("sqlii: " + sqlInsercao));
            Object[] params = consultaSQL.getValoresParametros();
            if (params.length == 0) {
                params = consultaSQL.getValoresParametros(remessa, tpBanco);
            }
            paramsTipoContas = new Integer[params.length];
            System.arraycopy(params, 0, paramsTipoContas, 0, params.length);
        }
        if (this.verificaNecessidadeCargaDados(contasModule, quadro.getTipoConta())) {
            listener.trataEvento(new ActionModeloEvent(this, 17, "Preparando dados de contas (" + quadro.getTipoConta() + ")..."));
            this.insereDadosTabela(sqlInsercao, paramsTipoContas, remessa, quadro.getTipoConta(), quadro.getCodigoPlanilha(), identificadorConta, contasModule, listener);
        } else {
            listener.trataEvento(new ActionModeloEvent(this, 17, "N\u00e3o h\u00e1 necessidade de inser\u00e7\u00e3o (" + quadro.getTipoConta() + ")."));
        }
    }

    protected ConsultaSQL recuperaConsultaSQL(QuadroContas quadro, TipoBancoDados tpBanco, Remessa remessa) {
        ConsultaSQL consultaSQL = quadro.recuperaSQLInsereContasRemessa(remessa, tpBanco);
        return consultaSQL;
    }

    protected boolean verificaNecessidadeCargaDados(ContasModule contasModule, Integer tipoConta) {
        return !contasModule.verificaTipoContasRemessa(tipoConta);
    }

    protected void insereDadosTabela(String sqlOrigemInsercao, Integer[] paramsTipoContas, Remessa remessa, Integer tipoContaQuadro, Integer cdPlanilha, IdentificadorConta identificadorConta, ContasModule contasModule, ActionModeloListener listener) {
        contasModule.insereContasSelecao(sqlOrigemInsercao, paramsTipoContas, remessa, tipoContaQuadro, cdPlanilha, identificadorConta, listener);
    }
}

