/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.pad.beans.ContasRemessaBean;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.action.PopupSelecaoAction;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import java.awt.event.ActionListener;
import java.util.List;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionTrataPopupSelecao
implements PopupSelecaoAction {
    private static final Log log = LogFactory.getLog(ActionTrataPopupSelecao.class);
    private BindingContext _binding;
    private ActionListener _listenerEventoPopup;
    private IdentificadorConta _identificadorConta;

    public ActionTrataPopupSelecao(ActionListener listenerEventoPopup, IdentificadorConta identificadorConta, BindingContext binding) {
        this._binding = binding;
        this._listenerEventoPopup = listenerEventoPopup;
        this._identificadorConta = identificadorConta;
    }

    @Override
    public void atualizaContas(List<ContasRemessaBean> listaContas) {
        ContasModule contasModule = DatacontrolHelper.getContasModuleAppModule(this._binding);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._binding);
        if (listaContas.size() > 0) {
            log.info((Object)("contas selecionadas: " + listaContas));
            try {
                contasModule.insereContasRemessa(remessa, listaContas, this._identificadorConta);
                contasModule.getTransaction().commit();
            }
            catch (PersistenciaException e) {
                contasModule.getTransaction().rollback();
                throw e;
            }
        } else {
            log.info((Object)"nenhuma conta selecionada");
        }
    }
}

