/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.action.PadAbstractModeloAction;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.modelo.servico.negocio.SubsidioVereadoresImpl;
import java.math.BigDecimal;
import oracle.adf.model.BindingContext;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionModeloUC047
extends PadAbstractModeloAction {
    public static int TP_SUBSUDIO1 = 1;
    public static int TP_SUBSUDIO2 = 2;
    public static int TP_SUBSUDIO3 = 3;
    public static int TP_REPRESENTANTE1 = 1;
    public static int TP_REPRESENTANTE2 = 2;

    @Override
    public void limpaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
        System.out.println("Limpa modelo - UC047");
        Remessa remessa = this.getRemessa(binding);
        ServicoPAD ser = this.getServicoPADAppModule(binding);
        ViewObject voTela = ser.findViewObject("SubsidioVereadoresTodosView");
        ViewObject vo = ser.findViewObject("SubsidioVereadoresTableView");
        voTela.setWhereClause(null);
        voTela.setWhereClauseParams(null);
        voTela.executeQuery();
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.executeQuery();
    }

    @Override
    public void preparaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
        System.out.println("Prepara modelo - UC047  ");
        Remessa remessa = this.getRemessa(binding);
        ServicoPAD ser = this.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("SubsidioVereadoresTableView");
        this.excluiSubsidiosMesesForaRemessa(remessa, vo);
        ser.getTransaction().commit();
        this.verificaPk(remessa, vo);
        ser.getTransaction().commit();
        ViewObject voTela = ser.findViewObject("SubsidioVereadoresTodosView");
        voTela.clearCache();
        voTela.setWhereClause("mes <= " + (remessa.getMesFinalInformacoes() + 1));
        voTela.executeQuery();
        vo.setWhereClause("mes <= " + (remessa.getMesFinalInformacoes() + 1));
        vo.executeQuery();
    }

    private void verificaPk(Remessa remessa, ViewObject vo) {
        for (int i = 1; i <= remessa.getMesFinalInformacoes() + 1; ++i) {
            this.criaPkOuRow(vo, remessa, TP_SUBSUDIO1, TP_REPRESENTANTE1, i);
            this.criaPkOuRow(vo, remessa, TP_SUBSUDIO3, TP_REPRESENTANTE1, i);
            this.criaPkOuRow(vo, remessa, TP_SUBSUDIO2, TP_REPRESENTANTE1, i);
            this.criaPkOuRow(vo, remessa, TP_SUBSUDIO1, TP_REPRESENTANTE2, i);
            this.criaPkOuRow(vo, remessa, TP_SUBSUDIO3, TP_REPRESENTANTE2, i);
        }
    }

    private void criaPkOuRow(ViewObject vo, Remessa remessa, int tpSubsidio, int tpRepresentante, int mes) {
        Row rowf = this.criaPk(vo, remessa, tpSubsidio, tpRepresentante, mes);
        if (rowf == null) {
            this.criaRow(vo, mes, remessa, tpSubsidio, tpRepresentante);
        }
    }

    private Row criaPk(ViewObject vo, Remessa remessa, int tpSubsidio, int tpRepresentante, int mes) {
        Key k = SubsidioVereadoresImpl.createPrimaryKey(new BigDecimal(remessa.getCdRemessa().toString()), new BigDecimal(remessa.getCdEntidade().toString()), String.valueOf(tpSubsidio), String.valueOf(tpRepresentante), new BigDecimal(mes));
        return vo.getRow(k);
    }

    private void criaRow(ViewObject vo, int meses, Remessa remessa, int tpSubsidio, int tpRepresentante) {
        Row row = vo.createRow();
        row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
        row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
        row.setAttribute("TpSubsidio", (Object)tpSubsidio);
        row.setAttribute("TpRepresentante", (Object)tpRepresentante);
        row.setAttribute("Mes", (Object)meses);
        vo.insertRow(row);
    }

    private void excluiSubsidiosMesesForaRemessa(Remessa remessa, ViewObject vo) {
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.setWhereClause("Mes > " + (remessa.getMesFinalInformacoes() + 1));
        vo.executeQuery();
        vo.first();
        while (vo.hasNext()) {
            vo.first();
            Row r = vo.getCurrentRow();
            if (r == null) continue;
            r.remove();
        }
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.executeQuery();
    }
}

