/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaConsorcios;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaJustificativas;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaPrestadoraServico;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaPublicacoes;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRemessaCamara;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRemessaSimples;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaResponsaveis;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRespostasRemessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaSubsidioVereadores;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaSubstituicoes;
import br.gov.rs.tce.pad.modelo.importacao.ImportaDados;
import br.gov.rs.tce.pad.modelo.importacao.ProcessaCarga;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;

public class RecuperaArquivoBackup {
    ApplicationModule _app;
    Map<String, ProcessaCarga> _processadores;
    public static final int COMMIT_AFTER = 0;
    public static final int UNCOMMIT_AFTER = 1;
    public static final String VO_REMESSAS = "Remessas";
    public static final String VO_REMESSA_CAMARA = "RemessaCamara";
    public static final String VO_JUSTIFICATIVAS = "Justificativas";
    public static final String VO_CONSORCIOS = "Consorcios";
    public static final String VO_RESPONSAVEIS = "ResponsaveisRemessa";
    public static final String VO_PRESTADORA_SERVICO = "PrestadoraServico";
    public static final String VO_SUBSTITUICOES = "Substituicoes";
    public static final String VO_RESPOSTAS_EMPRESA = "RespostasDaRemessa";
    public static final String VO_SUBSIDIO_VEREADORES = "SubsidioVereadores";
    public static final String VO_PUBLICACOES = "Publicacoes";

    public RecuperaArquivoBackup(ApplicationModule app) {
        this._app = app;
        this._processadores = new TreeMap<String, ProcessaCarga>();
        this._processadores.put(VO_REMESSAS, new ProcessaCargaRemessaSimples(app));
        this._processadores.put(VO_JUSTIFICATIVAS, new ProcessaCargaJustificativas(app));
    }

    public void recuperaArquivoPrefeitura(File arquivo, Remessa remessa, int commitType) {
        this._processadores.put(VO_PRESTADORA_SERVICO, new ProcessaCargaPrestadoraServico(this._app));
        this._processadores.put(VO_RESPONSAVEIS, new ProcessaCargaResponsaveis(this._app));
        this._processadores.put(VO_SUBSTITUICOES, new ProcessaCargaSubstituicoes(this._app));
        this._processadores.put(VO_RESPOSTAS_EMPRESA, new ProcessaCargaRespostasRemessa(this._app));
        this._processadores.put(VO_REMESSA_CAMARA, new ProcessaCargaRemessaCamara(this._app));
        this._processadores.put(VO_PUBLICACOES, new ProcessaCargaPublicacoes(this._app));
        this._processadores.put(VO_SUBSIDIO_VEREADORES, new ProcessaCargaSubsidioVereadores(this._app));
        this._processadores.put(VO_CONSORCIOS, new ProcessaCargaConsorcios(this._app));
        ImportaDados imp = new ImportaDados(this._app);
        imp.setProcessadores(this._processadores);
        this.limpaFiltrosVO();
        imp.importaArquivoPrefeitura(arquivo, remessa);
        if (commitType != 1) {
            this._app.getTransaction().commit();
        }
    }

    public void recuperaBackup(File arquivo, Remessa remessa, int commitType) {
        ImportaDados imp = new ImportaDados(this._app);
        imp.setProcessadores(this._processadores);
        imp.importaArquivo(arquivo, remessa);
        this.limpaFiltrosVO();
        if (commitType != 1) {
            this._app.getTransaction().commit();
        }
    }

    private void limpaFiltrosVO() {
        ViewObject vo = this._app.findViewObject("RemessasDaEntidade");
        System.out.println(vo.getWhereClause());
        System.out.println(vo.getWhereClauseParams());
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.executeQuery();
        while (vo.hasNext()) {
            vo.first().remove();
        }
    }
}

