/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class TipoEntidadesList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LEI_6404_76 = "6404/76";
    public static final String LEI_4320_64 = "4320/64";
    public static final String GENERICA = "GENERICA";
    public static final String INDIFERENTE = "INDIFERENTE";
    public static final String TELA_UC048 = "UC048";
    public static final String PREFEITURA_ABRV_TYPE = "P";
    public static final TipoEntidadesList PREFEITURA = new TipoEntidadesList("Prefeitura Municipal", "P", "4320/64");
    public static final String CAMARA_ABRV_TYPE = "C";
    public static final TipoEntidadesList CAMARA = new TipoEntidadesList("C\u00e2mara Municipal", "C", "4320/64");
    public static final String AUTARQUIA_ABRV_TYPE = "A";
    public static final TipoEntidadesList AUTARQUIA = new TipoEntidadesList("Autarquia", "A", "4320/64");
    public static final String FUNDACAO_ABRV_TYPE = "F";
    public static final TipoEntidadesList FUNDACAO = new TipoEntidadesList("Funda\u00e7\u00e3o - Regida pela Lei 4.320/64", "F", "4320/64");
    public static final String EMPRESA_ABRV_TYPE = "E";
    public static final TipoEntidadesList EMPRESA = new TipoEntidadesList("Empresa P\u00fablica ou Sociedade de Economia Mista", "E", "6404/76");
    public static final TipoEntidadesList EMPRESA_DA_ENTIDADE_INDIRETA = new TipoEntidadesList("Empresa P\u00fablica", "E", "6404/76");
    public static final String CONSORCIO_ABRV_TYPE = "O";
    public static final TipoEntidadesList CONSORCIO = new TipoEntidadesList("Cons\u00f3rcio - Regido pela Lei 6.404/76", "O", "6404/76");
    public static final String FUNDACAO_64_ABRV_TYPE = "T";
    public static final TipoEntidadesList FUNDACAO_64 = new TipoEntidadesList("Funda\u00e7\u00e3o - Regida pela Lei 6.404/76", "T", "6404/76");
    public static final String CONSORCIO_43_ABRV_TYPE = "S";
    public static final TipoEntidadesList CONSORCIO_43 = new TipoEntidadesList("Cons\u00f3rcios - Regido pela Lei 4.320/64", "S", "4320/64");
    public static final String EMPRESA_43_ABRV_TYPE = "M";
    public static final TipoEntidadesList EMPRESA_43 = new TipoEntidadesList("Empresa P\u00fablica - Regida pela Lei 4.320/64", "M", "4320/64");
    public static final String OUTROS_ABRV_TYPE = "X";
    public static final TipoEntidadesList OUTROS = new TipoEntidadesList("Outros", "X", "");
    public static final String SOCIEDADE_ANONIMA_ABRV_TYPE = "SA";
    public static final TipoEntidadesList SOCIEDADE_ANONIMA = new TipoEntidadesList("Sociedade An\u00f4nima", "SA", "");
    public static final String SOCIEDADE_LIMITADA_ABRV_TYPE = "SL";
    public static final TipoEntidadesList SOCIEDADE_LIMITADA = new TipoEntidadesList("Sociedade Limitada", "SL", "");
    public static final String CONSORCIO_ADMINISTRATIVO_ABRV_TYPE = "CA";
    public static final TipoEntidadesList CONSORCIO_ADMISTRATIVO = new TipoEntidadesList("Cons\u00f3rcio Administrativo", "CA", "");
    public static final String SERVICO_SOCIAL_AUTONOMO_ABRV_TYPE = "AS";
    public static final TipoEntidadesList SERVICO_SOCIAL_AUTONOMO = new TipoEntidadesList("Associa\u00e7\u00e3o", "AS", "");
    public static final String SOCIEDADE_ECONOMIA_MISTA_ABRV_TYPE = "SE";
    public static final TipoEntidadesList SOCIEDADE_ECONOMIA_MISTA = new TipoEntidadesList("Sociedade de Economia Mista", "SE", "");
    public static final String ASSOCIACAO_ABRV_TYPE = "SS";
    public static final TipoEntidadesList ASSOCIACAO = new TipoEntidadesList("Servico Social Aut\u00f4nomo", "SS", "");
    private static HashMap<String, TipoEntidadesList> _abrvMemberTable = TipoEntidadesList.initAbreviaturas();
    private static HashMap<String, TipoEntidadesList> _abrvOutrosMemberTable = TipoEntidadesList.initAbreviaturasOutros();
    private static HashMap<String, TipoEntidadesList> _abrvEntIndiretasMemberTable = TipoEntidadesList.initAbreviaturasEntIndiretas();
    private String _name = null;
    private String _abreviatura = null;
    private String _lei = null;

    private TipoEntidadesList(String value, String abreviatura, String lei) {
        this._abreviatura = abreviatura;
        this._name = value;
        this._lei = lei;
    }

    public static Iterator<TipoEntidadesList> enumerate() {
        return _abrvMemberTable.values().iterator();
    }

    public static Collection<TipoEntidadesList> listaEntidades() {
        return Collections.unmodifiableCollection(_abrvMemberTable.values());
    }

    public static Collection<TipoEntidadesList> listaEntidadesOutros() {
        return Collections.unmodifiableCollection(_abrvOutrosMemberTable.values());
    }

    public static Collection<TipoEntidadesList> listaEntidadesIndiretas() {
        return Collections.unmodifiableCollection(_abrvEntIndiretasMemberTable.values());
    }

    private static HashMap<String, TipoEntidadesList> initAbreviaturasEntIndiretas() {
        LinkedHashMap<String, TipoEntidadesList> members = new LinkedHashMap<String, TipoEntidadesList>();
        members.put(AUTARQUIA_ABRV_TYPE, AUTARQUIA);
        members.put(FUNDACAO_ABRV_TYPE, FUNDACAO);
        members.put(EMPRESA_ABRV_TYPE, EMPRESA_DA_ENTIDADE_INDIRETA);
        members.put(EMPRESA_43_ABRV_TYPE, EMPRESA_43);
        members.put(SOCIEDADE_ANONIMA_ABRV_TYPE, SOCIEDADE_ANONIMA);
        members.put(SOCIEDADE_LIMITADA_ABRV_TYPE, SOCIEDADE_LIMITADA);
        members.put(CONSORCIO_ADMINISTRATIVO_ABRV_TYPE, CONSORCIO_ADMISTRATIVO);
        members.put(SERVICO_SOCIAL_AUTONOMO_ABRV_TYPE, SERVICO_SOCIAL_AUTONOMO);
        members.put(ASSOCIACAO_ABRV_TYPE, ASSOCIACAO);
        members.put(SOCIEDADE_ECONOMIA_MISTA_ABRV_TYPE, SOCIEDADE_ECONOMIA_MISTA);
        return members;
    }

    private static HashMap<String, TipoEntidadesList> initAbreviaturasOutros() {
        LinkedHashMap<String, TipoEntidadesList> members = new LinkedHashMap<String, TipoEntidadesList>();
        members.put(FUNDACAO_64_ABRV_TYPE, FUNDACAO_64);
        members.put(CONSORCIO_ABRV_TYPE, CONSORCIO);
        return members;
    }

    private static HashMap<String, TipoEntidadesList> initAbreviaturas() {
        LinkedHashMap<String, TipoEntidadesList> members = new LinkedHashMap<String, TipoEntidadesList>();
        members.put(PREFEITURA_ABRV_TYPE, PREFEITURA);
        members.put(CAMARA_ABRV_TYPE, CAMARA);
        members.put(AUTARQUIA_ABRV_TYPE, AUTARQUIA);
        members.put(FUNDACAO_ABRV_TYPE, FUNDACAO);
        members.put(CONSORCIO_43_ABRV_TYPE, CONSORCIO_43);
        members.put(EMPRESA_ABRV_TYPE, EMPRESA);
        members.put(EMPRESA_43_ABRV_TYPE, EMPRESA_43);
        members.put(OUTROS_ABRV_TYPE, OUTROS);
        return members;
    }

    private Object readResolve() {
        return TipoEntidadesList.valueOf(this._name);
    }

    public String toString() {
        return this._name;
    }

    public static TipoEntidadesList valueOf(String string) {
        TipoEntidadesList obj = null;
        if (string != null) {
            obj = _abrvMemberTable.get(string);
        }
        if (obj == null && string != null) {
            obj = _abrvOutrosMemberTable.get(string);
        }
        if (obj == null && string != null) {
            obj = _abrvEntIndiretasMemberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid TipoEntidadesList";
            System.err.println("TipoEntidadesList: valueOf: " + err);
            return null;
        }
        return obj;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setAbreviatura(String _abreviatura) {
        this._abreviatura = _abreviatura;
    }

    public String getAbreviatura() {
        return this._abreviatura;
    }

    public String getLei() {
        return this._lei;
    }

    public static String getLeiPorTipoSetor(String tipoSetor) {
        TipoEntidadesList tipo = _abrvMemberTable.get(tipoSetor);
        if (tipo == null && (tipo = _abrvOutrosMemberTable.get(tipoSetor)) == null) {
            throw new IllegalArgumentException("Tipo de setor inv\u00e1lido: " + tipoSetor);
        }
        return tipo.getLei();
    }
}

