/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import java.util.List;
import junit.framework.TestCase;

public class SituacaoVerificacaoTest
extends TestCase {
    SituacaoVerificacao situacao;

    public SituacaoVerificacaoTest(String sTestName) {
        super(sTestName);
    }

    public void testinicializaMetadadosArquivos() {
        MetadadosArquivoContabil meta = this.situacao.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo("ORGAO"));
        SituacaoVerificacaoTest.assertNotNull((String)"SituacaoVerificacao - arquivo ORGAO n\u00e3o encontrado", (Object)meta);
    }

    public void testadicionaMensagem() {
        MensagemInstancia msg = new MensagemInstancia();
        MetadadosArquivoContabil meta = this.situacao.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo("ORGAO"));
        SituacaoVerificacaoTest.assertNotNull((String)"SituacaoVerificacao - arquivo ORGAO n\u00e3o encontrado", (Object)meta);
        msg.setIdArquivo(meta.getArquivo().getIdentificador());
        msg.setCodigoMensagem("MSG_01");
        msg.setTexto("TESTE");
        msg.setTipo("W");
        this.situacao.adicionaMensagem(msg);
    }

    public void testzeraSituacaoVerificao() {
    }

    public void setUp() throws Exception {
        this.situacao = new SituacaoVerificacao();
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal");
        List<Arquivo> listArquivos = arquivos.getArquivosPorLeiEntidade("4320/64", "P", 1, 6, 12);
        SituacaoVerificacaoTest.assertTrue((String)"Lista de arquivo da lei 4320/64 \u00e9 vazia", (listArquivos.size() > 0 ? 1 : 0) != 0);
        this.situacao.inicializaMetadadosArquivos(listArquivos, "./test/arquivos");
        listArquivos = arquivos.getArquivosPorLeiEntidade("6404/76", "E", 1, 1, 2);
        SituacaoVerificacaoTest.assertTrue((String)"Lista de arquivo da lei 6404/76 \u00e9 vazia", (listArquivos.size() > 0 ? 1 : 0) != 0);
    }

    public void tearDown() throws Exception {
    }
}

