/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans.remessa;

import br.gov.rs.tce.assdigital.excecao.AssinaturaDigitalException;
import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.util.Base64Utils;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="remessa-info")
public class RemessaInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer _codigoRemessa;
    private Integer _codigoEntidade;
    private String _codBarrasRve;
    private String _codBarrasRveLeg;
    private String _codBarrasModelo9;
    private String _codBarrasModelo14;
    private String _codBarrasRdi;
    private String _codBarrasDcBP;
    private String _codBarrasDcBO;
    private String _codBarrasDcDVP;
    private String _assinaturaXml;
    private String _assinaturaTxt;
    private String _cadeiaCertificado;
    byte[] _digestRemessa;
    private Integer _periodoInformacoes;
    private Integer _anoExercicio;
    private Integer _grupoEntrega;
    private String _cnpjEntidade;
    private String _tipoOrgao;
    private Date _dataGeracao;
    private String _tipoEntrega;
    String _versao;
    String _codBarrasRveOriginal;
    private String _tipoCertificado;
    private Date _dataFinalRemessa;
    private String _codigoArquivosComplementares;
    private String _tipoResponsaveis;
    private Integer _mesInformacoes;

    @XmlElement(name="cod-barras-rve")
    public String getCodBarrasRve() {
        return this._codBarrasRve;
    }

    public void setCodBarrasRve(String codBarrasRve) {
        this._codBarrasRve = codBarrasRve;
    }

    public String getCodBarrasRveLeg() {
        return this._codBarrasRveLeg;
    }

    public void setCodBarrasRveLeg(String codBarrasRveLeg) {
        this._codBarrasRveLeg = codBarrasRveLeg;
    }

    @XmlElement(name="cod-barras-modelo9")
    public String getCodBarrasModelo9() {
        return this._codBarrasModelo9;
    }

    public void setCodBarrasModelo9(String codBarrasModelo9) {
        this._codBarrasModelo9 = codBarrasModelo9;
    }

    @XmlElement(name="cod-barras-modelo14")
    public String getCodBarrasModelo14() {
        return this._codBarrasModelo14;
    }

    public void setCodBarrasModelo14(String codBarrasModelo14) {
        this._codBarrasModelo14 = codBarrasModelo14;
    }

    @XmlElement(name="assinatura-xml")
    public String getAssinaturaXml() {
        return this._assinaturaXml;
    }

    public void setAssinaturaXml(String assinaturaXml) {
        this._assinaturaXml = assinaturaXml;
    }

    @XmlElement(name="assinatura-txt")
    public String getAssinaturaTxt() {
        return this._assinaturaTxt;
    }

    public void setAssinaturaTxt(String assinaturaTxt) {
        this._assinaturaTxt = assinaturaTxt;
    }

    public String getCadeiaCertificado() {
        return this._cadeiaCertificado;
    }

    public void setCadeiaCertificado(String cadeiaCertificado) {
        this._cadeiaCertificado = cadeiaCertificado;
    }

    public byte[] getDigestRemessaArray() {
        return this._digestRemessa;
    }

    public void calculaDigestRemessa() {
        this.validaAtributoDigest(this._codigoRemessa, "_codigoRemessa");
        this.validaAtributoDigest(this._codigoEntidade, "_codigoEntidade");
        this.validaAtributoDigest(this._assinaturaXml, "_assinaturaXml");
        this.validaAtributoDigest(this._assinaturaTxt, "_assinaturaTxt");
        this.validaAtributoDigest(this._cadeiaCertificado, "_cadeiaCertificado");
        this.validaAtributoDigest(this._periodoInformacoes, "_periodoInformacoes");
        this.validaAtributoDigest(this._anoExercicio, "_anoExercicio");
        this.validaAtributoDigest(this._grupoEntrega, "_grupoEntrega");
        this._digestRemessa = this.geraDigestRemessa();
    }

    private void validaAtributoDigest(Object valor, String nomeAtributo) {
        if (valor == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 possivel calcular o Digest da remessa, o atributo: " + nomeAtributo + " deve ser diferente de null.");
        }
    }

    private byte[] geraDigestRemessa() {
        StringBuffer buf = new StringBuffer(2048);
        buf.append(this.getAnoExercicio());
        buf.append(this.getPeriodoInformacoes());
        buf.append(this.getGrupoEntrega());
        buf.append(this.getCodigoEntidade());
        buf.append(this.getCodigoRemessa());
        buf.append(this.getAssinaturaTxt());
        buf.append(this.getAssinaturaXml());
        buf.append(this.getCadeiaCertificado());
        try {
            return AssinaturaDigitalControle.calculaDigest(buf.toString().getBytes());
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
    }

    public boolean digestRemessaValido() {
        boolean ok = true;
        byte[] calculado = this.geraDigestRemessa();
        boolean bl = ok = calculado != null && this._digestRemessa != null && calculado.length == this._digestRemessa.length;
        if (ok) {
            for (int i = 0; i < calculado.length; ++i) {
                boolean bl2 = ok = calculado[i] == this._digestRemessa[i];
                if (!ok) break;
            }
        }
        return ok;
    }

    public void setDigestRemessa(String digestRemessa) {
        this._digestRemessa = Base64Utils.base64Decode(digestRemessa);
    }

    public String getDigestRemessa() {
        return Base64Utils.base64Encode(this._digestRemessa);
    }

    public void setCodigoRemessa(Integer codigoRemessa) {
        this._codigoRemessa = codigoRemessa;
    }

    @XmlElement(name="codigo-remessa")
    public Integer getCodigoRemessa() {
        return this._codigoRemessa;
    }

    public void setCodigoEntidade(Integer codigoEntidade) {
        this._codigoEntidade = codigoEntidade;
    }

    @XmlElement(name="codigo-entidade")
    public Integer getCodigoEntidade() {
        return this._codigoEntidade;
    }

    public void setPeriodoInformacoes(int periodoInformacoes) {
        this._periodoInformacoes = periodoInformacoes;
    }

    @XmlElement(name="periodo-informacoes")
    public Integer getPeriodoInformacoes() {
        return this._periodoInformacoes;
    }

    public void setAnoExercicio(int anoExercicio) {
        this._anoExercicio = anoExercicio;
    }

    @XmlElement(name="ano-exercicio")
    public Integer getAnoExercicio() {
        return this._anoExercicio;
    }

    public void setGrupoEntrega(int grupoEntrega) {
        this._grupoEntrega = grupoEntrega;
    }

    @XmlElement(name="grupo-entrega")
    public Integer getGrupoEntrega() {
        return this._grupoEntrega;
    }

    @XmlElement(name="cnpj-entidade")
    public String getCnpjEntidade() {
        return this._cnpjEntidade;
    }

    public void setCnpjEntidade(String _cnpjEntidade) {
        this._cnpjEntidade = _cnpjEntidade;
    }

    @XmlElement(name="tipo-orgao")
    public String getTipoOrgao() {
        return this._tipoOrgao;
    }

    public void setTipoOrgao(String _tipoEntidade) {
        this._tipoOrgao = _tipoEntidade;
    }

    @XmlElement(name="data-geracao")
    public Date getDataGeracao() {
        return this._dataGeracao;
    }

    public void setDataGeracao(Date dataGeracao) {
        this._dataGeracao = dataGeracao;
    }

    @XmlElement(name="tipo-entrega")
    public String getTipoEntrega() {
        return this._tipoEntrega;
    }

    public void setTipoEntrega(String _tipoEntrega) {
        this._tipoEntrega = _tipoEntrega;
    }

    public String getVersao() {
        return this._versao;
    }

    public void setVersao(String _versao) {
        this._versao = _versao;
    }

    public String getCodBarrasRveOriginal() {
        return this._codBarrasRveOriginal;
    }

    public void setCodBarrasRveOriginal(String _codBarrasRveOriginal) {
        this._codBarrasRveOriginal = _codBarrasRveOriginal;
    }

    public String getTipoCertificado() {
        return this._tipoCertificado;
    }

    public void setTipoCertificado(String _tipo) {
        this._tipoCertificado = _tipo;
    }

    public void setDataFinalRemessa(Date dataFinalRemessa) {
        this._dataFinalRemessa = dataFinalRemessa;
    }

    public Date getDataFinalRemessa() {
        return this._dataFinalRemessa;
    }

    public void setCodBarrasRdi(String codBarrasRdi) {
        this._codBarrasRdi = codBarrasRdi;
    }

    public String getCodBarrasRdi() {
        return this._codBarrasRdi;
    }

    public void setCodigoArquivosComplementares(String codigoArquivosComplementares) {
        this._codigoArquivosComplementares = codigoArquivosComplementares;
    }

    public String getCodigoArquivosComplementares() {
        return this._codigoArquivosComplementares;
    }

    public void setTipoResponsaveis(String tipoResponsaveis) {
        this._tipoResponsaveis = tipoResponsaveis;
    }

    public String getTipoResponsaveis() {
        return this._tipoResponsaveis;
    }

    public void setCodBarrasDcBp(String codBarrasDcBP) {
        this._codBarrasDcBP = codBarrasDcBP;
    }

    @XmlElement(name="cod-barras-dc-bp")
    public String getCodBarrasDcBp() {
        return this._codBarrasDcBP;
    }

    public void setCodBarrasDcBo(String codBarrasDcBO) {
        this._codBarrasDcBO = codBarrasDcBO;
    }

    @XmlElement(name="cod-barras-dc-bo")
    public String getCodBarrasDcBo() {
        return this._codBarrasDcBO;
    }

    public void setCodBarrasDcDvp(String codBarras) {
        this._codBarrasDcDVP = codBarras;
    }

    @XmlElement(name="cod-barras-dc-dvp")
    public String getCodBarrasDcDvp() {
        return this._codBarrasDcDVP;
    }

    @XmlElement(name="mes-informacoes")
    public Integer getMesInformacoes() {
        return this._mesInformacoes;
    }

    public void setMesInformacoes(Integer _mes) {
        this._mesInformacoes = _mes;
    }
}

