/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.RegraConfig;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exolab.castor.util.IteratorEnumeration;

public final class Regras
implements Serializable {
    private String _versaoRegras;
    private ArrayList _regraList = new ArrayList();
    private Map _regraMap = new HashMap();

    public void addRegra(RegraConfig vRegra) throws IndexOutOfBoundsException {
        if (vRegra.getExtende() != null) {
            this.trataExtensao(vRegra);
        }
        this._regraList.add(vRegra);
        this._regraMap.put(vRegra.getNome(), vRegra);
    }

    public void addRegra(int index, RegraConfig vRegra) throws IndexOutOfBoundsException {
        if (vRegra.getExtende() != null) {
            this.trataExtensao(vRegra);
        }
        this._regraList.add(index, vRegra);
        this._regraMap.put(vRegra.getNome(), vRegra);
    }

    public void clearRegra() {
        this._regraList.clear();
        this._regraMap.clear();
    }

    public Enumeration enumerateRegra() {
        return new IteratorEnumeration(this._regraList.iterator());
    }

    public RegraConfig getRegra(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._regraList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (RegraConfig)this._regraList.get(index);
    }

    public RegraConfig[] getRegra() {
        int size = this._regraList.size();
        RegraConfig[] mArray = new RegraConfig[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (RegraConfig)this._regraList.get(index);
        }
        return mArray;
    }

    public int getRegraCount() {
        return this._regraList.size();
    }

    public String getVersaoRegras() {
        return this._versaoRegras;
    }

    public boolean removeRegra(RegraConfig vRegra) {
        boolean removed = this._regraList.remove(vRegra);
        Object removedMap = this._regraMap.remove(vRegra.getNome());
        return removed;
    }

    public void setRegra(int index, RegraConfig vRegra) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._regraList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (vRegra.getExtende() != null) {
            this.trataExtensao(vRegra);
        }
        this._regraList.set(index, vRegra);
        this._regraMap.put(vRegra.getNome(), vRegra);
    }

    public void setRegra(RegraConfig[] regraArray) {
        this._regraList.clear();
        for (int i = 0; i < regraArray.length; ++i) {
            if (regraArray[i].getExtende() != null) {
                this.trataExtensao(regraArray[i]);
            }
            this._regraList.add(regraArray[i]);
            this._regraMap.put(regraArray[i].getNome(), regraArray[i]);
        }
    }

    public void setVersaoRegras(String versaoRegras) {
        this._versaoRegras = versaoRegras;
    }

    public RegraConfig getRegraPorNome(String nomeRegra) throws VerificacaoException {
        RegraConfig regraConfig = null;
        if (!this._regraMap.containsKey(nomeRegra)) {
            Set regras = this._regraMap.keySet();
            for (String nome : regras) {
                if (nomeRegra.length() > nome.length() || !nomeRegra.equals(nome.substring(0, nomeRegra.length()))) continue;
                return (RegraConfig)this._regraMap.get(nome.substring(0, nomeRegra.length()));
            }
            throw new VerificacaoException("10020", new Object[]{nomeRegra});
        }
        regraConfig = (RegraConfig)this._regraMap.get(nomeRegra);
        return regraConfig;
    }

    private void trataExtensao(RegraConfig regra) {
        String extensao = regra.getExtende();
        RegraConfig regraExtensao = (RegraConfig)this._regraMap.get(extensao);
        if (regraExtensao == null) {
            throw new IllegalArgumentException("Regra " + extensao + " n\u00e3o localiza para extender " + regra.getNome());
        }
        regra.setCodigoMensagem(regra.getCodigoMensagem() == null ? regraExtensao.getCodigoMensagem() : regra.getCodigoMensagem());
        regra.setDepende(regra.getDepende() == null ? regraExtensao.getDepende() : regra.getDepende());
        regra.setEntidades(regra.getEntidades() == null ? regraExtensao.getEntidades() : regra.getEntidades());
        regra.setJavaClass(regra.getJavaClass() == null ? regraExtensao.getJavaClass() : regra.getJavaClass());
        regra.setNome(regra.getNome() == null ? regraExtensao.getNome() : regra.getNome());
        regra.setPeriodos(regra.getPeriodos() == null ? regraExtensao.getPeriodos() : regra.getPeriodos());
        regra.setParametros(regra.getParametros().isEmpty() ? regraExtensao.getParametros() : regra.getParametros());
    }
}

