/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.ParametrosList;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.QuadroTotal;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.util.ResolveStringConstantes;
import java.util.Map;

public class QuadroAbstrato {
    public static final int TAMANHO_ARRAY_NULO = -1;
    public static final int TAMANHO_PADRAO_COLUNA_VALORES = 94;
    public static final int TAMANHO_PADRAO_COLUNA_CODIGO_CONTA = 125;
    public static final int TAMANHO_PADRAO_COLUNA_CODIGO_UNIDADE = 53;
    public static final int TAMANHO_PADRAO_COLUNA_DESCRICAO = 194;
    private String _nome;
    private String _tituloWeb;
    private String _tituloColunas;
    protected ParametrosList _parametrosList;
    private String nomeViewObject;
    private String controlBindingName;
    private String _titulo;
    private boolean _hasTituloColunas;
    protected String tipoCamposWeb;
    private String[] _colunasQuadro = new String[0];
    private String _tamanhoColunas;
    private String _alinhamentoColunas;
    private boolean _hasTamanhoColunas;
    private boolean _hasAlinhamentoColunas;

    public QuadroAbstrato() {
        this._parametrosList = new ParametrosList();
    }

    public void addParametro(Parametro vParametro) {
        this._parametrosList.adicionaParametro(vParametro);
    }

    public Parametro getParametroPorNome(String nome) {
        return this._parametrosList.getParametroPorNome(nome);
    }

    public Map getParametroMap() {
        return this._parametrosList.getParametroMap();
    }

    public String getNome() {
        return this._nome;
    }

    public String getTitulo() {
        return this._titulo;
    }

    public String getTituloWeb() {
        return this._tituloWeb;
    }

    public String getTituloFormatado(Remessa remessa) {
        return ResolveStringConstantes.formataStringComConstantes(this._titulo, remessa, null);
    }

    public void setNome(String nome) {
        this._nome = nome;
    }

    public void setTitulo(String titulo) {
        this._titulo = titulo;
    }

    public void setTituloWeb(String titulo) {
        this._tituloWeb = titulo;
    }

    public void setTituloColunas(String tituloColunas) {
        this._tituloColunas = tituloColunas;
        this._hasTituloColunas = true;
    }

    public String getTituloColunas() {
        return this._tituloColunas;
    }

    public String[] getTituloColunasArray() {
        String[] titulos = this._tituloColunas.split(",");
        for (int i = 0; i < titulos.length; ++i) {
            titulos[i] = titulos[i].trim();
        }
        return titulos;
    }

    public int getColunasArrayLength() {
        String[] colunas = this.getColunasArray();
        if (colunas != null) {
            return colunas.length;
        }
        return -1;
    }

    public String[] getColunasArray() {
        return this.getColunasQuadroArray();
    }

    public void setNomeViewObject(String nomeViewObject) {
        this.nomeViewObject = nomeViewObject;
    }

    public String getNomeViewObject() {
        return this.nomeViewObject;
    }

    public boolean hasTituloColunas() {
        return this._hasTituloColunas;
    }

    public void setControlBindingName(String controlBindingName) {
        this.controlBindingName = controlBindingName;
    }

    public String getControlBindingName() {
        return this.controlBindingName;
    }

    public String getTipoCamposWeb() {
        return this.tipoCamposWeb;
    }

    public void setTipoCamposWeb(String tipoCamposWeb) {
        this.tipoCamposWeb = tipoCamposWeb;
    }

    public String[] getTipoCamposWebArray() {
        String[] tipoCampos = this.tipoCamposWeb.split(",");
        for (int i = 0; i < tipoCampos.length; ++i) {
            tipoCampos[i] = tipoCampos[i].trim();
        }
        return tipoCampos;
    }

    public void setColunasQuadro(String colunasQuadro) {
        this._colunasQuadro = colunasQuadro.split(",");
        for (int i = 0; i < this._colunasQuadro.length; ++i) {
            this._colunasQuadro[i] = this._colunasQuadro[i].trim();
        }
    }

    public String getColunasQuadro(int index) {
        return this._colunasQuadro[index];
    }

    public String[] getColunasQuadroArray() {
        return this._colunasQuadro;
    }

    public void setColunasQuadroArray(String[] colunasQuadro) {
        this._colunasQuadro = colunasQuadro;
    }

    public String getColunasQuadro() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._colunasQuadro.length; ++i) {
            buf.append(this._colunasQuadro[i]);
            if (i + 1 >= this._colunasQuadro.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void setTamanhoColunas(String tamanhoColunas) {
        this._tamanhoColunas = tamanhoColunas;
        this._hasTamanhoColunas = true;
    }

    public String getTamanhoColunas() {
        return this._tamanhoColunas;
    }

    public int[] getTamanhoColunasArray() {
        int[] tamanhos = new int[]{};
        if (this._tamanhoColunas != null) {
            String[] strTamanhos = this._tamanhoColunas.split(",");
            tamanhos = new int[strTamanhos.length];
            for (int i = 0; i < tamanhos.length; ++i) {
                tamanhos[i] = Integer.parseInt(strTamanhos[i].trim());
            }
        }
        return tamanhos;
    }

    public boolean hasTamanhoColunas() {
        return this._hasTamanhoColunas;
    }

    public void setAlinhamentoColunas(String alinhamentoColunas) {
        this._alinhamentoColunas = alinhamentoColunas;
        this._hasAlinhamentoColunas = true;
    }

    public String getAlinhamentoColunas() {
        return this._alinhamentoColunas;
    }

    public String[] getAlinhamentoColunasArray() {
        String[] tamanhos = new String[]{};
        if (this._alinhamentoColunas != null) {
            String[] strTamanhos = this._alinhamentoColunas.split(",");
            tamanhos = new String[strTamanhos.length];
            for (int i = 0; i < tamanhos.length; ++i) {
                tamanhos[i] = strTamanhos[i].trim();
            }
        }
        return tamanhos;
    }

    public boolean hasAlinhamentoColunas() {
        return this._hasAlinhamentoColunas;
    }

    public QuadroContas getAsQuadroContas() {
        return (QuadroContas)this;
    }

    public QuadroTotal getAsQuadroTotal() {
        return (QuadroTotal)this;
    }
}

