/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Campo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _nome;
    private int _inicio;
    private boolean _has_inicio;
    private int _final;
    private boolean _has_final;
    private String _coluna;
    private String _tipoDado;
    private int _tipoDadoId;
    private boolean _numerico;
    private boolean _inteiro;
    private boolean _valida = true;
    private String _codigoMensagem;
    private String _mascara;
    private boolean _calculado;
    private String _operacao;
    public static final int STRING_DATA_TYPE = 1;
    public static final int BIG_DECIMAL_DATA_TYPE = 2;
    public static final int INTEGER_DATA_TYPE = 3;
    public static final int LONG_DATA_TYPE = 4;
    public static final int DATE_DATA_TYPE = 5;
    public static final int CNPJ_DATA_TYPE = 6;
    private static final String STRING_DATA_TYPE_NAME = String.class.getName();
    private static final String BIG_DECIMAL_DATA_TYPE_NAME = BigDecimal.class.getName();
    private static final String INTEGER_DATA_TYPE_NAME = Integer.class.getName();
    private static final String LONG_DATA_TYPE_NAME = Long.class.getName();
    private static final String DATE_DATA_TYPE_NAME = Date.class.getName();
    private static final String SQL_DATE_DATA_TYPE_NAME = java.sql.Date.class.getName();
    private static final String CNPJ_DATA_TYPE_NAME = "br.gov.rs.tce.pad.beans.types.CNPJ";
    private String _argumentos;
    private boolean _temporario;
    private boolean _dataLaniente;
    private boolean _aceitaDataVazia;
    private String _label;
    private List<BaseRegraCampo> _baseRegraCampoList = new ArrayList<BaseRegraCampo>();

    public void deleteFinal() {
        this._has_final = false;
    }

    public void deleteInicio() {
        this._has_inicio = false;
    }

    public String getArgumentos() {
        return this._argumentos;
    }

    public boolean getCalculado() {
        return this._calculado;
    }

    public String getCodigoMensagem() {
        return this._codigoMensagem;
    }

    public String getColuna() {
        return this._coluna;
    }

    public int getFinal() {
        return this._final;
    }

    public int getInicio() {
        return this._inicio;
    }

    public String getMascara() {
        return this._mascara;
    }

    public String getNome() {
        return this._nome;
    }

    public String getOperacao() {
        return this._operacao;
    }

    public String getTipoDado() {
        return this._tipoDado;
    }

    public static String getTipoDado(int id) {
        String tipoDado = null;
        if (id == 1) {
            tipoDado = STRING_DATA_TYPE_NAME;
        } else if (id == 2) {
            tipoDado = BIG_DECIMAL_DATA_TYPE_NAME;
        } else if (id == 5) {
            tipoDado = DATE_DATA_TYPE_NAME;
        } else if (id == 3) {
            tipoDado = INTEGER_DATA_TYPE_NAME;
        } else if (id == 4) {
            tipoDado = LONG_DATA_TYPE_NAME;
        } else if (id == 6) {
            tipoDado = CNPJ_DATA_TYPE_NAME;
        }
        return tipoDado;
    }

    public boolean hasFinal() {
        return this._has_final;
    }

    public boolean hasInicio() {
        return this._has_inicio;
    }

    public void setArgumentos(String argumentos) {
        this._argumentos = argumentos;
    }

    public void setCalculado(boolean calculado) {
        this._calculado = calculado;
    }

    public void setCodigoMensagem(String codigoMensagem) {
        this._codigoMensagem = codigoMensagem;
    }

    public void setColuna(String coluna) {
        this._coluna = coluna;
    }

    public void setFinal(int _final) {
        this._final = _final;
        this._has_final = true;
    }

    public void setInicio(int inicio) {
        this._inicio = inicio;
        this._has_inicio = true;
    }

    public void setMascara(String mascara) {
        this._mascara = mascara;
    }

    public void setNome(String nome) {
        this._nome = nome;
    }

    public void setOperacao(String operacao) {
        this._operacao = operacao;
    }

    public void setTipoDado(String tipoDado) {
        this._tipoDado = tipoDado;
        this._tipoDadoId = Campo.getTipoDadoId(tipoDado);
    }

    public static int getTipoDadoId(String nomeTipoDado) {
        int tipoDado = 0;
        if (nomeTipoDado.equals(STRING_DATA_TYPE_NAME)) {
            tipoDado = 1;
        } else if (nomeTipoDado.equals(BIG_DECIMAL_DATA_TYPE_NAME)) {
            tipoDado = 2;
        } else if (nomeTipoDado.equals(DATE_DATA_TYPE_NAME) || nomeTipoDado.equals(SQL_DATE_DATA_TYPE_NAME)) {
            tipoDado = 5;
        } else if (nomeTipoDado.equals(INTEGER_DATA_TYPE_NAME)) {
            tipoDado = 3;
        } else if (nomeTipoDado.equals(LONG_DATA_TYPE_NAME)) {
            tipoDado = 4;
        } else if (nomeTipoDado.equals(CNPJ_DATA_TYPE_NAME)) {
            tipoDado = 6;
        } else {
            throw new ConfiguracaoException("Tipo n\u00e3o reconhecido: '" + nomeTipoDado + "'");
        }
        return tipoDado;
    }

    public void setTemporario(boolean temporario) {
        this._temporario = temporario;
    }

    public boolean isTemporario() {
        return this._temporario;
    }

    public void addBaseRegraCampo(BaseRegraCampo baseRegraCampo) {
        this._baseRegraCampoList.add(baseRegraCampo);
    }

    public List<BaseRegraCampo> getBaseRegrasCampo() {
        return this._baseRegraCampoList;
    }

    public boolean equals(Object obj) {
        boolean retorno = false;
        if (obj != null || obj instanceof Campo) {
            retorno = true;
        }
        return retorno;
    }

    public int getTipoDadoId() {
        return this._tipoDadoId;
    }

    public void setNumerico(boolean numerico) {
        this._numerico = numerico;
    }

    public boolean isNumerico() {
        return this._numerico;
    }

    public void setInteiro(boolean inteiro) {
        this._inteiro = inteiro;
    }

    public boolean isInteiro() {
        return this._inteiro;
    }

    public void setValida(boolean valida) {
        this._valida = valida;
    }

    public boolean isValida() {
        return this._valida;
    }

    public void setDataLaniente(boolean dataLaniente) {
        this._dataLaniente = dataLaniente;
    }

    public boolean isDataLaniente() {
        return this._dataLaniente;
    }

    public void setAceitaDataVazia(boolean aceitaDataVazia) {
        this._aceitaDataVazia = aceitaDataVazia;
    }

    public boolean isAceitaDataVazia() {
        return this._aceitaDataVazia;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabelOuNome() {
        String ret = this.getLabel();
        if (ret == null) {
            ret = this.getNome();
        }
        return ret;
    }
}

