/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ldap;

import br.gov.rs.tce.ldap.exception.LdapException;
import java.util.Hashtable;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfiguracaoLdap {
    private static final String LDAP_SERVER_NAME = "certificado.ldapServerName";
    private static final String LDAP_SERVER_PORT = "certificado.port";
    private static final String LDAP_ROOT_USERNAME = "certificado.rootDN";
    private static final String LDAP_ROOT_PASSWORD = "certificado.rootPass";
    private static final String LDAP_DIRECTORY = "certificado.dirConnect";
    private static String RESOURCES = null;
    private static ConfiguracaoLdap instance = null;
    private CompositeConfiguration config = null;
    private static Log LOG = LogFactory.getLog(ConfiguracaoLdap.class.getClass());

    private ConfiguracaoLdap(String arquivoConfiguracao) throws LdapException {
        RESOURCES = arquivoConfiguracao;
        try {
            char defaultListDelimiter = PropertiesConfiguration.getDefaultListDelimiter();
            PropertiesConfiguration.setDefaultListDelimiter((char)';');
            this.config = new CompositeConfiguration();
            this.config.addConfiguration((Configuration)new PropertiesConfiguration(arquivoConfiguracao));
            PropertiesConfiguration.setDefaultListDelimiter((char)defaultListDelimiter);
        }
        catch (ConfigurationException ex) {
            LOG.error((Object)("Erro ao inicializar configura\u00e7\u00f5es do LDAP com o resources '" + arquivoConfiguracao + "'"), (Throwable)ex);
            throw new LdapException("Erro ao inicializar configura\u00e7\u00f5es do LDAP com o resources '" + arquivoConfiguracao + "'", (Exception)((Object)ex));
        }
    }

    public static ConfiguracaoLdap getInstance() throws LdapException {
        return ConfiguracaoLdap.getInstance("ldap.properties");
    }

    public static ConfiguracaoLdap getInstance(String arquivoConfiguracao) throws LdapException {
        if (instance == null) {
            instance = new ConfiguracaoLdap(arquivoConfiguracao);
        }
        return instance;
    }

    public synchronized Hashtable getEnvironmentProperties(String username, String password) {
        LOG.info((Object)("Obtendo informacoes do servidor ldap em [" + RESOURCES + "]."));
        String dirConnect = this.config.getString(LDAP_DIRECTORY);
        String ldapServerName = this.config.getString(LDAP_SERVER_NAME);
        String ldapServerPort = this.config.getString(LDAP_SERVER_PORT);
        String rootdn = username;
        String rootpass = password;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ldapServerName + ":" + ldapServerPort + "/" + dirConnect);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", rootdn);
        env.put("java.naming.security.credentials", rootpass);
        return env;
    }

    public Hashtable getRootEnvironmentProperties() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        LOG.info((Object)("Obtendo informacoes do servidor ldap em [" + RESOURCES + "] como ROOT."));
        String dirConnect = this.config.getString(LDAP_DIRECTORY);
        String ldapServerName = this.config.getString(LDAP_SERVER_NAME);
        String ldapServerPort = this.config.getString(LDAP_SERVER_PORT);
        String rootdn = "CN=" + this.config.getString(LDAP_ROOT_USERNAME);
        String rootpass = this.config.getString(LDAP_ROOT_PASSWORD);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ldapServerName + ":" + ldapServerPort + "/" + dirConnect);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", rootdn);
        env.put("java.naming.security.credentials", rootpass);
        return env;
    }

    public synchronized String formatUsername(String username) {
        LOG.info((Object)("Obtendo informacoes do servidor ldap em [" + RESOURCES + "]."));
        String formatedUsername = null;
        String dirConnect = this.config.getString(LDAP_DIRECTORY);
        formatedUsername = "CN=" + username + "," + dirConnect;
        return formatedUsername;
    }

    public String getRootUsername() {
        LOG.info((Object)("Obtendo informacoes do servidor ldap em [" + RESOURCES + "] como ROOT."));
        return "CN=" + this.config.getString(LDAP_ROOT_USERNAME);
    }

    public String getRootPassword() {
        LOG.info((Object)("Obtendo informacoes do servidor ldap em [" + RESOURCES + "] como ROOT."));
        return this.config.getString(LDAP_ROOT_PASSWORD);
    }
}

