/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.validacao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataHoraHelper {
    static Log LOG = LogFactory.getLog(DataHoraHelper.class);
    public static final String DEFAULT_DATE_MASK = "dd/MM/yyyy";
    public static final String DATE_TIME_MASK = "dd/MM/yyyy HH:mm:ss";
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat fmtDateTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public static long diasDeDiferenca(Calendar calPres, Calendar calPast) {
        long timePast = calPast.getTimeInMillis();
        long timePres = calPres.getTimeInMillis();
        return Math.round((double)(timePres - timePast) / 8.64E7);
    }

    public static int idadeEmAnos(Calendar calPres, Calendar calNasc) {
        int presAno = calPres.get(1);
        int presMes = calPres.get(2);
        int presDia = calPres.get(5);
        int nascAno = calNasc.get(1);
        int nascMes = calNasc.get(2);
        int nascDia = calNasc.get(5);
        int sub = nascMes > presMes || nascMes == presMes && nascDia > presDia ? 1 : 0;
        int idade = presAno - nascAno - sub;
        return idade;
    }

    public static boolean dtIsBetween(Calendar dt, Calendar start, Calendar end) {
        dt = DataHoraHelper.zerarHora(dt);
        start = DataHoraHelper.zerarHora(start);
        end = DataHoraHelper.zerarHora(end);
        return dt.compareTo(start) >= 0 && dt.compareTo(end) < 0;
    }

    public static boolean dtIsBetweenClosedRange(Calendar dt, Calendar start, Calendar end) {
        dt = DataHoraHelper.zerarHora(dt);
        start = DataHoraHelper.zerarHora(start);
        end = DataHoraHelper.zerarHora(end);
        return dt.compareTo(start) >= 0 && dt.compareTo(end) <= 0;
    }

    public static boolean dtIsBetweenAcceptNull(Calendar dt, Calendar start, Calendar end) {
        dt = DataHoraHelper.zerarHora(dt);
        if (start == null && end == null) {
            LOG.debug((Object)"dtIsBetweenAcceptNull(): start e end null...");
            return true;
        }
        if (start == null) {
            return dt.compareTo(end = DataHoraHelper.zerarHora(end)) < 0;
        }
        if (end == null) {
            return dt.compareTo(start = DataHoraHelper.zerarHora(start)) >= 0;
        }
        return dt.compareTo(start) >= 0 && dt.compareTo(end) < 0;
    }

    public static boolean dtIsBetweenAcceptNullClosedRange(Calendar dt, Calendar start, Calendar end) {
        dt = DataHoraHelper.zerarHora(dt);
        if (start == null && end == null) {
            LOG.debug((Object)"dtIsBetweenAcceptNullClosedRange(): start e end null...");
            return true;
        }
        if (start == null) {
            return dt.compareTo(end = DataHoraHelper.zerarHora(end)) <= 0;
        }
        if (end == null) {
            return dt.compareTo(start = DataHoraHelper.zerarHora(start)) >= 0;
        }
        return dt.compareTo(start) >= 0 && dt.compareTo(end) <= 0;
    }

    public static boolean dtIgual(Calendar dt1, Calendar dt2) {
        return (dt1 = DataHoraHelper.zerarHora(dt1)).compareTo(dt2 = DataHoraHelper.zerarHora(dt2)) == 0;
    }

    public static boolean dtMaior(oracle.jbo.domain.Date start, oracle.jbo.domain.Date end) {
        GregorianCalendar cStart = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(start));
        GregorianCalendar cEnd = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(end));
        return DataHoraHelper.dtMaior(cStart, cEnd);
    }

    public static boolean dtMaiorOuIgual(oracle.jbo.domain.Date start, oracle.jbo.domain.Date end) {
        GregorianCalendar cStart = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(start));
        GregorianCalendar cEnd = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(end));
        return DataHoraHelper.dtMaiorOuIgual(cStart, cEnd);
    }

    public static boolean dtMenor(oracle.jbo.domain.Date start, oracle.jbo.domain.Date end) {
        GregorianCalendar cStart = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(start));
        GregorianCalendar cEnd = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(end));
        return DataHoraHelper.dtMenor(cStart, cEnd);
    }

    public static boolean dtMenorOuIgual(oracle.jbo.domain.Date start, oracle.jbo.domain.Date end) {
        GregorianCalendar cStart = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(start));
        GregorianCalendar cEnd = DataHoraHelper.zerarHora(DataHoraHelper.getCalendar(end));
        return DataHoraHelper.dtMenorOuIgual(cStart, cEnd);
    }

    public static boolean dtMaior(Calendar start, Calendar end) {
        return (start = DataHoraHelper.zerarHora(start)).compareTo(end = DataHoraHelper.zerarHora(end)) > 0;
    }

    public static boolean dtMaiorOuIgual(Calendar start, Calendar end) {
        return (start = DataHoraHelper.zerarHora(start)).compareTo(end = DataHoraHelper.zerarHora(end)) >= 0;
    }

    public static boolean dtMenor(Calendar start, Calendar end) {
        start = DataHoraHelper.zerarHora(start);
        return (end = DataHoraHelper.zerarHora(end)).compareTo(start) > 0;
    }

    public static boolean dtMenorOuIgual(Calendar start, Calendar end) {
        start = DataHoraHelper.zerarHora(start);
        return (end = DataHoraHelper.zerarHora(end)).compareTo(start) >= 0;
    }

    public static Calendar stringToCalendar(String data) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DEFAULT_DATE_MASK);
            Date date = formatter.parse(data);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            System.out.println("Exception :" + e);
            return null;
        }
    }

    public static GregorianCalendar zerarHora(Calendar dt) {
        return new GregorianCalendar(dt.get(1), dt.get(2), dt.get(5));
    }

    public static boolean isDate(Object value) {
        Date d = DataHoraHelper.getDate(value);
        return d != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof oracle.jbo.domain.Date) {
            oracle.jbo.domain.Date oraDate = (oracle.jbo.domain.Date)value;
            return oraDate.dateValue();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof String) {
            try {
                SimpleDateFormat oraDate = fmt;
                synchronized (oraDate) {
                    return fmt.parse((String)value);
                }
            }
            catch (ParseException e) {
                LOG.debug((Object)("valor [" + value + "] nao \u00e9 date. Exception: " + e));
                return null;
            }
        }
        LOG.warn((Object)("isDate(): conversor para Date nao conhecido... " + value + " / class: " + value.getClass()));
        return null;
    }

    public static Calendar getCalendar(Object value) {
        Date d = DataHoraHelper.getDate(value);
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return c;
    }

    public static synchronized String getDateStr(Object o) {
        if (o == null) {
            return "[date=null]";
        }
        Date d = DataHoraHelper.getDate(o);
        return fmt.format(d);
    }

    public static synchronized String getDateTimeStr(Object o) {
        if (o == null) {
            return "[date=null]";
        }
        Date d = DataHoraHelper.getDate(o);
        return fmtDateTime.format(d);
    }

    public static boolean dtIntervalosColidem(Calendar dataIniIntervalo1, Calendar dataFimIntervalo1, Calendar dataIniIntervalo2, Calendar dataFimIntervalo2) {
        if (DataHoraHelper.dtIsBetween(dataIniIntervalo1, dataIniIntervalo2, dataFimIntervalo2)) {
            return true;
        }
        return DataHoraHelper.dtIsBetween(dataIniIntervalo2, dataIniIntervalo1, dataFimIntervalo1);
    }

    public static boolean dtIntervalosColidemFinalFechado(Calendar dataIniIntervalo1, Calendar dataFimIntervalo1, Calendar dataIniIntervalo2, Calendar dataFimIntervalo2) {
        if (DataHoraHelper.dtIsBetweenClosedRange(dataIniIntervalo1, dataIniIntervalo2, dataFimIntervalo2)) {
            return true;
        }
        return DataHoraHelper.dtIsBetweenClosedRange(dataIniIntervalo2, dataIniIntervalo1, dataFimIntervalo1);
    }

    @Deprecated
    public static boolean validaIntervalosDeDatasNaoColidentes(Calendar dataIniIntervalo1, Calendar dataFimIntervalo1, Calendar dataIniIntervalo2, Calendar dataFimIntervalo2) {
        if (DataHoraHelper.dtIsBetween(dataIniIntervalo1, dataIniIntervalo2, dataFimIntervalo2)) {
            LOG.debug((Object)("dtIni[int1]: " + DataHoraHelper.getDateStr(dataIniIntervalo1) + " // [int2] cIni: " + DataHoraHelper.getDateStr(dataIniIntervalo2) + " cFim: " + DataHoraHelper.getDateStr(dataFimIntervalo2)));
            return false;
        }
        if (DataHoraHelper.dtIsBetween(dataFimIntervalo1, dataIniIntervalo2, dataFimIntervalo2)) {
            LOG.debug((Object)("dtFim[int1]: " + DataHoraHelper.getDateStr(dataFimIntervalo1) + " // [int2] cIni: " + DataHoraHelper.getDateStr(dataIniIntervalo2) + " cFim: " + DataHoraHelper.getDateStr(dataFimIntervalo2)));
            return false;
        }
        if (DataHoraHelper.dtIsBetween(dataIniIntervalo2, dataIniIntervalo1, dataFimIntervalo1)) {
            LOG.debug((Object)("dtIni[int2]: " + DataHoraHelper.getDateStr(dataIniIntervalo2) + " // [int1] cIni: " + DataHoraHelper.getDateStr(dataIniIntervalo1) + " cFim: " + DataHoraHelper.getDateStr(dataFimIntervalo1)));
            return false;
        }
        if (DataHoraHelper.dtIsBetween(dataFimIntervalo2, dataIniIntervalo1, dataFimIntervalo1)) {
            LOG.debug((Object)("dtFim[int2]: " + DataHoraHelper.getDateStr(dataFimIntervalo2) + " // [int1] cIni: " + DataHoraHelper.getDateStr(dataIniIntervalo1) + " cFim: " + DataHoraHelper.getDateStr(dataFimIntervalo1)));
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String s1 = "21/07/1979";
        String s2 = "22/07/1979";
        String sx = "22-07-1979";
        System.out.println("isDate[" + s1 + "]: " + DataHoraHelper.isDate(s1));
        System.out.println("isDate[" + sx + "]: " + DataHoraHelper.isDate(sx));
        Date d1 = fmt.parse(s1);
        Date d2 = fmt.parse(s2);
        System.out.println("after[" + d1 + " / " + d2 + "]: " + d1.after(d2));
        System.out.println("after[" + d2 + " / " + d1 + "]: " + d2.after(d1));
        System.out.println("after[" + d1 + " / " + d1 + "]: " + d1.after(d1));
        System.out.println("dtMaior[" + s1 + " / " + s2 + "]: " + DataHoraHelper.dtMaior(DataHoraHelper.stringToCalendar(s1), DataHoraHelper.stringToCalendar(s2)));
        System.out.println("dtMaior[" + s2 + " / " + s1 + "]: " + DataHoraHelper.dtMaior(DataHoraHelper.stringToCalendar(s2), DataHoraHelper.stringToCalendar(s1)));
        d1 = fmt.parse("22/07/1980");
        d2 = fmt.parse("21/07/1980");
        System.out.println("diasDeDiff[" + d1 + "/" + d2 + "]: " + DataHoraHelper.diasDeDiferenca(DataHoraHelper.getCalendar(d1), DataHoraHelper.getCalendar(d2)));
        GregorianCalendar c = new GregorianCalendar(2008, 1, 1);
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " max(day-of-month): " + ((Calendar)c).getMaximum(5));
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " act-max(day-of-month): " + ((Calendar)c).getActualMaximum(5));
        c = new GregorianCalendar(2008, 2, 1);
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " max(day-of-month): " + ((Calendar)c).getMaximum(5));
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " act-max(day-of-month): " + ((Calendar)c).getActualMaximum(5));
        c = new GregorianCalendar(2008, 3, 1);
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " max(day-of-month): " + ((Calendar)c).getMaximum(5));
        System.out.println("cal: " + DataHoraHelper.getDateStr(c) + " act-max(day-of-month): " + ((Calendar)c).getActualMaximum(5));
    }

    static {
        fmt.setLenient(false);
    }

    public static class DataComparator
    implements Comparator<Calendar> {
        @Override
        public int compare(Calendar c1, Calendar c2) {
            c1 = DataHoraHelper.zerarHora(c1);
            c2 = DataHoraHelper.zerarHora(c2);
            return c1.compareTo(c2);
        }
    }
}

