/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.excecao;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.TooManyObjectsException;

public class ExceptionHelper {
    private static final String SPACES = "                                      ";

    public static boolean isOrCausedByDuplicateRow(JboException jboex) {
        return ExceptionHelper.isOrCausedByExceptionClass(jboex, TooManyObjectsException.class);
    }

    public static String exceptionIncludingDetails(JboException jboex, Locale locale) {
        StringWriter sw = new StringWriter();
        ExceptionHelper.showExceptionIncludingDetails((Exception)jboex, 0, new PrintWriter(sw), locale);
        return sw.toString();
    }

    public static String exceptionIncludingDetails(JboException jboex) {
        StringWriter sw = new StringWriter();
        ExceptionHelper.showExceptionIncludingDetails((Exception)jboex, 0, new PrintWriter(sw), new Locale("pt", "BR"));
        return sw.toString();
    }

    public static void showExceptionIncludingDetails(JboException ex, ApplicationModule am) {
        Locale locale = am.getSession().getLocale();
        PrintWriter pw = new PrintWriter(System.out);
        ExceptionHelper.showExceptionIncludingDetails((Exception)ex, 0, pw, locale);
        pw.flush();
        pw.close();
    }

    private static void showExceptionIncludingDetails(Exception ex, int lev, PrintWriter pw, Locale locale) {
        if (ex instanceof JboException) {
            JboException jboex = (JboException)ex;
            ExceptionHelper.printMessageForLevel((Exception)jboex, lev, pw, locale);
            Object[] details = jboex.getDetails();
            int count = details.length;
            for (int z = 0; z < count; ++z) {
                Exception cur = (Exception)details[z];
                if (cur instanceof JboException) {
                    ExceptionHelper.showExceptionIncludingDetails((Exception)((JboException)cur), lev + 1, pw, locale);
                    continue;
                }
                ExceptionHelper.printMessageForLevel((Exception)jboex, lev + 1, pw, locale);
            }
        } else {
            ExceptionHelper.printMessageForLevel(ex, lev, pw, locale);
        }
    }

    public static String message(Exception ex, Locale locale) {
        String msg = null;
        if (ex instanceof JboException) {
            JboException jboex = (JboException)ex;
            msg = MessageFormat.format(jboex.getLocalizedBaseMessage(locale), jboex.getErrorParameters());
        } else {
            msg = ex.getLocalizedMessage();
        }
        return msg;
    }

    public static String message(Exception ex, ApplicationModule am) {
        Locale locale = am.getSession().getLocale();
        String msg = null;
        if (ex instanceof JboException) {
            JboException jboex = (JboException)ex;
            msg = MessageFormat.format(jboex.getLocalizedBaseMessage(locale), jboex.getErrorParameters());
        } else {
            msg = ex.getLocalizedMessage();
        }
        return msg;
    }

    private static void printMessageForLevel(Exception ex, int lev, PrintWriter pw, Locale locale) {
        String msg = ExceptionHelper.message(ex, locale);
        pw.println(lev == 0 ? msg : SPACES.substring(0, lev * 2) + "\\_" + msg);
    }

    private static boolean isOrCausedByExceptionClass(JboException j, Class excepClass) {
        boolean ret = false;
        if (j.getClass().equals(excepClass)) {
            return true;
        }
        Object[] details = j.getDetails();
        int count = details.length;
        for (int z = 0; !ret && z < count; ++z) {
            Exception cur = (Exception)details[z];
            if (cur.getClass().equals(excepClass)) {
                return true;
            }
            if (!(cur instanceof JboException)) continue;
            ret = ExceptionHelper.isOrCausedByExceptionClass((JboException)cur, excepClass);
        }
        return ret;
    }
}

