/*
 * Decompiled with CFR 0.152.
 */
package view.binding.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.binding.AttributeBinding;
import oracle.binding.AttributeBindingListener;
import view.sample.swing.HRPanel;

public class STextComponentBinder
implements AttributeBindingListener,
FocusListener,
ActionListener {
    private AttributeBinding mBinding;
    private JTextComponent mControl;
    private HRPanel mHrPanel;

    public STextComponentBinder(AttributeBinding attributeBinding, JTextComponent jTextComponent, HRPanel hRPanel) {
        this.setControl(jTextComponent);
        this.mBinding = attributeBinding;
        attributeBinding.setListener(this);
        this.mHrPanel = hRPanel;
        this.updateRenderer();
    }

    public void updateRenderer() {
        Object object = this.mBinding.getInputValue();
        this.mControl.setText(object != null ? object.toString() : "");
    }

    void setControl(JTextComponent jTextComponent) {
        this.mControl = jTextComponent;
        if (jTextComponent != null) {
            if (jTextComponent instanceof JTextField) {
                ((JTextField)jTextComponent).addActionListener(this);
                ((JTextField)jTextComponent).addFocusListener(this);
            }
        } else if (jTextComponent == null) {
            if (this.mControl instanceof JTextField) {
                ((JTextField)this.mControl).removeActionListener(this);
            }
            this.mControl = null;
            this.mBinding.release(-1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateBinding();
        this.mHrPanel.updateActionRenderer();
    }

    public void updateBinding() {
        Object object = this.mBinding.getInputValue();
        String string = this.mControl.getText();
        if (object != null && !object.toString().equals(string) || object == null && string.trim().length() > 0) {
            this.mBinding.setInputValue(string);
        }
    }

    public AttributeBinding getAttributeBinding() {
        return this.mBinding;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.updateBinding();
        this.mHrPanel.updateActionRenderer();
    }
}

