/*
 * Decompiled with CFR 0.152.
 */
package unittest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import model.datacontrol.javabeans.hrservice.SDeptBean;
import model.datacontrol.javabeans.hrservice.SEmpBean;
import model.datacontrol.javabeans.hrservice.meta.DeparmentDataControlDefinition;
import model.datacontrol.javabeans.hrservice.meta.EmployeeStructureDefinition;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.DefaultDefinitionContext;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.DefinitionContext;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;

public class BindingTest
extends TestCase {
    private Context _context;

    private /* synthetic */ void $init$() {
        this._context = null;
    }

    public BindingTest() {
        this.$init$();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._context = new InitialContext();
        DefaultDefinitionContext defaultDefinitionContext = new DefaultDefinitionContext();
        defaultDefinitionContext.put("EmployeeDataControl", new DeparmentDataControlDefinition(defaultDefinitionContext));
        this._context.bind("java:comp/env/jsr227/metadata/hrApplication", (Object)defaultDefinitionContext);
    }

    protected void tearDown() throws Exception {
        this._context.unbind("java:comp/env/jsr227/metadata/hrApplication");
        super.tearDown();
    }

    public void testFindDataControlMetaData() throws Exception {
        DefinitionContext definitionContext = (DefinitionContext)this._context.lookup("java:comp/env/jsr227/metadata/hrApplication");
        BindingTest.assertNotNull((Object)definitionContext);
        DataControlDefinition dataControlDefinition = (DataControlDefinition)definitionContext.get("EmployeeDataControl");
        BindingTest.assertNotNull((Object)dataControlDefinition);
        StructureDefinition structureDefinition = dataControlDefinition.getStructure();
        BindingTest.assertNotNull((Object)structureDefinition);
        BindingTest.assertEquals((String)structureDefinition.getName(), (String)"DepartmentDataControl");
    }

    public void testTraverseAccessors() throws Exception {
        StructureDefinition structureDefinition = this.getDeptStructure();
        Iterator iterator = structureDefinition.getAccessorDefinitions().iterator();
        while (iterator.hasNext()) {
            AccessorDefinition accessorDefinition = (AccessorDefinition)iterator.next();
            BindingTest.assertNotNull((Object)accessorDefinition);
        }
    }

    private StructureDefinition getDeptStructure() throws NamingException {
        DefinitionContext definitionContext = (DefinitionContext)this._context.lookup("java:comp/env/jsr227/metadata/hrApplication");
        BindingTest.assertNotNull((Object)definitionContext);
        DataControlDefinition dataControlDefinition = (DataControlDefinition)definitionContext.get("EmployeeDataControl");
        BindingTest.assertNotNull((Object)dataControlDefinition);
        StructureDefinition structureDefinition = dataControlDefinition.getStructure();
        BindingTest.assertNotNull((Object)structureDefinition);
        BindingTest.assertEquals((String)structureDefinition.getName(), (String)"DepartmentDataControl");
        return structureDefinition;
    }

    public void testDeptAccessor() throws Exception {
        StructureDefinition structureDefinition = this.getDeptStructure();
        BindingTest.assertNotNull((Object)structureDefinition);
        BindingTest.assertEquals((String)structureDefinition.getName(), (String)"DepartmentDataControl");
        AccessorDefinition accessorDefinition = (AccessorDefinition)structureDefinition.getAccessorDefinitions().find("emps");
        BindingTest.assertNotNull((Object)accessorDefinition);
        StructureDefinition structureDefinition2 = accessorDefinition.getStructure();
        BindingTest.assertNotNull((Object)structureDefinition2);
        AttributeDefinition attributeDefinition = (AttributeDefinition)structureDefinition2.getAttributeDefinitions().find("empno");
        BindingTest.assertNotNull((Object)attributeDefinition);
        AttributeDefinition attributeDefinition2 = (AttributeDefinition)structureDefinition2.getAttributeDefinitions().find("deptno");
        BindingTest.assertNotNull((Object)attributeDefinition2);
        AttributeDefinition attributeDefinition3 = (AttributeDefinition)structureDefinition2.getAttributeDefinitions().find("ename");
        BindingTest.assertNotNull((Object)attributeDefinition3);
        AttributeDefinition attributeDefinition4 = (AttributeDefinition)structureDefinition2.getAttributeDefinitions().find("job");
        BindingTest.assertNotNull((Object)attributeDefinition4);
        BindingTest.assertNull((Object)accessorDefinition.getParentAccessor());
    }

    public void testAddressAccessor() throws Exception {
        StructureDefinition structureDefinition = this.getDeptStructure();
        BindingTest.assertNotNull((Object)structureDefinition);
        BindingTest.assertEquals((String)structureDefinition.getName(), (String)"DepartmentDataControl");
        AccessorDefinition accessorDefinition = (AccessorDefinition)structureDefinition.getAccessorDefinitions().find("emps");
        BindingTest.assertNotNull((Object)accessorDefinition);
        BindingTest.assertEquals((String)"empAccessorDef.getType", (int)40, (int)accessorDefinition.getDefinitionType());
        StructureDefinition structureDefinition2 = accessorDefinition.getStructure();
        BindingTest.assertNotNull((Object)structureDefinition2);
        BindingTest.assertEquals((String)"empDef.getType", (int)20, (int)structureDefinition2.getDefinitionType());
        AccessorDefinition accessorDefinition2 = (AccessorDefinition)structureDefinition2.getAccessorDefinitions().find("address");
        BindingTest.assertNotNull((Object)accessorDefinition2);
        BindingTest.assertEquals((String)"addressAccessorDef.getType", (int)40, (int)accessorDefinition2.getDefinitionType());
        BindingTest.assertEquals((String)"addressAccessorDef.getParentAccessor", (Object)accessorDefinition, (Object)accessorDefinition2.getParentAccessor());
        StructureDefinition structureDefinition3 = accessorDefinition2.getStructure();
        BindingTest.assertNotNull((Object)structureDefinition3);
        BindingTest.assertEquals((String)"addressDef.getType", (int)20, (int)structureDefinition3.getDefinitionType());
        AttributeDefinition attributeDefinition = (AttributeDefinition)structureDefinition3.getAttributeDefinitions().find("street");
        BindingTest.assertEquals((int)30, (int)attributeDefinition.getDefinitionType());
        AttributeDefinition attributeDefinition2 = (AttributeDefinition)structureDefinition3.getAttributeDefinitions().find("city");
        BindingTest.assertEquals((int)30, (int)attributeDefinition2.getDefinitionType());
        AttributeDefinition attributeDefinition3 = (AttributeDefinition)structureDefinition3.getAttributeDefinitions().find("postal_code");
        BindingTest.assertEquals((int)30, (int)attributeDefinition3.getDefinitionType());
        AttributeDefinition attributeDefinition4 = (AttributeDefinition)structureDefinition3.getAttributeDefinitions().find("country");
        BindingTest.assertEquals((int)30, (int)attributeDefinition4.getDefinitionType());
    }

    public void testDeptAttributes() throws Exception {
        StructureDefinition structureDefinition = this.getDeptStructure();
        AttributeDefinition attributeDefinition = (AttributeDefinition)structureDefinition.getAttributeDefinitions().find("deptno");
        BindingTest.assertNotNull((Object)attributeDefinition);
        BindingTest.assertEquals((String)attributeDefinition.getName(), (String)"deptno");
        AttributeDefinition attributeDefinition2 = (AttributeDefinition)structureDefinition.getAttributeDefinitions().find("name");
        BindingTest.assertNotNull((Object)attributeDefinition2);
        BindingTest.assertEquals((String)attributeDefinition2.getName(), (String)"name");
        AttributeDefinition attributeDefinition3 = (AttributeDefinition)structureDefinition.getAttributeDefinitions().find("loc");
        BindingTest.assertNotNull((Object)attributeDefinition3);
        BindingTest.assertEquals((String)attributeDefinition3.getName(), (String)"loc");
        AttributeDefinition attributeDefinition4 = (AttributeDefinition)structureDefinition.getAttributeDefinitions().find("hasManager");
        BindingTest.assertNotNull((Object)attributeDefinition4);
        BindingTest.assertEquals((String)attributeDefinition4.getName(), (String)"hasManager");
    }

    private void assertName(NamedDefinition namedDefinition, String string) {
        BindingTest.assertNotNull((Object)namedDefinition);
        BindingTest.assertEquals((String)namedDefinition.getName(), (String)string);
    }

    private void assertEmptyParam(DefinitionContainer definitionContainer) {
        BindingTest.assertNotNull((Object)definitionContainer);
        BindingTest.assertFalse((boolean)definitionContainer.iterator().hasNext());
    }

    private void assertSimpleType(ParameterDefinition parameterDefinition, String string, boolean bl) {
        BindingTest.assertNotNull((Object)parameterDefinition);
        BindingTest.assertEquals((String)string, (String)parameterDefinition.getJavaTypeString());
        BindingTest.assertFalse((boolean)parameterDefinition.isStructured());
        BindingTest.assertNull((Object)parameterDefinition.getStructure());
        BindingTest.assertEquals((boolean)bl, (boolean)parameterDefinition.isCollection());
    }

    private void assertStructureType(ParameterDefinition parameterDefinition, StructureDefinition structureDefinition, boolean bl) {
        BindingTest.assertNotNull((Object)parameterDefinition);
        BindingTest.assertNull((Object)parameterDefinition.getJavaTypeString());
        BindingTest.assertTrue((boolean)parameterDefinition.isStructured());
        BindingTest.assertNotNull((Object)parameterDefinition.getStructure());
        BindingTest.assertEquals((Object)structureDefinition, (Object)parameterDefinition.getStructure());
        BindingTest.assertEquals((boolean)bl, (boolean)parameterDefinition.isCollection());
    }

    public void testDeptMethods() throws Exception {
        StructureDefinition structureDefinition = this.getDeptStructure();
        DefinitionContext definitionContext = (DefinitionContext)this._context.lookup("java:comp/env/jsr227/metadata/hrApplication");
        EmployeeStructureDefinition employeeStructureDefinition = (EmployeeStructureDefinition)definitionContext.get("EmployeeStructureDefinition");
        OperationDefinition operationDefinition = (OperationDefinition)structureDefinition.getOperationDefinitions().find("doStuff");
        this.assertName(operationDefinition, "doStuff");
        this.assertEmptyParam(operationDefinition.getOperationParameters());
        BindingTest.assertNull((Object)operationDefinition.getOperationReturnType());
        OperationDefinition operationDefinition2 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("showName");
        this.assertName(operationDefinition2, "showName");
        this.assertEmptyParam(operationDefinition2.getOperationParameters());
        this.assertSimpleType(operationDefinition2.getOperationReturnType(), "java.lang.String", false);
        OperationDefinition operationDefinition3 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("getEmployee");
        this.assertName(operationDefinition3, "getEmployee");
        ParameterDefinition parameterDefinition = (ParameterDefinition)operationDefinition3.getOperationParameters().find("index");
        this.assertSimpleType(parameterDefinition, "java.lang.Integer", false);
        this.assertStructureType(operationDefinition3.getOperationReturnType(), employeeStructureDefinition, false);
        OperationDefinition operationDefinition4 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("listEnames");
        this.assertName(operationDefinition4, "listEnames");
        this.assertEmptyParam(operationDefinition4.getOperationParameters());
        this.assertSimpleType(operationDefinition4.getOperationReturnType(), "java.lang.String", true);
        OperationDefinition operationDefinition5 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("findEmployeesByJob");
        this.assertName(operationDefinition5, "findEmployeesByJob");
        ParameterDefinition parameterDefinition2 = (ParameterDefinition)operationDefinition5.getOperationParameters().find("job");
        this.assertSimpleType(parameterDefinition2, "java.lang.String", false);
        this.assertStructureType(operationDefinition5.getOperationReturnType(), employeeStructureDefinition, true);
        OperationDefinition operationDefinition6 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("findEmployeesByJobAsArray");
        this.assertName(operationDefinition6, "findEmployeesByJobAsArray");
        parameterDefinition2 = (ParameterDefinition)operationDefinition6.getOperationParameters().find("job");
        this.assertSimpleType(parameterDefinition2, "java.lang.String", false);
        this.assertStructureType(operationDefinition6.getOperationReturnType(), employeeStructureDefinition, true);
        OperationDefinition operationDefinition7 = (OperationDefinition)structureDefinition.getOperationDefinitions().find("findManager");
        this.assertName(operationDefinition7, "findManager");
        ParameterDefinition parameterDefinition3 = (ParameterDefinition)operationDefinition7.getOperationParameters().find("emp");
        ParameterDefinition parameterDefinition4 = (ParameterDefinition)operationDefinition7.getOperationParameters().find("flag");
        this.assertStructureType(parameterDefinition3, employeeStructureDefinition, false);
        this.assertSimpleType(parameterDefinition4, "java.lang.Boolean", false);
        this.assertStructureType(operationDefinition7.getOperationReturnType(), employeeStructureDefinition, false);
    }

    public void testSDeptBeanMethods() throws Exception {
        ArrayList<SEmpBean> arrayList = new ArrayList<SEmpBean>();
        arrayList.add(new SEmpBean(1, "A", "Pres", 1));
        arrayList.add(new SEmpBean(2, "B", "Mgr", 1));
        arrayList.add(new SEmpBean(3, "C", "PM", 1));
        ArrayList<SEmpBean> arrayList2 = new ArrayList<SEmpBean>();
        SEmpBean sEmpBean = new SEmpBean(4, "AA", "Sr Dev", 2);
        arrayList2.add(sEmpBean);
        arrayList2.add(new SEmpBean(5, "BB", "Dev", 2));
        arrayList2.add(new SEmpBean(6, "CC", "Dev", 2));
        ArrayList arrayList3 = new ArrayList();
        SDeptBean sDeptBean = new SDeptBean(1, "one", "loc1", "", arrayList, null);
        SDeptBean sDeptBean2 = new SDeptBean(2, "two", "loc2", null, arrayList2, null);
        SDeptBean sDeptBean3 = new SDeptBean(3, "three", "loc3", "x", arrayList3, null);
        BindingTest.assertEquals((String)"one", (String)sDeptBean.showName());
        BindingTest.assertEquals((Object)sEmpBean, (Object)sDeptBean2.getEmployee(0));
        BindingTest.assertNull((Object)sDeptBean2.getEmployee(100));
        BindingTest.assertNull((Object)sDeptBean2.getEmployee(-1));
        BindingTest.assertNull((Object)sDeptBean3.getEmployee(0));
        String[] stringArray = sDeptBean.listEnames();
        BindingTest.assertEquals((int)arrayList.size(), (int)stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            BindingTest.assertEquals((String)((SEmpBean)arrayList.get(n)).getEname(), (String)stringArray[n]);
            ++n;
        }
        BindingTest.assertNull((Object)sDeptBean3.listEnames());
        Collection collection = sDeptBean2.findEmployeesByJob("Dev");
        BindingTest.assertEquals((int)2, (int)collection.size());
        BindingTest.assertEquals((int)0, (int)sDeptBean2.findEmployeesByJob("No one").size());
        BindingTest.assertEquals((int)0, (int)sDeptBean3.findEmployeesByJob(null).size());
        SEmpBean[] sEmpBeanArray = sDeptBean2.findEmployeesByJobAsArray("Dev");
        BindingTest.assertEquals((int)2, (int)sEmpBeanArray.length);
        BindingTest.assertEquals((int)0, (int)sDeptBean2.findEmployeesByJobAsArray("No one").length);
        BindingTest.assertEquals((int)0, (int)sDeptBean3.findEmployeesByJobAsArray(null).length);
    }
}

