/*
 * Decompiled with CFR 0.152.
 */
package model.datacontrol.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import model.datacontrol.jdbc.JDBCDataControl;
import model.datacontrol.jdbc.Key;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.StructureDefinition;

public class TransactionManager {
    private final JDBCDataControl mDataControl;
    private final Connection mConnection;
    private boolean mIsTransactionDirty;
    private Map mModifiedObjects;
    private Map mDeletedObjects;
    private byte OBJECT_DELETED;
    private byte OBJECT_MODIFIED;
    private static /* synthetic */ Class class$oracle$binding$meta$StructureDefinition;

    private /* synthetic */ void $init$() {
        this.mIsTransactionDirty = false;
        this.mModifiedObjects = new HashMap(4);
        this.mDeletedObjects = new HashMap(4);
        this.OBJECT_DELETED = 1;
        this.OBJECT_MODIFIED = (byte)2;
    }

    public TransactionManager(String string, JDBCDataControl jDBCDataControl) {
        this.$init$();
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver", true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            this.mConnection = DriverManager.getConnection(string);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        this.mDataControl = jDBCDataControl;
    }

    public void objectModified(StructureDefinition structureDefinition, Object object, Key key) {
        this.addToTransactionList(structureDefinition, object, key, this.OBJECT_MODIFIED);
        this.mIsTransactionDirty = true;
    }

    public void objectDeleted(StructureDefinition structureDefinition, Object object, Key key) {
        this.addToTransactionList(structureDefinition, object, key, this.OBJECT_DELETED);
        this.mIsTransactionDirty = true;
    }

    public void objectCreated(StructureDefinition structureDefinition, Object object) {
        this.mIsTransactionDirty = true;
    }

    public void postChanges() {
        Iterator iterator = this.mModifiedObjects.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)this.mModifiedObjects.get(string);
            ArrayList<Map> arrayList = new ArrayList<Map>(map.size());
            Class clazz = class$oracle$binding$meta$StructureDefinition;
            if (clazz == null) {
                clazz = TransactionManager.class$("oracle.binding.meta.StructureDefinition");
            }
            StructureDefinition structureDefinition = (StructureDefinition)this.mDataControl.getDefinition(string, clazz);
            Iterator iterator2 = map.values().iterator();
            while (iterator2.hasNext()) {
                Map map2 = (Map)iterator2.next();
                if (!new Key(structureDefinition, map2).hasValues()) {
                    throw new RuntimeException("ERROR:  Cannot write object with undefined key");
                }
                arrayList.add(map2);
            }
            this.writeMaps(string, arrayList, true);
        }
        iterator = this.mDeletedObjects.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)this.mDeletedObjects.get(string);
            Iterator iterator3 = map.values().iterator();
            ArrayList<Map> arrayList = new ArrayList<Map>(map.size());
            Class clazz = class$oracle$binding$meta$StructureDefinition;
            if (clazz == null) {
                clazz = TransactionManager.class$("oracle.binding.meta.StructureDefinition");
            }
            StructureDefinition structureDefinition = (StructureDefinition)this.mDataControl.getDefinition(string, clazz);
            while (iterator3.hasNext()) {
                Map map3 = (Map)iterator3.next();
                if (!new Key(structureDefinition, map3).hasValues()) {
                    throw new RuntimeException("ERROR:  Cannot remove object with undefined key");
                }
                arrayList.add(map3);
            }
            this.removeMaps(string, arrayList);
        }
    }

    public void commit() {
        if (this.mIsTransactionDirty) {
            this.postChanges();
            try {
                this.mConnection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
        }
        this.mIsTransactionDirty = false;
    }

    public void rollback() {
        if (this.mIsTransactionDirty) {
            try {
                this.mConnection.rollback();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
        }
        this.mDeletedObjects.clear();
        this.mModifiedObjects.clear();
        this.mIsTransactionDirty = false;
    }

    public boolean isTransactionDirty() {
        return this.mIsTransactionDirty;
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public void close() {
        try {
            this.mConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void addToTransactionList(StructureDefinition structureDefinition, Object object, Key key, byte by) {
        Map map = by == this.OBJECT_DELETED ? this.mDeletedObjects : this.mModifiedObjects;
        HashMap<Key, Object> hashMap = (HashMap<Key, Object>)map.get(structureDefinition.getName());
        if (hashMap == null) {
            hashMap = new HashMap<Key, Object>(4);
            map.put(structureDefinition.getName(), hashMap);
        }
        if (key.hasValues()) {
            hashMap.remove(new Key(structureDefinition.getName(), (Map)object));
        }
        hashMap.put(key, object);
    }

    private Map readMap(StructureDefinition structureDefinition, PreparedStatement preparedStatement, Key key) {
        HashMap<String, Object> hashMap = null;
        ResultSet resultSet = null;
        try {
            block7: {
                try {
                    ArrayList arrayList = key.getKeyValues();
                    if (arrayList == null) {
                        throw new RuntimeException("Primary key is not specified for map:  " + structureDefinition.getName());
                    }
                    int n = 0;
                    while (n < arrayList.size()) {
                        preparedStatement.setObject(n + 1, arrayList.get(n));
                        ++n;
                    }
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block7;
                    hashMap = new HashMap<String, Object>();
                    Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
                    int n2 = 1;
                    while (iterator.hasNext()) {
                        AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
                        hashMap.put(attributeDefinition.getName(), resultSet.getObject(n2));
                        ++n2;
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
            Object var13_11 = null;
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this.closeResultSet(resultSet);
            throw throwable;
        }
        return hashMap;
    }

    protected void writeMaps(String string, ArrayList arrayList, boolean bl) {
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = TransactionManager.class$("oracle.binding.meta.StructureDefinition");
        }
        StructureDefinition structureDefinition = (StructureDefinition)this.mDataControl.getDefinition(string, clazz);
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        try {
            try {
                ArrayList arrayList2 = structureDefinition == null ? this.getAttributeNames((Map)arrayList.get(0)) : this.getAttributeNames(structureDefinition);
                Map map = null;
                int n = 0;
                while (n < arrayList.size()) {
                    map = (Map)arrayList.get(n);
                    Key key = null;
                    Map map2 = null;
                    if (bl && structureDefinition != null) {
                        key = new Key(structureDefinition, map);
                        if (preparedStatement3 == null) {
                            preparedStatement3 = this.mConnection.prepareStatement(this.buildReadSQL(structureDefinition));
                        }
                        map2 = this.readMap(structureDefinition, preparedStatement3, key);
                    }
                    if (map2 == null) {
                        if (preparedStatement == null) {
                            String string2 = structureDefinition == null ? this.buildInsertDML(string, arrayList2) : this.buildInsertDML(structureDefinition.getName(), arrayList2);
                            preparedStatement = this.mConnection.prepareStatement(string2);
                        }
                        Iterator iterator = arrayList2.iterator();
                        int n2 = 1;
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            Object v = map.get(string3);
                            preparedStatement.setObject(n2, v);
                            ++n2;
                        }
                        preparedStatement.executeUpdate();
                    } else {
                        if (preparedStatement2 == null) {
                            preparedStatement2 = this.mConnection.prepareStatement(this.buildUpdateDML(structureDefinition));
                        }
                        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
                        int n3 = 1;
                        int n4 = 1 + arrayList2.size();
                        while (iterator.hasNext()) {
                            AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
                            Object v = map.get(attributeDefinition.getName());
                            preparedStatement2.setObject(n3, v);
                            ++n3;
                            if (!attributeDefinition.isKey()) continue;
                            if (v == null) {
                                throw new RuntimeException("Cannot define null key value for type[attr]:  " + structureDefinition.getName() + "[" + attributeDefinition.getName() + "]");
                            }
                            preparedStatement2.setObject(n4, v);
                            ++n4;
                        }
                        preparedStatement2.executeUpdate();
                    }
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
            Object var25_23 = null;
            this.closeStatement(preparedStatement);
            this.closeStatement(preparedStatement2);
            this.closeStatement(preparedStatement3);
        }
        catch (Throwable throwable) {
            Object var25_24 = null;
            this.closeStatement(preparedStatement);
            this.closeStatement(preparedStatement2);
            this.closeStatement(preparedStatement3);
            throw throwable;
        }
    }

    private void removeMaps(String string, ArrayList arrayList) {
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = TransactionManager.class$("oracle.binding.meta.StructureDefinition");
        }
        StructureDefinition structureDefinition = (StructureDefinition)this.mDataControl.getDefinition(string, clazz);
        PreparedStatement preparedStatement = null;
        try {
            try {
                Map map = null;
                int n = 0;
                while (n < arrayList.size()) {
                    map = (Map)arrayList.get(n);
                    if (preparedStatement == null) {
                        preparedStatement = this.mConnection.prepareStatement(this.buildDeleteDML(structureDefinition));
                    }
                    Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
                    int n2 = 1;
                    while (iterator.hasNext()) {
                        AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
                        if (!attributeDefinition.isKey()) continue;
                        Object v = map.get(attributeDefinition.getName());
                        if (v == null) {
                            throw new RuntimeException("Cannot define null key value for type[attr]:  " + structureDefinition.getName() + "[" + attributeDefinition.getName() + "]");
                        }
                        preparedStatement.setObject(n2, v);
                        ++n2;
                    }
                    preparedStatement.executeUpdate();
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
            Object var13_11 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private String buildInsertDML(String string, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer("insert into ");
        stringBuffer.append(string);
        stringBuffer.append('(');
        StringBuffer stringBuffer2 = new StringBuffer(" values (");
        Iterator iterator = arrayList.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (n > 1) {
                stringBuffer.append(',');
                stringBuffer2.append(',');
            }
            stringBuffer.append(string2);
            stringBuffer2.append(':');
            stringBuffer2.append(n);
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer2.append(')');
        stringBuffer.append(stringBuffer2);
        String string3 = stringBuffer.toString();
        System.out.println("Built insertDML:  " + string3);
        return string3;
    }

    private String buildUpdateDML(StructureDefinition structureDefinition) {
        StringBuffer stringBuffer = new StringBuffer("update ");
        stringBuffer.append(structureDefinition.getName());
        stringBuffer.append(" set ");
        StringBuffer stringBuffer2 = new StringBuffer(" where ");
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        int n = this.getAttributeCount(structureDefinition);
        int n2 = 1;
        int n3 = n + 1;
        while (iterator.hasNext()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
            if (n2 > 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(attributeDefinition.getName());
            stringBuffer.append("= :");
            stringBuffer.append(n2);
            ++n2;
            if (!attributeDefinition.isKey()) continue;
            if (n3 > n + 1) {
                stringBuffer2.append(" and ");
            }
            stringBuffer2.append(attributeDefinition.getName());
            stringBuffer2.append("= :");
            stringBuffer2.append(n3);
            ++n3;
        }
        stringBuffer.append(' ');
        stringBuffer.append(stringBuffer2);
        String string = stringBuffer.toString();
        System.out.println("Built updateDML:  " + string);
        return string;
    }

    private String buildReadSQL(StructureDefinition structureDefinition) {
        StringBuffer stringBuffer = this.mDataControl.buildSelectSQL(structureDefinition);
        StringBuffer stringBuffer2 = new StringBuffer(" where ");
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
            stringBuffer.append(attributeDefinition.getName());
            if (!attributeDefinition.isKey()) continue;
            if (n > 1) {
                stringBuffer2.append(" and ");
            }
            stringBuffer2.append(attributeDefinition.getName());
            stringBuffer2.append("= :");
            stringBuffer2.append(n);
            ++n;
        }
        stringBuffer.append(stringBuffer2);
        String string = stringBuffer.toString();
        System.out.println("Built readSQL:  " + string);
        return string;
    }

    private String buildDeleteDML(StructureDefinition structureDefinition) {
        StringBuffer stringBuffer = new StringBuffer("delete from ");
        stringBuffer.append(structureDefinition.getName());
        stringBuffer.append(" where ");
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
            if (!attributeDefinition.isKey()) continue;
            if (n > 1) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(attributeDefinition.getName());
            stringBuffer.append("= :");
            stringBuffer.append(n);
            ++n;
        }
        String string = stringBuffer.toString();
        System.out.println("Built deleteDML:  " + string);
        return string;
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ArrayList getAttributeNames(Map map) {
        ArrayList arrayList = new ArrayList(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private ArrayList getAttributeNames(StructureDefinition structureDefinition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((AttributeDefinition)iterator.next()).getName());
        }
        return arrayList;
    }

    private int getAttributeCount(StructureDefinition structureDefinition) {
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

