/*
 * Decompiled with CFR 0.152.
 */
package model.datacontrol.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import model.datacontrol.jdbc.AccessorDefinitionImpl;
import model.datacontrol.jdbc.AttributeDefinitionImpl;
import model.datacontrol.jdbc.DefinitionBuilder;
import model.datacontrol.jdbc.DefinitionContextImpl;
import model.datacontrol.jdbc.StructureDefinitionImpl;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;

public class OracleDefinitionBuilderImpl
implements DefinitionBuilder {
    OracleDefinitionBuilderImpl() {
    }

    public StructureDefinition buildStructureDefinition(String string, Connection connection) {
        if (!OracleDefinitionBuilderImpl.typeExists(string, connection)) {
            return null;
        }
        StructureDefinitionImpl structureDefinitionImpl = new StructureDefinitionImpl(string.toLowerCase());
        OracleDefinitionBuilderImpl.buildAttributeDefs(structureDefinitionImpl, connection);
        this.resolveStructureDefinition(structureDefinitionImpl, connection);
        return structureDefinitionImpl;
    }

    public void resolveStructureDefinition(StructureDefinition structureDefinition, Connection connection) {
        if (((StructureDefinitionImpl)structureDefinition).isResolved()) {
            return;
        }
        ((StructureDefinitionImpl)structureDefinition).setResolved(true);
        OracleDefinitionBuilderImpl.buildAccessorDefs(structureDefinition, connection);
    }

    private static void buildAttributeDefs(StructureDefinition structureDefinition, Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                HashMap hashMap = new HashMap(4);
                StringBuffer stringBuffer = new StringBuffer("select b.column_name from user_constraints a, user_cons_columns b where a.constraint_name = b.constraint_name and a.table_name = b.table_name and a.constraint_type = 'P' and a.table_name = :1");
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                preparedStatement.setString(1, structureDefinition.getName().toUpperCase());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString(1).toLowerCase(), null);
                }
                OracleDefinitionBuilderImpl.closeResultSet(resultSet);
                OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
                stringBuffer = new StringBuffer("select * from ");
                stringBuffer.append(structureDefinition.getName());
                stringBuffer.append(" where 0=1");
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                int n2 = 0;
                while (n2 < n) {
                    String string = resultSetMetaData.getColumnName(n2 + 1).toLowerCase();
                    AttributeDefinitionImpl attributeDefinitionImpl = new AttributeDefinitionImpl(string, structureDefinition, resultSetMetaData.getColumnClassName(n2 + 1), false, hashMap.containsKey(string));
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            OracleDefinitionBuilderImpl.closeResultSet(resultSet);
            OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
            throw throwable;
        }
        OracleDefinitionBuilderImpl.closeResultSet(resultSet);
        OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
    }

    private static void buildAccessorDefs(StructureDefinition structureDefinition, Connection connection) {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            block8: {
                try {
                    String string = structureDefinition.getName().toUpperCase();
                    preparedStatement = connection.prepareStatement("select referant.table_name, referant.constraint_name, referant_columns.column_name from user_constraints referee, user_constraints referant, user_cons_columns referant_columns where referee.constraint_name = referant.r_constraint_name  and referant.constraint_name = referant_columns.constraint_name and referant.table_name = referant_columns.table_name and referant.constraint_type = 'R' and referee.table_name = :1 order by referant.table_name, referant.constraint_name");
                    preparedStatement2 = connection.prepareStatement("select referee_columns.column_name from user_constraints referee, user_constraints referant, user_cons_columns referee_columns where referee.constraint_name = referant.r_constraint_name  and referee.constraint_name = referee_columns.constraint_name and referee.table_name = referee_columns.table_name and referant.constraint_type = 'R' and referee.table_name = :1 order by referant.table_name, referant.constraint_name");
                    preparedStatement.setString(1, string);
                    preparedStatement2.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    resultSet2 = preparedStatement2.executeQuery();
                    String string2 = null;
                    NamedDefinition namedDefinition = null;
                    ArrayList<Definition> arrayList = null;
                    ArrayList<Definition> arrayList2 = null;
                    DefinitionContextImpl definitionContextImpl = DefinitionContextImpl.getInstance();
                    while (resultSet.next()) {
                        resultSet2.next();
                        if (string2 == null || !string2.equals(resultSet.getString(2))) {
                            if (arrayList != null) {
                                new AccessorDefinitionImpl(string2, structureDefinition, null, false, (StructureDefinition)namedDefinition, arrayList2, arrayList);
                            }
                            if (namedDefinition == null || !namedDefinition.getName().equals(resultSet.getString(1).toLowerCase())) {
                                namedDefinition = definitionContextImpl.findOrCreateStructureDefinition(resultSet.getString(1), connection);
                                ((StructureDefinitionImpl)namedDefinition).setParent(structureDefinition);
                            }
                            string2 = resultSet.getString(2).toLowerCase();
                            arrayList = new ArrayList<Definition>();
                            arrayList2 = new ArrayList<Definition>();
                        }
                        String string3 = resultSet.getString(3).toLowerCase();
                        arrayList.add(namedDefinition.getAttributeDefinitions().find(string3));
                        String string4 = resultSet2.getString(1).toLowerCase();
                        arrayList2.add(structureDefinition.getAttributeDefinitions().find(string4));
                    }
                    if (arrayList == null) break block8;
                    new AccessorDefinitionImpl(string2, structureDefinition, null, false, (StructureDefinition)namedDefinition, arrayList2, arrayList);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
            Object var16_14 = null;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            OracleDefinitionBuilderImpl.closeResultSet(resultSet);
            OracleDefinitionBuilderImpl.closeResultSet(resultSet2);
            OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
            OracleDefinitionBuilderImpl.closeStatement(preparedStatement2);
            throw throwable;
        }
        OracleDefinitionBuilderImpl.closeResultSet(resultSet);
        OracleDefinitionBuilderImpl.closeResultSet(resultSet2);
        OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
        OracleDefinitionBuilderImpl.closeStatement(preparedStatement2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean typeExists(String string, Connection connection) {
        boolean bl;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            boolean bl2;
            block6: {
                if (connection == null) {
                    return false;
                }
                preparedStatement = null;
                resultSet = null;
                try {
                    try {
                        StringBuffer stringBuffer = new StringBuffer("select count(1) from ");
                        stringBuffer.append(string);
                        preparedStatement = connection.prepareStatement(stringBuffer.toString());
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next() && resultSet.getInt(1) >= 0) {
                            bl2 = true;
                            Object var10_6 = null;
                            break block6;
                        }
                        bl = false;
                        break block7;
                    }
                    catch (SQLException sQLException) {
                        boolean bl3 = false;
                        Object var10_8 = null;
                        OracleDefinitionBuilderImpl.closeResultSet(resultSet);
                        OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    OracleDefinitionBuilderImpl.closeResultSet(resultSet);
                    OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            OracleDefinitionBuilderImpl.closeResultSet(resultSet);
            OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
            return bl2;
        }
        Object var10_7 = null;
        OracleDefinitionBuilderImpl.closeResultSet(resultSet);
        OracleDefinitionBuilderImpl.closeStatement(preparedStatement);
        return bl;
    }

    private static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

