/*
 * Decompiled with CFR 0.152.
 */
package model.datacontrol.javabeans.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import model.datacontrol.javabeans.SampleDataControlUtil;
import model.datacontrol.javabeans.xml.XMLList;
import model.datacontrol.javabeans.xml.XMLRow;
import oracle.binding.AttributeContext;
import oracle.binding.OperationBinding;
import oracle.binding.OperationInfo;
import oracle.binding.RowContext;
import oracle.binding.TransactionalDataControl;
import oracle.binding.UpdateableDataControl;

public class XMLDataControl
implements UpdateableDataControl,
TransactionalDataControl {
    public static final String XML_FILE = "XML_FILE";
    public static final String SUPER_TYPE = "MASTER_TYPE";
    private static final String PROPERTY_FILE_NAME = "xmldc.properties";
    private String mXmlFileString;
    private String mTypeString;
    private String mDestinationPackage;
    private XMLList mMasterList;
    private JAXBContext mContext;
    private boolean mTransactionDirty;

    private /* synthetic */ void $init$() {
        this.mXmlFileString = null;
        this.mTypeString = null;
        this.mDestinationPackage = "com.example.generated";
        this.mMasterList = null;
        this.mContext = null;
    }

    public XMLDataControl() throws Exception {
        this.$init$();
        Properties properties = new Properties();
        File file = new File(PROPERTY_FILE_NAME);
        System.out.println("XMLDataControl reading config properties from file: " + file.getAbsolutePath());
        properties.load(new FileInputStream(file));
        this.mXmlFileString = (String)properties.get(XML_FILE);
        this.mTypeString = (String)properties.get(SUPER_TYPE);
        System.out.println("XMLDataControl parameters:");
        System.out.println("  XML data file name: " + this.mXmlFileString);
        System.out.println("  Master data type:" + this.mTypeString);
    }

    private XMLList loadData() {
        File file = new File(this.mXmlFileString);
        try {
            if (this.mContext == null) {
                this.mContext = JAXBContext.newInstance((String)this.mDestinationPackage);
                System.out.println("JAX-B Context initialized");
            }
            XMLList xMLList = new XMLList();
            xMLList.initialize(this.mContext, file, this.mTypeString);
            XMLList xMLList2 = xMLList;
            return xMLList2;
        }
        catch (Exception exception) {
            System.out.println("XMLDataControl: Failed to load data from file: " + file.getAbsolutePath());
            exception.printStackTrace();
            return null;
        }
    }

    public void rollbackTransaction() {
        this.mMasterList = null;
        this.mTransactionDirty = false;
    }

    public void commitTransaction() {
        try {
            System.out.println("calling commit");
            Object object = this.mMasterList.getBaseObject();
            Marshaller marshaller = this.mContext.createMarshaller();
            File file = new File(this.mXmlFileString);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            marshaller.marshal(object, (OutputStream)fileOutputStream);
            this.mTransactionDirty = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public boolean setAttributeValue(AttributeContext attributeContext, Object object) {
        return false;
    }

    public boolean removeRowData(RowContext rowContext) {
        XMLRow xMLRow = (XMLRow)rowContext.getRowDataProvider();
        String string = rowContext.getRowDataProviderType();
        Object object = rowContext.getMasterRowDataProvider();
        try {
            if (object == null) {
                this.mMasterList.remove(xMLRow);
            } else {
                int n = string.indexOf("Impl");
                int n2 = string.lastIndexOf(".");
                String string2 = string.substring(n2 + 1, n);
                XMLList xMLList = (XMLList)((XMLRow)object).get(string2 + "List");
                xMLList.remove(xMLRow);
            }
            this.mTransactionDirty = true;
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error while trying to remove row");
        }
    }

    public Object createRowData(RowContext rowContext) {
        Object object = rowContext.getMasterRowDataProvider();
        String string = rowContext.getRowDataProviderType();
        XMLRow xMLRow = null;
        int n = string.indexOf("Impl");
        int n2 = string.lastIndexOf(".");
        String string2 = string.substring(n2 + 1, n);
        if (object == null) {
            xMLRow = this.mMasterList.createRow(string2, this.mDestinationPackage);
        } else {
            XMLList xMLList = (XMLList)((XMLRow)object).get(string2 + "List");
            xMLRow = xMLList.createRow(string2, this.mDestinationPackage);
            if ("Emp".equals(string2)) {
                System.out.println("defaulting values for emp!");
                xMLRow.put("Ename", "Clemens");
                xMLRow.put("Id", new BigInteger("2222"));
                xMLRow.put("Job", "CTO");
            }
        }
        this.mTransactionDirty = true;
        return xMLRow;
    }

    public boolean isTransactionDirty() {
        return this.mTransactionDirty;
    }

    public Object registerDataProvider(RowContext rowContext) {
        Object object = rowContext.getRowDataProvider();
        this.mTransactionDirty = true;
        return object;
    }

    public void validate() {
    }

    public String getName() {
        return "XMLDataControl";
    }

    public void release(int n) {
        this.mMasterList = null;
        this.mTransactionDirty = false;
    }

    public Object getDataProvider() {
        if (this.mMasterList == null) {
            this.mMasterList = new XMLList();
        }
        return this.mMasterList;
    }

    public boolean invokeOperation(Map map, OperationBinding operationBinding) {
        String string;
        OperationInfo operationInfo = operationBinding.getOperationInfo();
        if (operationInfo != null && (string = operationInfo.getOperationName()) != null && string.startsWith("load")) {
            String string2 = string.substring(4);
            if (this.mTypeString.equalsIgnoreCase(string2)) {
                if (this.mMasterList == null) {
                    this.mMasterList = this.loadData();
                }
                SampleDataControlUtil.putValueInPath(map, operationInfo.getReturnName(), this.mMasterList);
                return true;
            }
            System.out.println("Requesting a different type '" + string2 + "' from the type that this XMLDataControl is configured as: '" + this.mTypeString + "'");
        }
        return false;
    }
}

