/*
 * Decompiled with CFR 0.152.
 */
package model.datacontrol.javabeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import model.datacontrol.javabeans.SampleDataControlBeanInterface;
import model.datacontrol.javabeans.SampleDataControlUtil;
import model.datacontrol.javabeans.hrservice.SDeptBean;
import model.datacontrol.javabeans.hrservice.SEmpBean;
import model.datacontrol.javabeans.hrservice.SInvBean;
import oracle.binding.AttributeContext;
import oracle.binding.OperationBinding;
import oracle.binding.OperationInfo;
import oracle.binding.RowContext;
import oracle.binding.TransactionalDataControl;
import oracle.binding.UpdateableDataControl;

public class SampleDataControl
implements TransactionalDataControl,
UpdateableDataControl {
    boolean mTransactionDirty;
    Collection mData;
    String mDataType;

    public SampleDataControl() {
        this.initDept();
    }

    private void initDept() {
        File file = new File("Dept.out");
        if (file.exists()) {
            return;
        }
        ArrayList<SEmpBean> arrayList = new ArrayList<SEmpBean>();
        arrayList.add(new SEmpBean(101, "A Emp", "Pres", 1));
        arrayList.add(new SEmpBean(102, "B Emp", "Mgr", 1));
        arrayList.add(new SEmpBean(103, "C Emp", "PM", 1));
        ArrayList<SEmpBean> arrayList2 = new ArrayList<SEmpBean>();
        arrayList2.add(new SEmpBean(104, "A A", "Dev", 2));
        arrayList2.add(new SEmpBean(105, "B B", "Dev", 2));
        arrayList2.add(new SEmpBean(106, "C C", "Dev", 2));
        ArrayList<SEmpBean> arrayList3 = new ArrayList<SEmpBean>();
        arrayList3.add(new SEmpBean(107, "C C", "QA", 3));
        ArrayList<SInvBean> arrayList4 = new ArrayList<SInvBean>();
        arrayList4.add(new SInvBean(1, "PC", "1-Jan-2004"));
        ArrayList<SInvBean> arrayList5 = new ArrayList<SInvBean>();
        arrayList5.add(new SInvBean(2, "Notebook", "11-Dec-2003"));
        arrayList5.add(new SInvBean(3, "Projector", "15-Feb-2001"));
        ArrayList<SInvBean> arrayList6 = new ArrayList<SInvBean>();
        arrayList6.add(new SInvBean(4, "PC", "22-Jul-2002"));
        arrayList6.add(new SInvBean(5, "Whiteboard", "19-Aug-1998"));
        arrayList6.add(new SInvBean(6, "Notebook", "5-Mar-2004"));
        ArrayList<SDeptBean> arrayList7 = new ArrayList<SDeptBean>();
        arrayList7.add(new SDeptBean(1, "department one", "Palo Alto", "", arrayList, arrayList4));
        arrayList7.add(new SDeptBean(2, "department two", "San Francisco", null, arrayList2, arrayList5));
        arrayList7.add(new SDeptBean(3, "department three", "San Jose", "x", arrayList3, arrayList6));
        this.writeObject("Dept", arrayList7);
        System.out.println("SampleDataControl created a data file Dept.out in " + file.getAbsolutePath());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeObject(String string, Collection collection) {
        File file = null;
        OutputStream outputStream = null;
        file = new File(string + ".out");
        outputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(collection);
        Object var9_6 = null;
        if (outputStream == null) return;
        try {
            outputStream.flush();
            ((FileOutputStream)outputStream).close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                System.out.println("Unable to write data file for " + string + ".");
                if (file != null) {
                    System.out.println("Path is '" + file.getAbsolutePath() + "'");
                }
                exception.printStackTrace();
                Object var9_7 = null;
                if (outputStream == null) return;
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Object getDataProvider() {
        return this.mData;
    }

    public String getName() {
        return "SampleDataControl";
    }

    public boolean invokeOperation(Map map, OperationBinding operationBinding) {
        String string;
        OperationInfo operationInfo = operationBinding.getOperationInfo();
        if (operationInfo != null && (string = operationInfo.getOperationName()) != null && string.startsWith("load")) {
            this.mDataType = string.substring(4);
            if (this.mData == null) {
                this.mData = this.loadData(this.mDataType);
            }
            SampleDataControlUtil.putValueInPath(map, operationInfo.getReturnName(), this.mData);
            return true;
        }
        return false;
    }

    public void release(int n) {
        this.mDataType = null;
        this.mData = null;
    }

    private Collection loadData(String string) {
        File file = new File(string + ".out");
        Collection collection = null;
        if (file.exists()) {
            System.out.println("Loading data from " + file.getAbsolutePath());
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                try {
                    collection = (Collection)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return collection;
    }

    public void commitTransaction() {
        if (this.mTransactionDirty) {
            this.writeObject(this.mDataType, this.mData);
        }
        this.mTransactionDirty = false;
    }

    public boolean setAttributeValue(AttributeContext attributeContext, Object object) {
        return false;
    }

    public Object createRowData(RowContext rowContext) {
        Object e = null;
        try {
            String string = rowContext.getRowDataProviderType();
            Class<?> clazz = Class.forName(string);
            e = clazz.newInstance();
            Object object = rowContext.getMasterRowDataProvider();
            if (object == null) {
                this.mData.add(e);
            } else {
                SampleDataControlBeanInterface sampleDataControlBeanInterface = (SampleDataControlBeanInterface)object;
                SampleDataControlBeanInterface sampleDataControlBeanInterface2 = (SampleDataControlBeanInterface)e;
                sampleDataControlBeanInterface.addDetail(sampleDataControlBeanInterface2);
                sampleDataControlBeanInterface2.setMaster(sampleDataControlBeanInterface);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mTransactionDirty = true;
        return e;
    }

    public boolean isTransactionDirty() {
        return this.mTransactionDirty;
    }

    public Object registerDataProvider(RowContext rowContext) {
        Object object = rowContext.getRowDataProvider();
        this.mTransactionDirty = true;
        return object;
    }

    public boolean removeRowData(RowContext rowContext) {
        Object object = rowContext.getRowDataProvider();
        Object object2 = rowContext.getMasterRowDataProvider();
        if (object2 == null) {
            if (this.mData.remove(object)) {
                this.mTransactionDirty = true;
            }
        } else {
            SampleDataControlBeanInterface sampleDataControlBeanInterface = (SampleDataControlBeanInterface)object2;
            if (sampleDataControlBeanInterface.removeDetail((SampleDataControlBeanInterface)object)) {
                this.mTransactionDirty = true;
            }
        }
        return false;
    }

    public void rollbackTransaction() {
        this.mData = null;
        this.mTransactionDirty = false;
    }

    public void validate() {
    }
}

