/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jmapps.ui.JMPanel;
import jmapps.ui.TreeNode;

public class TreeControl
extends JMPanel
implements ComponentListener,
MouseListener,
KeyListener,
FocusListener,
ActionListener,
AdjustmentListener {
    private TreeNode nodeRoot = null;
    private TreeNode nodeTop = null;
    private TreeNode nodeCurrent = null;
    private Vector vectorTreeElList = new Vector();
    private boolean boolLayoutDone = false;
    private boolean boolRootVisible = true;
    private Scrollbar scrollBarVert = null;
    private Scrollbar scrollBarHorz = null;
    private int nScrollVertVisible;
    private int nScrollHorzMax;
    private int nScrollHorzVisible;
    private int nScrollHorzLeft = 0;
    private int nScrollHorzCell = 6;
    private Image imageDraw = null;

    public TreeControl() {
        this((String)null);
    }

    public TreeControl(String string) {
        super(null);
        this.setLoweredBorder();
        this.setBackground(TreeNode.colorBg);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        if (string != null) {
            this.createRootElement(string);
        }
    }

    public boolean SetElementImage(TreeNode treeNode, Image image) {
        boolean bl = this.nodeRoot.isRecursiveSubElement(treeNode);
        if (!bl) {
            return false;
        }
        treeNode.setImage(image);
        if (!this.vectorTreeElList.contains(treeNode)) {
            return true;
        }
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null || !(object instanceof TreeNode)) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("Node Added")) {
            this.recomputeTreeElList();
            if (this.vectorTreeElList.contains(object)) {
                this.recomputeLayout();
                this.recomputeScrollbars();
            }
            this.repaint();
        } else if (string.equals("Node Removed")) {
            if (this.vectorTreeElList.contains(object)) {
                this.recomputeTreeElList();
                this.recomputeLayout();
                this.recomputeScrollbars();
            }
            this.repaint();
        } else if (string.equals("Node Expanded")) {
            this.recomputeTreeElList();
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        } else if (string.equals("Node Collapsed")) {
            this.recomputeTreeElList();
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        } else if (string.equals("Node Set Current")) {
            this.nodeCurrent = (TreeNode)object;
            this.scrollCurrentIntoView();
            this.repaint();
        } else {
            string.equals("Node Reset Current");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addScrollbarVert();
        this.addScrollbarHorz();
    }

    public void addScrollbarHorz() {
        this.scrollBarHorz = new Scrollbar(0);
        this.scrollBarHorz.addAdjustmentListener(this);
        this.scrollBarHorz.setUnitIncrement(1);
        this.add(this.scrollBarHorz);
    }

    public void addScrollbarVert() {
        this.scrollBarVert = new Scrollbar(1);
        this.scrollBarVert.addAdjustmentListener(this);
        this.scrollBarVert.setUnitIncrement(1);
        this.add(this.scrollBarVert);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        if (adjustable == null || !(adjustable instanceof Scrollbar)) {
            return;
        }
        int n2 = adjustmentEvent.getAdjustmentType();
        int n3 = adjustmentEvent.getValue();
        if (n3 != adjustable.getValue()) {
            adjustable.setValue(n3);
        }
        if (((Scrollbar)adjustable).getOrientation() == 1) {
            int n4 = this.vectorTreeElList.indexOf(this.nodeTop);
            if (n4 != n3) {
                n4 = n3;
                this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(n4);
                this.recomputeScrollbars();
                this.repaint();
            }
        } else if (this.nScrollHorzLeft != n3) {
            this.nScrollHorzLeft = n3;
            this.repaint();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.recomputeLayout();
        this.recomputeScrollbars();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public TreeNode createRootElement(String string) {
        this.nodeRoot = new TreeNode(string, this);
        this.nodeRoot.addActionListener(this);
        this.vectorTreeElList = new Vector();
        this.nodeRoot.addToTreeElList(this.vectorTreeElList);
        this.nodeTop = this.nodeRoot;
        this.nodeRoot.setCurrent(true);
        return this.nodeRoot;
    }

    public TreeNode createSubElement(TreeNode treeNode, String string) {
        TreeNode treeNode2 = treeNode.addSubElement(string);
        treeNode2.addActionListener(this);
        if (this.isShowing()) {
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        }
        return treeNode2;
    }

    public void destroySubElement(TreeNode treeNode, TreeNode treeNode2) {
        TreeNode treeNode3 = this.getCurrentElement();
        if (treeNode3 != null && treeNode2.isRecursiveSubElement(treeNode3)) {
            treeNode.setCurrent(true);
        }
        treeNode.destroySubElement(treeNode2);
        if (this.isShowing()) {
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        }
    }

    public TreeNode findElement(String string) {
        TreeNode treeNode = this.nodeRoot.findElement(string);
        return treeNode;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public Rectangle getClientArea() {
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle2.x = insets.left;
        rectangle2.y = insets.top;
        rectangle2.width -= insets.left + insets.right;
        rectangle2.height -= insets.top + insets.bottom;
        if (this.scrollBarVert != null && this.scrollBarVert.isVisible()) {
            rectangle = this.scrollBarVert.getBounds();
            rectangle2.width -= rectangle.width;
        }
        if (this.scrollBarHorz != null && this.scrollBarHorz.isVisible()) {
            rectangle = this.scrollBarHorz.getBounds();
            rectangle2.height -= rectangle.height;
        }
        if (rectangle2.width < 0) {
            rectangle2.width = 0;
        }
        if (rectangle2.height < 0) {
            rectangle2.height = 0;
        }
        return rectangle2;
    }

    public TreeNode getCurrentElement() {
        return this.nodeRoot.getCurrent();
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = this.nodeRoot.getNodeBoundsFull();
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        return dimension;
    }

    public TreeNode getRootElement() {
        return this.nodeRoot;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isRootVisible() {
        return this.boolRootVisible;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2;
        char c2 = keyEvent.getKeyChar();
        int n3 = keyEvent.getKeyCode();
        int n4 = keyEvent.getModifiers();
        if (n3 == 107) {
            this.nodeCurrent.setExpanded(true);
            return;
        }
        if (n3 == 109) {
            this.nodeCurrent.setExpanded(false);
            return;
        }
        int n5 = n2 = this.vectorTreeElList.indexOf(this.nodeCurrent);
        if (n3 == 40) {
            ++n5;
        } else if (n3 == 34) {
            n5 += this.nScrollVertVisible;
        } else if (n3 == 38) {
            --n5;
        } else if (n3 == 33) {
            n5 -= this.nScrollVertVisible;
        } else if (n3 == 35) {
            n5 = this.vectorTreeElList.size() - 1;
        } else if (n3 == 36) {
            n5 = 0;
        }
        if (n5 > this.vectorTreeElList.size() - 1) {
            n5 = this.vectorTreeElList.size() - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 != n2) {
            this.nodeCurrent = (TreeNode)this.vectorTreeElList.elementAt(n5);
            this.nodeCurrent.setCurrent(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
        if (mouseEvent.getClickCount() % 2 == 1) {
            return;
        }
        Rectangle rectangle = this.nodeTop.getNodeBounds();
        Point point = new Point(mouseEvent.getPoint());
        point.y += rectangle.y;
        point.x += this.nScrollHorzLeft * this.nScrollHorzCell;
        this.nodeRoot.onMouseDoubleclick(point);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = this.nodeTop.getNodeBounds();
        Point point = new Point(mouseEvent.getPoint());
        point.y += rectangle.y;
        point.x += this.nScrollHorzLeft * this.nScrollHorzCell;
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 0x10) == 16) {
            this.nodeRoot.onMousePressedLeft(point, mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown());
        } else if ((n2 & 4) == 4) {
            this.nodeRoot.onMousePressedRight(point, mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        Dimension dimension = this.getSize();
        if (this.imageDraw == null || this.imageDraw.getWidth(this) < dimension.width || this.imageDraw.getHeight(this) < dimension.height) {
            this.imageDraw = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = this.imageDraw.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        if (!this.boolLayoutDone) {
            this.recomputeLayout(graphics2);
            this.recomputeScrollbars();
        }
        Rectangle rectangle2 = this.getClientArea();
        graphics2.setFont(this.getFont());
        int n2 = this.vectorTreeElList.size();
        int n3 = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectangle3 = this.nodeTop.getNodeBounds();
        if (!this.boolRootVisible) {
            rectangle = this.nodeRoot.getNodeBounds();
            Rectangle rectangle4 = this.nodeRoot.getSubElement(0).getNodeBounds();
            Rectangle rectangle5 = this.nodeRoot.getSubElement(this.nodeRoot.size() - 1).getNodeBounds();
            int n4 = rectangle4.x - this.nScrollHorzLeft * this.nScrollHorzCell + 6 + 4;
            int n5 = rectangle4.y + rectangle4.height / 2 - rectangle3.y;
            int n6 = rectangle5.y + rectangle5.height / 2 - rectangle3.y;
            this.nodeRoot.drawDottedLine(graphics2, n4, n5, n4, n6);
        }
        int n7 = 0;
        while (n7 < n2) {
            TreeNode treeNode = (TreeNode)this.vectorTreeElList.elementAt(n7);
            treeNode.drawElement(graphics2, this.nScrollHorzLeft * this.nScrollHorzCell, rectangle3.y);
            rectangle = treeNode.getNodeBounds();
            if (rectangle.y + rectangle.height >= rectangle3.y + rectangle2.height) break;
            ++n7;
        }
        super.paint(graphics2);
        graphics.drawImage(this.imageDraw, 0, 0, this);
    }

    private void positionScrollbars() {
        Dimension dimension;
        Dimension dimension2;
        Rectangle rectangle = this.getBounds();
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = rectangle.width - insets.left - insets.right;
        rectangle.height = rectangle.height - insets.top - insets.bottom;
        if (this.scrollBarVert != null && this.scrollBarVert.isVisible()) {
            dimension2 = this.scrollBarVert.getPreferredSize();
            dimension2.width += 2;
        } else {
            dimension2 = new Dimension(0, 0);
        }
        if (this.scrollBarHorz != null && this.scrollBarHorz.isVisible()) {
            dimension = this.scrollBarHorz.getPreferredSize();
            dimension.height += 2;
        } else {
            dimension = new Dimension(0, 0);
        }
        if (this.scrollBarVert != null) {
            this.scrollBarVert.setBounds(rectangle.x + rectangle.width - dimension2.width, rectangle.y, dimension2.width, rectangle.height - dimension.height);
        }
        if (this.scrollBarHorz != null) {
            this.scrollBarHorz.setBounds(rectangle.x, rectangle.y + rectangle.height - dimension.height, rectangle.width - dimension2.width, dimension.height);
        }
    }

    private void recomputeLayout() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.recomputeLayout(graphics);
        }
    }

    private void recomputeLayout(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        rectangle = this.nodeRoot.recomputeLayout(rectangle, fontMetrics);
        Rectangle rectangle2 = this.getClientArea();
        int n2 = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectangle3 = this.nodeTop.getNodeBounds();
        while (n2 > 0 && rectangle2.height > rectangle.height - (rectangle3.y - rectangle.y)) {
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(--n2);
            rectangle3 = this.nodeTop.getNodeBounds();
        }
        this.boolLayoutDone = true;
    }

    private void recomputeScrollbars() {
        Rectangle rectangle;
        if (!this.boolLayoutDone) {
            return;
        }
        int n2 = this.vectorTreeElList.size();
        int n3 = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectangle2 = this.nodeTop.getNodeBounds();
        Rectangle rectangle3 = this.getClientArea();
        int n4 = n3;
        while (n4 < n2) {
            TreeNode treeNode = (TreeNode)this.vectorTreeElList.elementAt(n4);
            rectangle = treeNode.getNodeBounds();
            if (rectangle.y + rectangle.height - rectangle2.y > rectangle3.height) break;
            ++n4;
        }
        this.nScrollVertVisible = n4 - n3;
        this.setScrollbarVertValues(n3, this.nScrollVertVisible, 0, n2);
        rectangle = this.nodeRoot.getNodeBoundsFull();
        this.nScrollHorzMax = (rectangle.width + this.nScrollHorzCell - 1) / this.nScrollHorzCell;
        this.nScrollHorzVisible = rectangle3.width / this.nScrollHorzCell;
        this.setScrollbarHorzValues(this.nScrollHorzLeft, this.nScrollHorzVisible, 0, this.nScrollHorzMax);
        rectangle = this.getClientArea();
        if (!rectangle3.equals(rectangle)) {
            this.recomputeScrollbars();
        }
    }

    private void recomputeTreeElList() {
        boolean bl;
        if (this.nodeRoot == null) {
            return;
        }
        this.vectorTreeElList.removeAllElements();
        this.nodeRoot.addToTreeElList(this.vectorTreeElList);
        while (this.nodeTop != null) {
            bl = this.vectorTreeElList.contains(this.nodeTop);
            if (bl) break;
            this.nodeTop = this.nodeTop.getOwner();
        }
        if (this.nodeTop == null && this.vectorTreeElList.size() > 0) {
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(0);
        }
        if (this.nodeTop == null) {
            this.nodeTop = this.nodeRoot;
        }
        TreeNode treeNode = this.nodeCurrent;
        while (this.nodeCurrent != null) {
            bl = this.vectorTreeElList.contains(this.nodeCurrent);
            if (bl) break;
            this.nodeCurrent = this.nodeCurrent.getOwner();
        }
        if (this.nodeCurrent == null && this.vectorTreeElList.size() > 0) {
            this.nodeCurrent = (TreeNode)this.vectorTreeElList.elementAt(0);
        }
        if (this.nodeCurrent == null) {
            this.nodeCurrent = this.nodeRoot;
        }
        if (treeNode != this.nodeCurrent) {
            if (treeNode != null) {
                treeNode.setCurrent(false);
            }
            if (this.nodeCurrent != null) {
                this.nodeCurrent.setCurrent(true);
            }
        }
    }

    public void removeScrollbarHorz() {
        this.scrollBarHorz.removeAdjustmentListener(this);
        this.remove(this.scrollBarHorz);
        this.scrollBarHorz = null;
    }

    public void removeScrollbarVert() {
        this.scrollBarVert.removeAdjustmentListener(this);
        this.remove(this.scrollBarVert);
        this.scrollBarVert = null;
    }

    private void scrollCurrentIntoView() {
        if (!this.boolLayoutDone) {
            return;
        }
        int n2 = this.vectorTreeElList.size();
        int n3 = this.vectorTreeElList.indexOf(this.nodeCurrent);
        if (n3 < 0) {
            return;
        }
        int n4 = this.vectorTreeElList.indexOf(this.nodeTop);
        int n5 = n4;
        if (n3 >= n5 + this.nScrollVertVisible) {
            Rectangle rectangle = this.getClientArea();
            Rectangle rectangle2 = this.nodeCurrent.getNodeBounds();
            if (n5 < n2 - 1) {
                this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(++n5);
                Rectangle rectangle3 = this.nodeTop.getNodeBounds();
                int cfr_ignored_0 = rectangle2.y;
                int cfr_ignored_1 = rectangle2.height;
                int cfr_ignored_2 = rectangle3.y;
                int cfr_ignored_3 = rectangle.height;
            }
        }
        if (n3 < n5) {
            n5 = n3;
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(n5);
        }
        if (n5 != n4) {
            this.recomputeScrollbars();
        }
    }

    public void setCurrentElement(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (!this.nodeRoot.isRecursiveSubElement(treeNode)) {
            return;
        }
        treeNode.setCurrent(true);
    }

    public boolean setElementImageCur(TreeNode treeNode, Image image) {
        boolean bl = this.nodeRoot.isRecursiveSubElement(treeNode);
        if (!bl) {
            return false;
        }
        treeNode.setImageCur(image);
        if (!this.vectorTreeElList.contains(treeNode)) {
            return true;
        }
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
        return true;
    }

    public void setRootVisible(boolean bl) {
        if (this.boolRootVisible == bl) {
            return;
        }
        this.boolRootVisible = bl;
        this.nodeRoot.setVisible(this.boolRootVisible);
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
    }

    public boolean setScrollbarHorzValues(int n2, int n3, int n4, int n5) {
        if (this.scrollBarHorz == null) {
            return false;
        }
        boolean bl = this.scrollBarHorz.isVisible();
        this.scrollBarHorz.setValues(n2, n3, n4, n5);
        if (n3 - 1 < 1) {
            this.scrollBarHorz.setBlockIncrement(1);
        } else {
            this.scrollBarHorz.setBlockIncrement(n3 - 1);
        }
        boolean bl2 = n5 - n4 > n3;
        this.scrollBarHorz.setVisible(bl2);
        this.positionScrollbars();
        this.scrollBarHorz.setValues(n2, n3, n4, n5);
        if (n3 - 1 < 1) {
            this.scrollBarHorz.setBlockIncrement(1);
        } else {
            this.scrollBarHorz.setBlockIncrement(n3 - 1);
        }
        return bl != bl2;
    }

    public boolean setScrollbarVertValues(int n2, int n3, int n4, int n5) {
        if (this.scrollBarVert == null) {
            return false;
        }
        boolean bl = this.scrollBarVert.isVisible();
        this.scrollBarVert.setValues(n2, n3, n4, n5);
        if (n3 - 1 < 1) {
            this.scrollBarVert.setBlockIncrement(1);
        } else {
            this.scrollBarVert.setBlockIncrement(n3 - 1);
        }
        boolean bl2 = n5 - n4 > n3;
        this.scrollBarVert.setVisible(bl2);
        this.positionScrollbars();
        this.scrollBarVert.setValues(n2, n3, n4, n5);
        if (n3 - 1 < 1) {
            this.scrollBarVert.setBlockIncrement(1);
        } else {
            this.scrollBarVert.setBlockIncrement(n3 - 1);
        }
        return bl != bl2;
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            this.paint(graphics);
        }
    }
}

