/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import com.sun.media.util.Registry;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class SettingsPanel
extends JMPanel
implements ActionListener {
    private Checkbox checkAllowCaching;
    private Checkbox checkAllowFileWrite;
    private Checkbox checkAllowCapture;
    private TextField textMaxCacheSize;
    private TextField textCacheDir;
    private Checkbox checkAllowLogging;
    private TextField textLoggingDir;
    private Button buttonCommit;
    private Button buttonRestore;

    public SettingsPanel() {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "North");
        Panel panel2 = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panel2, "West");
        Panel panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        this.checkAllowFileWrite = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowfilewrite"));
        panel3.add((Component)this.checkAllowFileWrite, "West");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        this.checkAllowCapture = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowcapture"));
        panel3.add((Component)this.checkAllowCapture, "West");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        this.checkAllowCaching = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowcaching"));
        panel3.add((Component)this.checkAllowCaching, "West");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        Label label = new Label(JMFI18N.getResource("jmfregistry.settings.cachedirectory"));
        panel3.add((Component)label, "West");
        this.textCacheDir = new TextField(32);
        panel3.add((Component)this.textCacheDir, "Center");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        label = new Label(JMFI18N.getResource("jmfregistry.settings.maxcache"));
        panel3.add((Component)label, "West");
        this.textMaxCacheSize = new TextField();
        panel3.add((Component)this.textMaxCacheSize, "Center");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        this.checkAllowLogging = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowlogging"));
        panel3.add((Component)this.checkAllowLogging, "West");
        panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add(panel3);
        label = new Label(JMFI18N.getResource("jmfregistry.settings.loggingdirectory"));
        panel3.add((Component)label, "West");
        this.textLoggingDir = new TextField();
        panel3.add((Component)this.textLoggingDir, "Center");
        panel = new Panel(new FlowLayout(1));
        this.add((Component)panel, "South");
        Panel panel4 = new Panel(new GridLayout(1, 0, 12, 12));
        panel.add(panel4);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.settings.commit"));
        this.buttonCommit.addActionListener(this);
        panel4.add(this.buttonCommit);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.settings.restore"));
        this.buttonRestore.addActionListener(this);
        panel4.add(this.buttonRestore);
        this.doRestore();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonCommit) {
            this.doCommit();
        }
        if (object == this.buttonRestore) {
            this.doRestore();
        }
    }

    private void doCommit() {
        boolean bl = this.checkAllowCaching.getState();
        Registry.set("secure.allowCaching", new Boolean(bl));
        boolean bl2 = this.checkAllowFileWrite.getState();
        Registry.set("secure.allowSaveFileFromApplets", new Boolean(bl2));
        boolean bl3 = this.checkAllowCapture.getState();
        Registry.set("secure.allowCaptureFromApplets", new Boolean(bl3));
        Registry.set("secure.cacheDir", this.textCacheDir.getText());
        boolean bl4 = this.checkAllowLogging.getState();
        Registry.set("allowLogging", new Boolean(bl4));
        Registry.set("secure.logDir", this.textLoggingDir.getText());
        try {
            int n2 = Integer.parseInt(this.textMaxCacheSize.getText());
            Registry.set("secure.maxCacheSizeMB", new Integer(n2));
        }
        catch (Throwable throwable) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.cachesize"));
        }
        try {
            Registry.commit();
        }
        catch (IOException iOException) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.commit"));
        }
    }

    private void doRestore() {
        Boolean bl = (Boolean)Registry.get("secure.allowCaching");
        Boolean bl2 = (Boolean)Registry.get("secure.allowSaveFileFromApplets");
        Boolean bl3 = (Boolean)Registry.get("secure.allowCaptureFromApplets");
        String string = (String)Registry.get("secure.cacheDir");
        Integer n2 = (Integer)Registry.get("secure.maxCacheSizeMB");
        Boolean bl4 = (Boolean)Registry.get("allowLogging");
        String string2 = (String)Registry.get("secure.logDir");
        this.checkAllowCaching.setState(bl != null && bl != false);
        this.checkAllowFileWrite.setState(bl2 != null && bl2 != false);
        this.checkAllowCapture.setState(bl3 != null && bl3 != false);
        this.checkAllowLogging.setState(bl4 != null && bl4 != false);
        if (string != null) {
            this.textCacheDir.setText(string);
        }
        if (n2 != null) {
            this.textMaxCacheSize.setText(n2.toString());
        }
        if (string2 != null) {
            this.textLoggingDir.setText(string2);
        }
    }
}

