/*
 * Decompiled with CFR 0.152.
 */
package javax.media.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class BufferToImage {
    private VideoFormat format;
    private Codec converter = null;
    private RGBFormat prefFormat;
    private Buffer outputBuffer;
    private Dimension size;
    private boolean converterNotRequired = false;

    public BufferToImage(VideoFormat videoFormat) {
        if (videoFormat instanceof YUVFormat || videoFormat instanceof RGBFormat) {
            this.format = videoFormat;
            this.size = videoFormat.getSize();
            this.prefFormat = new RGBFormat(this.size, this.size.width * this.size.height, Format.intArray, videoFormat.getFrameRate(), 32, -1, -1, -1, 1, -1, 0, -1);
            if (videoFormat.matches(this.prefFormat)) {
                this.converterNotRequired = true;
                return;
            }
            Codec codec = this.findCodec(videoFormat, this.prefFormat);
            if (codec != null) {
                this.converter = codec;
            }
            this.outputBuffer = new Buffer();
        }
    }

    public Image createImage(Buffer buffer) {
        RGBFormat rGBFormat;
        int[] nArray;
        if (buffer == null || this.converter == null && !this.converterNotRequired || this.prefFormat == null || buffer.getFormat() == null || !buffer.getFormat().matches(this.format) || buffer.getData() == null || buffer.isEOM() || buffer.isDiscard()) {
            return null;
        }
        try {
            if (this.converterNotRequired) {
                nArray = (int[])buffer.getData();
                rGBFormat = (RGBFormat)buffer.getFormat();
                this.outputBuffer = buffer;
            } else {
                int n2 = this.converter.process(buffer, this.outputBuffer);
                if (n2 != 0) {
                    return null;
                }
                nArray = (int[])this.outputBuffer.getData();
                rGBFormat = (RGBFormat)this.outputBuffer.getFormat();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception);
            return null;
        }
        Image image = null;
        BufferToImage bufferToImage = null;
        try {
            Class<?> clazz = Class.forName("com.sun.media.util.BufferToBufferedImage");
            bufferToImage = (BufferToImage)clazz.newInstance();
        }
        catch (Exception exception) {}
        if (bufferToImage != null) {
            image = bufferToImage.createImage(this.outputBuffer);
        } else {
            int n3 = rGBFormat.getRedMask();
            int n4 = rGBFormat.getGreenMask();
            int n5 = rGBFormat.getBlueMask();
            DirectColorModel directColorModel = new DirectColorModel(32, n3, n4, n5);
            MemoryImageSource memoryImageSource = new MemoryImageSource(this.size.width, this.size.height, (ColorModel)directColorModel, nArray, 0, this.size.width);
            image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        }
        return image;
    }

    private Codec findCodec(VideoFormat videoFormat, VideoFormat videoFormat2) {
        Vector vector = PlugInManager.getPlugInList(videoFormat, videoFormat2, 2);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Format[] formatArray;
            String string = (String)vector.elementAt(n2);
            Class<?> clazz = null;
            Codec codec = null;
            try {
                clazz = Class.forName(string);
                if (clazz != null) {
                    codec = (Codec)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassCastException classCastException) {}
            if (codec != null && codec.setInputFormat(videoFormat) != null && (formatArray = codec.getSupportedOutputFormats(videoFormat)) != null && formatArray.length != 0) {
                int n3 = 0;
                while (n3 < formatArray.length) {
                    Format format;
                    if (formatArray[n3].matches(videoFormat2) && (format = codec.setOutputFormat(formatArray[n3])) != null && format.matches(videoFormat2)) {
                        try {
                            codec.open();
                            return codec;
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {}
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return null;
    }
}

