/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JDK12Security;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12Action;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MediaThread
extends Thread {
    private static ThreadGroup threadGroup;
    static boolean securityPrivilege;
    private static final boolean debug = false;
    private static int controlPriority;
    private static int audioPriority;
    private static int videoPriority;
    private static int networkPriority;
    private static int videoNetworkPriority;
    private static int defaultMaxPriority;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    static {
        block14: {
            securityPrivilege = true;
            controlPriority = 9;
            audioPriority = 5;
            videoPriority = 3;
            networkPriority = audioPriority + 1;
            videoNetworkPriority = networkPriority - 1;
            defaultMaxPriority = 4;
            JMFSecurity jMFSecurity = null;
            Method[] methodArray = new Method[1];
            Class[] classArray = new Class[1];
            Object[][] objectArray = new Object[1][0];
            try {
                jMFSecurity = JMFSecurityManager.getJMFSecurity();
                if (jMFSecurity == null) break block14;
                if (jMFSecurity.getName().startsWith("jmf-security")) {
                    boolean bl = true;
                    defaultMaxPriority = Thread.currentThread().getPriority();
                    try {
                        jMFSecurity.requestPermission(methodArray, classArray, objectArray, 16);
                        methodArray[0].invoke((Object)classArray[0], objectArray[0]);
                    }
                    catch (Throwable throwable) {
                        jMFSecurity.permissionFailureNotification(16);
                        bl = false;
                    }
                    if (bl) {
                        defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
                    }
                    try {
                        jMFSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                        methodArray[0].invoke((Object)classArray[0], objectArray[0]);
                    }
                    catch (Throwable throwable) {
                        jMFSecurity.permissionFailureNotification(32);
                        bl = false;
                    }
                    if (!bl) {
                        throw new Exception("No thread and or threadgroup permission");
                    }
                    break block14;
                }
                if (jMFSecurity.getName().startsWith("internet")) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                } else if (jMFSecurity.getName().startsWith("jdk12")) {
                    Constructor constructor = jdk12Action.getCheckPermissionAction();
                    defaultMaxPriority = Thread.currentThread().getPriority();
                    jdk12.doPrivContextM.invoke((Object)jdk12.ac, constructor.newInstance(JDK12Security.getThreadPermission()), jdk12.getContextM.invoke(null, null));
                    defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
                    jdk12.doPrivContextM.invoke((Object)jdk12.ac, constructor.newInstance(JDK12Security.getThreadGroupPermission()), jdk12.getContextM.invoke(null, null));
                } else if (jMFSecurity.getName().startsWith("default") && (class$com$sun$media$util$MediaThread != null ? class$com$sun$media$util$MediaThread : (class$com$sun$media$util$MediaThread = MediaThread.class$("com.sun.media.util.MediaThread"))).getClassLoader() != null) {
                    throw new SecurityException();
                }
            }
            catch (Throwable throwable) {
                securityPrivilege = false;
                controlPriority = defaultMaxPriority;
                audioPriority = defaultMaxPriority;
                videoPriority = defaultMaxPriority - 1;
                networkPriority = defaultMaxPriority;
                videoNetworkPriority = defaultMaxPriority;
            }
        }
        threadGroup = securityPrivilege ? MediaThread.getRootThreadGroup() : null;
    }

    public MediaThread() {
        this("JMF thread");
    }

    public MediaThread(Runnable runnable) {
        this(runnable, "JMF thread");
    }

    public MediaThread(Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    public MediaThread(String string) {
        super(threadGroup, string);
    }

    private void checkPriority(String string, int n2, boolean bl, int n3) {
        if (n2 != n3) {
            System.out.println("MediaThread: " + string + " privilege? " + bl + "  ask pri: " + n2 + " got pri:  " + n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static int getAudioPriority() {
        return audioPriority;
    }

    public static int getControlPriority() {
        return controlPriority;
    }

    public static int getNetworkPriority() {
        return networkPriority;
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = null;
        try {
            ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup2.getParent() != null) {
                threadGroup2 = threadGroup2.getParent();
            }
            return threadGroup2;
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    public static int getVideoNetworkPriority() {
        return videoNetworkPriority;
    }

    public static int getVideoPriority() {
        return videoPriority;
    }

    public void useAudioPriority() {
        this.usePriority(audioPriority);
    }

    public void useControlPriority() {
        this.usePriority(controlPriority);
    }

    public void useNetworkPriority() {
        this.usePriority(networkPriority);
    }

    private void usePriority(int n2) {
        try {
            this.setPriority(n2);
        }
        catch (Throwable throwable) {}
    }

    public void useVideoNetworkPriority() {
        this.usePriority(videoNetworkPriority);
    }

    public void useVideoPriority() {
        this.usePriority(videoPriority);
    }
}

