/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.TabField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class TabControl
extends Panel
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_LEFT = 1;
    private Panel panelPageContainer;
    private CardLayout layoutCard = new CardLayout();
    private int nCurrentPage = -1;
    private Button buttonFocus;
    private boolean boolFocus = false;
    private int nAlignment = 0;
    private int MARGIN_PAGE_VERT = 6;
    private int MARGIN_PAGE_HORZ = 6;
    private String strPageToShowAfterPaint = null;
    private Cursor cursorNormal = new Cursor(0);
    private Cursor cursorWait = new Cursor(3);
    private Vector vectorTabs = new Vector();
    private int nTabHeightMax = 1;
    private int nTabWidthMax = 1;
    private int nRowCount = 1;

    public TabControl() {
        this(0);
    }

    public TabControl(int n2) {
        this.nAlignment = n2;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int addPage(Panel panel, String string) {
        int n2 = this.addPage(panel, string, null);
        return n2;
    }

    public int addPage(Panel panel, String string, Image image) {
        int n2 = this.vectorTabs.size();
        TabField tabField = new TabField(this, panel, string, image);
        this.vectorTabs.addElement(tabField);
        this.panelPageContainer.add((Component)panel, string);
        if (n2 == 0) {
            this.nCurrentPage = 0;
            this.layoutCard.show(this.panelPageContainer, string);
        }
        tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
        this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
        this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
        this.recalculateTabs();
        this.repaint();
        return n2;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.recalculateTabs();
        this.doLayout();
        this.panelPageContainer.validate();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void drawDot(Graphics graphics, int n2, int n3) {
        if ((n2 + n3) % 2 == 0) {
            graphics.drawLine(n2, n3, n2, n3);
        }
    }

    private void drawDottedLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n2 == n4 && n3 == n5) {
            this.drawDot(graphics, n2, n3);
            return;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 > n5) {
            n6 = n3;
            n3 = n5;
            n5 = n6;
        }
        if (n4 - n2 > n5 - n3) {
            double d2 = (double)(n5 - n3) / (double)(n4 - n2);
            n7 = n2;
            while (n7 <= n4) {
                n6 = (int)Math.rint((double)n3 + (double)(n7 - n2) * d2);
                this.drawDot(graphics, n7, n6);
                ++n7;
            }
        } else {
            double d3 = (n4 - n2) / (n5 - n3);
            n6 = n3;
            while (n6 <= n5) {
                n7 = (int)Math.rint((double)n2 + (double)(n6 - n3) * d3);
                this.drawDot(graphics, n7, n6);
                ++n6;
            }
        }
    }

    private void drawDottedRectangle(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.drawDottedLine(graphics, n2, n3, n2 + n4 - 1, n3);
        this.drawDottedLine(graphics, n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1);
        this.drawDottedLine(graphics, n2 + n4 - 1, n3 + n5 - 1, n2, n3 + n5 - 1);
        this.drawDottedLine(graphics, n2, n3 + n5 - 1, n2, n3);
    }

    private int findPage(Panel panel) {
        int n2 = this.vectorTabs.size() - 1;
        while (n2 >= 0) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(n2);
            if (tabField.panelPage == panel) break;
            --n2;
        }
        return n2;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets = this.nAlignment == 1 ? new Insets(insets.top + this.MARGIN_PAGE_VERT, insets.left + this.nRowCount * this.nTabWidthMax - 2 + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ) : new Insets(insets.top + this.nRowCount * this.nTabHeightMax - 2 + this.MARGIN_PAGE_VERT, insets.left + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ);
        return insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.nAlignment == 1) {
            dimension.height = Math.max(dimension.height, this.nTabHeightMax * this.vectorTabs.size() + 1);
        } else {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.vectorTabs.size()) {
                TabField tabField = (TabField)this.vectorTabs.elementAt(n3);
                n2 += tabField.dim.width;
                ++n3;
            }
            dimension.width = Math.max(dimension.width, n2 + 1);
        }
        return dimension;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.buttonFocus = new Button("Focus");
        this.add(this.buttonFocus);
        this.buttonFocus.addKeyListener(this);
        this.buttonFocus.addFocusListener(this);
        this.panelPageContainer = new Panel(this.layoutCard);
        this.add((Component)this.panelPageContainer, "Center");
        Font font = this.panelPageContainer.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        Font font2 = new Font("Dialog", 0, 12);
        this.setFont(font2);
        this.panelPageContainer.setFont(font);
        this.setBackground(TabField.COLOR_BG);
        this.panelPageContainer.setBackground(TabField.COLOR_BG);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = this.nCurrentPage;
        int n3 = keyEvent.getKeyCode();
        if (n3 == 40 || n3 == 39) {
            ++n2;
        } else if (n3 == 38 || n3 == 37) {
            --n2;
        }
        if (n2 >= this.vectorTabs.size()) {
            n2 = this.vectorTabs.size() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.nCurrentPage != n2) {
            this.nCurrentPage = n2;
            TabField tabField = (TabField)this.vectorTabs.elementAt(n2);
            this.strPageToShowAfterPaint = tabField.strTitle;
            this.setCursor(this.cursorWait);
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.vectorTabs.size();
        int n5 = 0;
        while (n5 < n4) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(n5);
            if (tabField.rect.contains(n2, n3)) {
                this.buttonFocus.requestFocus();
                this.nCurrentPage = n5;
                this.strPageToShowAfterPaint = tabField.strTitle;
                this.setCursor(this.cursorWait);
                this.repaint();
                break;
            }
            ++n5;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Font font;
        super.paint(graphics);
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.nAlignment == 1) {
            rectangle2.x += this.nTabWidthMax * this.nRowCount - 2;
            rectangle2.width -= this.nTabWidthMax * this.nRowCount - 2;
        } else {
            rectangle2.y += this.nTabHeightMax * this.nRowCount - 2;
            rectangle2.height -= this.nTabHeightMax * this.nRowCount - 2;
        }
        --rectangle2.width;
        --rectangle2.height;
        graphics.setColor(TabField.COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(TabField.COLOR_SHADOW_TOP);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + rectangle2.height - 2);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 2, rectangle2.y + 1);
        Font font2 = font = this.getFont();
        int n2 = this.vectorTabs.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4;
            int n5;
            int n6;
            FontMetrics fontMetrics;
            int n7;
            TabField tabField = (TabField)this.vectorTabs.elementAt(n3);
            if (n3 == this.nCurrentPage) {
                if (this.nAlignment == 1) {
                    tabField.drawCurrentTabLeft(graphics);
                } else {
                    tabField.drawCurrentTabTop(graphics);
                }
            } else if (this.nAlignment == 1) {
                tabField.drawTabLeft(graphics);
            } else {
                tabField.drawTabTop(graphics);
            }
            graphics.setColor(this.getForeground());
            Rectangle rectangle3 = new Rectangle(tabField.rect);
            if (this.nAlignment == 1) {
                rectangle3.width = this.nTabWidthMax;
            } else {
                rectangle3.height = this.nTabHeightMax;
            }
            if (tabField.image != null) {
                n7 = tabField.image.getWidth(this);
                rectangle3.x += n7 + tabField.MARGIN_TAB_HORZ;
                rectangle3.width -= n7 + tabField.MARGIN_TAB_HORZ;
            }
            ++rectangle3.y;
            if (n3 == this.nCurrentPage) {
                graphics.setFont(font2);
                fontMetrics = graphics.getFontMetrics(font2);
                if (this.boolFocus) {
                    n7 = fontMetrics.stringWidth(tabField.strTitle) + 6;
                    n6 = fontMetrics.getHeight() + 1;
                    n5 = rectangle3.x + (rectangle3.width - n7) / 2;
                    n4 = rectangle3.y + (this.nTabHeightMax - 2 - n6) / 2 + 1;
                    this.drawDottedRectangle(graphics, n5, n4, n7, n6);
                }
            } else {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
            }
            n5 = rectangle3.x + (rectangle3.width - fontMetrics.stringWidth(tabField.strTitle)) / 2;
            n4 = rectangle3.y + rectangle3.height - (rectangle3.height - fontMetrics.getHeight()) / 2 - fontMetrics.getMaxDescent();
            --n4;
            if (n3 != this.nCurrentPage) {
                ++n5;
                ++n4;
            }
            graphics.drawString(tabField.strTitle, n5, n4);
            if (tabField.image != null) {
                n6 = tabField.image.getHeight(this);
                n5 = tabField.rect.x + tabField.MARGIN_TAB_HORZ;
                n4 = tabField.rect.y + (this.nTabHeightMax - n6) / 2;
                if (n3 != this.nCurrentPage) {
                    ++n5;
                    ++n4;
                }
                graphics.drawImage(tabField.image, n5, n4, this);
            }
            --n3;
        }
        if (this.strPageToShowAfterPaint != null) {
            this.layoutCard.show(this.panelPageContainer, this.strPageToShowAfterPaint);
            this.strPageToShowAfterPaint = null;
            this.setCursor(this.cursorNormal);
        }
    }

    private void recalculateTabs() {
        int n2 = 1;
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        int n3 = this.vectorTabs.size();
        if (this.nAlignment == 1) {
            n2 = rectangle.height / this.nTabHeightMax;
            this.nRowCount = (n3 + n2 - 1) / n2;
            int n4 = this.nRowCount * this.nTabWidthMax;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                if (n6 % n2 == 0) {
                    n4 -= this.nTabWidthMax;
                    n5 = 0;
                }
                TabField tabField = (TabField)this.vectorTabs.elementAt(n6);
                tabField.rect.x = n4;
                tabField.rect.y = n5;
                tabField.rect.width = this.nTabWidthMax * (n6 / n2 + 1);
                tabField.rect.height = this.nTabHeightMax;
                tabField.nRowIndex = n6 / n2;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.width -= 2;
                }
                n5 += this.nTabHeightMax;
                ++n6;
            }
        } else {
            TabField tabField;
            this.nRowCount = 1;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                tabField = (TabField)this.vectorTabs.elementAt(n8);
                if (n7 + tabField.dim.width > rectangle.width) {
                    n7 = 0;
                    ++this.nRowCount;
                }
                n7 += tabField.dim.width;
                ++n8;
            }
            int n9 = 0;
            int n10 = this.nRowCount * this.nTabHeightMax;
            int n11 = 0;
            int n12 = 0;
            n8 = 0;
            while (n8 < n3) {
                if (n8 == n12) {
                    n9 = 0;
                    n10 -= this.nTabHeightMax;
                    n7 = 0;
                    n12 = n8;
                    while (n12 < n3) {
                        tabField = (TabField)this.vectorTabs.elementAt(n12);
                        if (n12 > n8 && n7 + tabField.dim.width > rectangle.width) break;
                        n7 += tabField.dim.width;
                        tabField.nRowIndex = n11;
                        ++n12;
                    }
                    n2 = n12 - n8;
                    ++n11;
                }
                tabField = (TabField)this.vectorTabs.elementAt(n8);
                tabField.rect.x = n9;
                tabField.rect.y = n10;
                tabField.rect.width = tabField.dim.width;
                if (this.nRowCount > 1 && n11 < this.nRowCount) {
                    tabField.rect.width += (rectangle.width - n7 - 1) / n2;
                    tabField.rect.width = tabField.rect.width + (n12 - n8 > (rectangle.width - n7 - 1) % n2 ? 0 : 1);
                }
                tabField.rect.height = this.nTabHeightMax * n11;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.height -= 2;
                }
                n9 += tabField.rect.width;
                ++n8;
            }
        }
        this.repaint();
    }

    public int setPageImage(Panel panel, Image image) {
        int n2 = this.findPage(panel);
        if (n2 < 0 || n2 >= this.vectorTabs.size()) {
            return n2;
        }
        TabField tabField = (TabField)this.vectorTabs.elementAt(n2);
        if (tabField.image == image) {
            return n2;
        }
        tabField.image = image;
        this.nTabHeightMax = 1;
        this.nTabWidthMax = 1;
        int n3 = this.vectorTabs.size();
        int n4 = 0;
        while (n4 < n3) {
            tabField = (TabField)this.vectorTabs.elementAt(n4);
            tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
            this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
            this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
            ++n4;
        }
        this.recalculateTabs();
        this.repaint();
        return n2;
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image != null ? image.getGraphics() : graphics;
        this.paint(graphics2);
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }
}

