/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class Region
implements Cloneable,
Serializable {
    protected Vector rects = new Vector();

    public Region() {
    }

    public Region(Rectangle rectangle) {
        this.addRectangle(rectangle);
    }

    public Region(Rectangle rectangle, Rectangle rectangle2) {
        this.addRectangle(rectangle);
        this.addRectangle(rectangle2);
    }

    public void addRectangle(Rectangle rectangle) {
        int n2 = 0;
        while (n2 < this.rects.size()) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n2);
            if (rectangle.x > rectangle2.x && rectangle.y > rectangle2.y && Region.right(rectangle) <= Region.right(rectangle2) && Region.bottom(rectangle) <= Region.bottom(rectangle2)) {
                return;
            }
            if (rectangle.intersects(rectangle2)) {
                rectangle = rectangle.union(rectangle2);
                this.rects.removeElementAt(n2);
                continue;
            }
            ++n2;
        }
        this.rects.addElement(rectangle);
    }

    public void addRegion(Region region) {
        Enumeration enumeration = region.rectangles();
        while (enumeration.hasMoreElements()) {
            this.addRectangle((Rectangle)enumeration.nextElement());
        }
    }

    public static int bottom(Rectangle rectangle) {
        return rectangle.y + rectangle.height - 1;
    }

    public Object clone() {
        Region region = new Region();
        region.rects = (Vector)this.rects.clone();
        return region;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle();
        int n2 = 0;
        while (n2 < this.rects.size()) {
            rectangle = rectangle.union((Rectangle)this.rects.elementAt(n2));
            ++n2;
        }
        return rectangle;
    }

    public int getNumRectangles() {
        return this.rects.size();
    }

    public void intersect(Rectangle rectangle) {
        int n2 = 0;
        while (n2 < this.rects.size()) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n2);
            if ((rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                this.rects.removeElementAt(n2);
                continue;
            }
            this.rects.setElementAt(rectangle2, n2);
            ++n2;
        }
    }

    public boolean intersects(Rectangle rectangle) {
        int n2 = 0;
        while (n2 < this.rects.size()) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n2);
            if (rectangle2.intersects(rectangle)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public Enumeration rectangles() {
        return this.rects.elements();
    }

    public static int right(Rectangle rectangle) {
        return rectangle.x + rectangle.width - 1;
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName()) + " = [\n";
        Enumeration enumeration = this.rectangles();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + "(" + (Rectangle)enumeration.nextElement() + ")\n";
        }
        return String.valueOf(string) + "]";
    }

    public void translate(int n2, int n3) {
        int n4 = 0;
        while (n4 < this.rects.size()) {
            Rectangle rectangle = (Rectangle)this.rects.elementAt(n4);
            rectangle.translate(n2, n3);
            ++n4;
        }
    }
}

