/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.MediaDescription;
import com.sun.media.sdp.Parser;
import com.sun.media.sdp.SessionDescription;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class SdpParser
extends Parser {
    public SessionDescription sessionDescription;
    public Vector mediaDescriptions;
    static String input = "v=0\r\no=mhandley 2890844526 2890842807 IN IP4 126.16.64.4\r\ns=SDP Seminar\r\ni=A Seminar on the session description protocol\r\nu=http://www.cs.ucl.ac.uk/staff/M.Handley/sdp.03.ps\r\ne=mjb@isi.edu (Mark Handley)\r\nc=IN IP4 224.2.17.12/127\r\nt=2873397496 2873404696\r\na=recvonly\r\nm=audio 49170 RTP/AVP 0\r\nm=video 51372 RTP/AVP 31\r\nm=application 32416 udp wbr\na=orient:portrait\r\n";

    public SdpParser(byte[] byArray) {
        this.init();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.parseData(byteArrayInputStream);
    }

    public MediaDescription getMediaDescription(String string) {
        MediaDescription mediaDescription = null;
        if (this.mediaDescriptions != null) {
            int n2 = 0;
            while (n2 < this.mediaDescriptions.size()) {
                MediaDescription mediaDescription2 = (MediaDescription)this.mediaDescriptions.elementAt(n2);
                if (mediaDescription2.name.equals(string)) {
                    mediaDescription = mediaDescription2;
                    break;
                }
                ++n2;
            }
        }
        return mediaDescription;
    }

    public Vector getMediaDescriptions() {
        return this.mediaDescriptions;
    }

    public MediaAttribute getSessionAttribute(String string) {
        MediaAttribute mediaAttribute = null;
        if (this.sessionDescription != null) {
            mediaAttribute = this.sessionDescription.getSessionAttribute(string);
        }
        return mediaAttribute;
    }

    public static void main(String[] stringArray) {
        new SdpParser(input.getBytes());
    }

    public void parseData(ByteArrayInputStream byteArrayInputStream) {
        if (this.getToken(byteArrayInputStream, "v=", true)) {
            this.sessionDescription = new SessionDescription(byteArrayInputStream);
            this.mediaDescriptions = new Vector();
            boolean bl = this.getToken(byteArrayInputStream, "m=", false);
            while (bl) {
                MediaDescription mediaDescription = new MediaDescription(byteArrayInputStream, this.sessionDescription.connectionIncluded);
                this.mediaDescriptions.addElement(mediaDescription);
                bl = this.getToken(byteArrayInputStream, "m=", false);
            }
        }
    }
}

