/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.video;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.SettableTime;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class QuicktimeParser
extends BasicPullParser {
    private final boolean enableHintTrackSupport = true;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("video.quicktime")};
    private PullSourceStream stream = null;
    private Track[] tracks;
    private Seekable seekableStream;
    private boolean mdatAtomPresent = false;
    private boolean moovAtomPresent = false;
    public static final int MVHD_ATOM_SIZE = 100;
    public static final int TKHD_ATOM_SIZE = 84;
    public static final int MDHD_ATOM_SIZE = 24;
    public static final int MIN_HDLR_ATOM_SIZE = 24;
    public static final int MIN_STSD_ATOM_SIZE = 8;
    public static final int MIN_STTS_ATOM_SIZE = 8;
    public static final int MIN_STSC_ATOM_SIZE = 8;
    public static final int MIN_STSZ_ATOM_SIZE = 8;
    public static final int MIN_STCO_ATOM_SIZE = 8;
    public static final int MIN_STSS_ATOM_SIZE = 8;
    public static final int MIN_VIDEO_SAMPLE_DATA_SIZE = 70;
    public static final int MIN_AUDIO_SAMPLE_DATA_SIZE = 20;
    public static final int TRACK_ENABLED = 1;
    public static final int TRACK_IN_MOVIE = 2;
    public static final int TRACK_IN_PREVIEW = 4;
    public static final int TRACK_IN_POSTER = 8;
    public static final String VIDEO = "vide";
    public static final String AUDIO = "soun";
    public static final String HINT = "hint";
    private static final int DATA_SELF_REFERENCE_FLAG = 1;
    private static final int HINT_NOP_IGNORE = 0;
    private static final int HINT_IMMEDIATE_DATA = 1;
    private static final int HINT_SAMPLE_DATA = 2;
    private static final int HINT_SAMPLE_DESCRIPTION = 3;
    private MovieHeader movieHeader = new MovieHeader();
    private int numTracks = 0;
    private int numSupportedTracks = 0;
    private int numberOfHintTracks = 0;
    private static int MAX_TRACKS_SUPPORTED = 100;
    private TrakList[] trakList = new TrakList[MAX_TRACKS_SUPPORTED];
    private TrakList currentTrack;
    private int keyFrameTrack = -1;
    private SettableTime mediaTime = new SettableTime(0L);
    private int hintAudioTrackNum = -1;
    private boolean debug = false;
    private boolean debug1 = false;
    private boolean debug2 = false;
    private Object seekSync = new Object();
    private int tmpIntBufferSize = 16384;
    private byte[] tmpBuffer = new byte[this.tmpIntBufferSize * 4];

    static /* synthetic */ CachedStream access$3(QuicktimeParser quicktimeParser) {
        return quicktimeParser.getCacheStream();
    }

    private CachedStream getCacheStream() {
        return this.cacheStream;
    }

    public Time getDuration() {
        return this.movieHeader.duration;
    }

    public Time getMediaTime() {
        return null;
    }

    public String getName() {
        return "Parser for quicktime file format";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks != null) {
            return this.tracks;
        }
        if (this.seekableStream == null) {
            return new Track[0];
        }
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.tracks = new Track[this.numSupportedTracks];
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.numSupportedTracks) {
            TrakList trakList = this.trakList[n2];
            if (trakList.trackType.equals(AUDIO)) {
                this.tracks[n2] = new AudioTrack(trakList);
            } else if (trakList.trackType.equals(VIDEO)) {
                this.tracks[n2] = new VideoTrack(trakList);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.numSupportedTracks) {
            TrakList trakList = this.trakList[n3];
            if (trakList.trackType.equals(HINT)) {
                int n4 = trakList.trackIdOfTrackBeingHinted;
                int n5 = 0;
                while (n5 < this.numTracks) {
                    if (n4 == this.trakList[n5].id) {
                        int n6;
                        int n7;
                        int n8;
                        trakList.indexOfTrackBeingHinted = n5;
                        String string = this.trakList[n5].trackType;
                        String string2 = this.trakList[trakList.indexOfTrackBeingHinted].media.encoding;
                        if (string2.equals("agsm")) {
                            string2 = "gsm";
                        }
                        String string3 = String.valueOf(string2) + "/rtp";
                        if (string.equals(AUDIO)) {
                            Audio audio = (Audio)this.trakList[n5].media;
                            this.hintAudioTrackNum = n3;
                            n8 = audio.channels;
                            n7 = audio.frameSizeInBits / 8;
                            n6 = audio.samplesPerBlock;
                            int n9 = audio.sampleRate;
                            ((Hint)trakList.media).format = new AudioFormat(string3, n9, 8, n8);
                            this.tracks[n3] = new HintAudioTrack(trakList, n8, string3, n7, n6, n9);
                            break;
                        }
                        if (!string.equals(VIDEO)) break;
                        n8 = trakList.indexOfTrackBeingHinted;
                        TrakList trakList2 = null;
                        if (n8 >= 0) {
                            trakList2 = this.trakList[n8];
                        }
                        n7 = 0;
                        n6 = 0;
                        if (trakList2 != null) {
                            Video video = (Video)trakList2.media;
                            n7 = video.width;
                            n6 = video.height;
                        }
                        if (n7 > 0 && n6 > 0) {
                            ((Hint)trakList.media).format = new VideoFormat(string3, new Dimension(n7, n6), -1, null, -1.0f);
                        }
                        HintVideoTrack hintVideoTrack = new HintVideoTrack(trakList);
                        this.tracks[n3] = hintVideoTrack;
                        break;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return this.tracks;
    }

    private boolean isSupported(String string) {
        return string.equals(VIDEO) || string.equals(AUDIO) || string.equals(HINT);
    }

    private boolean parseAtom() throws BadHeaderException {
        boolean bl = false;
        try {
            int n2 = this.readInt(this.stream);
            bl = true;
            String string = this.readString(this.stream);
            if (n2 < 8) {
                throw new BadHeaderException(String.valueOf(string) + ": Bad Atom size " + n2);
            }
            if (string.equals("moov")) {
                return this.parseMOOV(n2 - 8);
            }
            if (string.equals("mdat")) {
                return this.parseMDAT(n2 - 8);
            }
            this.skipAtom(String.valueOf(string) + " [not implemented]", n2 - 8);
            return true;
        }
        catch (IOException iOException) {
            if (!bl) {
                return false;
            }
            throw new BadHeaderException("Unexpected End of Media");
        }
    }

    private Audio parseAudioSampleData(String string, int n2) throws IOException, BadHeaderException {
        this.skip(this.stream, 2);
        this.skip(this.stream, 8);
        Audio audio = new Audio();
        audio.encoding = string;
        audio.channels = this.readShort(this.stream);
        audio.bitsPerSample = this.readShort(this.stream);
        this.skip(this.stream, 4);
        int n3 = this.readInt(this.stream);
        audio.sampleRate = this.currentTrack.mediaTimeScale;
        this.skip(this.stream, n2 - 2 - 20);
        return audio;
    }

    private void parseCTAB(int n2) throws BadHeaderException {
        try {
            this.skip(this.stream, n2);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("....");
        }
    }

    private void parseDINF(int n2) throws BadHeaderException {
        try {
            int n3 = n2;
            while (n3 > 0) {
                int n4 = this.readInt(this.stream);
                String string = this.readString(this.stream);
                if (string.equals("dref")) {
                    this.parseDREF(n4 - 8);
                } else {
                    this.skipAtom(String.valueOf(string) + " [Unknown atom in dinf]", n4 - 8);
                }
                n3 -= n4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past DIMF atom");
        }
    }

    private void parseDREF(int n2) throws BadHeaderException {
        try {
            this.skip(this.stream, 4);
            int n3 = this.readInt(this.stream);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.readInt(this.stream);
                int n6 = this.readInt(this.stream);
                int n7 = this.readInt(this.stream);
                this.skip(this.stream, n5 - 12);
                if ((n7 & 1) <= 0) {
                    throw new BadHeaderException("Only self contained Quicktime movies are supported");
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past DREF atom");
        }
    }

    private void parseHDLR(int n2) throws BadHeaderException {
        try {
            if (n2 < 24) {
                throw new BadHeaderException("hdlr atom: header size is incorrect");
            }
            this.skip(this.stream, 8);
            this.currentTrack.trackType = this.readString(this.stream);
            this.currentTrack.supported = this.isSupported(this.currentTrack.trackType);
            this.skip(this.stream, n2 - 8 - 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past HDLR atom");
        }
    }

    private Hint parseHintSampleData(String string, int n2) throws IOException, BadHeaderException {
        int n3;
        if (!string.equals("rtp ")) {
            System.err.println("Hint track Data Format is not rtp");
        }
        Hint hint = new Hint();
        int n4 = this.readShort(this.stream);
        int n5 = this.readShort(this.stream);
        if (n5 == 0) {
            System.err.println("Hint Track version #0 is not supported");
            System.err.println("Use QuickTimePro to convert it to version #1");
            this.currentTrack.supported = false;
            if (n2 - 2 - 2 > 0) {
                this.skip(this.stream, n2 - 2 - 2);
            }
            return hint;
        }
        int n6 = this.readShort(this.stream);
        this.currentTrack.maxPacketSize = n3 = this.readInt(this.stream);
        int n7 = n2 - 2 - 2 - 2 - 4;
        if (this.debug1) {
            System.out.println("dataReferenceIndex is " + n4);
            System.out.println("hintTrackVersion is " + n5);
            System.out.println("lastCompatibleHintTrackVersion is " + n6);
            System.out.println("maxPacketSize is " + n3);
            System.out.println("remaining is " + n7);
        }
        while (n7 > 8) {
            int n8 = this.readInt(this.stream);
            n7 -= 4;
            if (n8 > 8) {
                int n9;
                if (this.debug2) {
                    System.out.println("entryLength is " + n8);
                }
                String string2 = this.readString(this.stream);
                if (this.debug2) {
                    System.out.println("dataTag is " + string2);
                }
                n7 -= 4;
                if (string2.equals("tims")) {
                    n9 = this.readInt(this.stream);
                    n7 -= 4;
                    continue;
                }
                if (string2.equals("tsro")) {
                    System.out.println("QuicktimeParser: rtp: tsro dataTag not supported");
                    n9 = this.readInt(this.stream);
                    n7 -= 4;
                    continue;
                }
                if (string2.equals("snro")) {
                    System.out.println("QuicktimeParser: rtp: snro dataTag not supported");
                    n9 = this.readInt(this.stream);
                    n7 -= 4;
                    continue;
                }
                if (string2.equals("rely")) {
                    System.out.println("QuicktimeParser: rtp: rely dataTag not supported");
                    n9 = this.readByte(this.stream);
                    --n7;
                    continue;
                }
                this.skip(this.stream, n7);
                n7 = 0;
                continue;
            }
            this.skip(this.stream, n7);
            n7 = 0;
            break;
        }
        if (n7 > 0) {
            this.skip(this.stream, n7);
        }
        return hint;
    }

    private boolean parseMDAT(int n2) throws BadHeaderException {
        try {
            this.mdatAtomPresent = true;
            this.movieHeader.mdatStart = this.getLocation(this.stream);
            this.movieHeader.mdatSize = n2;
            if (!this.moovAtomPresent) {
                this.skip(this.stream, n2);
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDAT atom");
        }
    }

    private void parseMDHD(int n2) throws BadHeaderException {
        try {
            if (n2 != 24) {
                throw new BadHeaderException("mdhd atom: header size is incorrect");
            }
            this.skip(this.stream, 12);
            int n3 = this.readInt(this.stream);
            int n4 = this.readInt(this.stream);
            this.currentTrack.mediaDuration = new Time((double)n4 / (double)n3);
            this.currentTrack.mediaTimeScale = n3;
            this.skip(this.stream, 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDHD atom");
        }
    }

    private boolean parseMDIA(int n2) throws BadHeaderException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.currentTrack.trackType = null;
            int n3 = n2;
            int n4 = this.readInt(this.stream);
            String string = this.readString(this.stream);
            if (n4 < 8) {
                throw new BadHeaderException(String.valueOf(string) + ": Bad Atom size " + n4);
            }
            if (!string.equals("mdhd")) {
                throw new BadHeaderException("Expected mdhd atom but got " + string);
            }
            this.parseMDHD(n4 - 8);
            n3 -= n4;
            while (n3 > 0) {
                n4 = this.readInt(this.stream);
                string = this.readString(this.stream);
                if (string.equals("hdlr")) {
                    this.parseHDLR(n4 - 8);
                    bl = true;
                } else if (string.equals("minf")) {
                    if (this.currentTrack.trackType == null) {
                        throw new BadHeaderException("In MDIA atom container minf atom appears before hdlr");
                    }
                    if (this.currentTrack.supported) {
                        this.parseMINF(n4 - 8);
                    } else {
                        this.skipAtom(String.valueOf(string) + " [atom in mdia] as trackType " + this.currentTrack.trackType + " is not supported", n4 - 8);
                    }
                    bl2 = true;
                } else {
                    this.skipAtom(String.valueOf(string) + " [atom in mdia: not implemented]", n4 - 8);
                }
                n3 -= n4;
            }
            if (!bl) {
                throw new BadHeaderException("hdlr atom not present in mdia atom container");
            }
            if (!bl2) {
                throw new BadHeaderException("minf atom not present in mdia atom container");
            }
            return this.currentTrack.supported;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDIA atom");
        }
    }

    private void parseMINF(int n2) throws BadHeaderException {
        boolean bl = false;
        try {
            int n3 = n2;
            int n4 = this.readInt(this.stream);
            String string = this.readString(this.stream);
            if (n4 < 8) {
                throw new BadHeaderException(String.valueOf(string) + ": Bad Atom size " + n4);
            }
            if (!string.endsWith("hd")) {
                throw new BadHeaderException("Expected media information header atom but got " + string);
            }
            this.skipAtom(String.valueOf(string) + " [atom in minf: not implemented]", n4 - 8);
            n3 -= n4;
            while (n3 > 0) {
                n4 = this.readInt(this.stream);
                string = this.readString(this.stream);
                if (string.equals("hdlr")) {
                    this.skipAtom(String.valueOf(string) + " [atom in minf: not implemented]", n4 - 8);
                    bl = true;
                } else if (string.equals("dinf")) {
                    this.parseDINF(n4 - 8);
                } else if (string.equals("stbl")) {
                    this.parseSTBL(n4 - 8);
                } else {
                    this.skipAtom(String.valueOf(string) + " [atom in minf: not implemented]", n4 - 8);
                }
                n3 -= n4;
            }
            if (!bl) {
                throw new BadHeaderException("hdlr atom not present in minf atom container");
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MINF atom");
        }
    }

    private boolean parseMOOV(int n2) throws BadHeaderException {
        boolean bl = false;
        try {
            this.moovAtomPresent = true;
            long l2 = this.getLocation(this.stream) + (long)n2;
            int n3 = n2;
            int n4 = this.readInt(this.stream);
            String string = this.readString(this.stream);
            if (n4 < 8) {
                throw new BadHeaderException(String.valueOf(string) + ": Bad Atom size " + n4);
            }
            if (!string.equals("mvhd")) {
                if (string.equals("cmov")) {
                    throw new BadHeaderException("Compressed movie headers are not supported");
                }
                throw new BadHeaderException("Expected mvhd atom but got " + string);
            }
            this.parseMVHD(n4 - 8);
            n3 -= n4;
            while (n3 > 0) {
                n4 = this.readInt(this.stream);
                string = this.readString(this.stream);
                if (string.equals("trak")) {
                    if (this.trakList[this.numSupportedTracks] == null) {
                        this.trakList[this.numSupportedTracks] = this.currentTrack = new TrakList();
                    }
                    if (this.parseTRAK(n4 - 8)) {
                        ++this.numSupportedTracks;
                    }
                    bl = true;
                    ++this.numTracks;
                } else if (string.equals("ctab")) {
                    this.parseCTAB(n4 - 8);
                } else {
                    this.skipAtom(String.valueOf(string) + " [atom in moov: not implemented]", n4 - 8);
                }
                n3 -= n4;
            }
            if (!bl) {
                throw new BadHeaderException("trak atom not present in trak atom container");
            }
            return this.mdatAtomPresent ^ true;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing the header");
        }
    }

    private void parseMVHD(int n2) throws BadHeaderException {
        try {
            if (n2 != 100) {
                throw new BadHeaderException("mvhd atom: header size is incorrect");
            }
            this.skip(this.stream, 12);
            this.movieHeader.timeScale = this.readInt(this.stream);
            int n3 = this.readInt(this.stream);
            this.movieHeader.duration = new Time((double)n3 / (double)this.movieHeader.timeScale);
            int n4 = this.readInt(this.stream);
            int n5 = this.readShort(this.stream);
            this.skip(this.stream, 10);
            this.skip(this.stream, 36);
            int n6 = this.readInt(this.stream);
            int n7 = this.readInt(this.stream);
            int n8 = this.readInt(this.stream);
            int n9 = this.readInt(this.stream);
            int n10 = this.readInt(this.stream);
            int n11 = this.readInt(this.stream);
            int n12 = this.readInt(this.stream);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MVHD atom");
        }
    }

    private void parseSTBL(int n2) throws BadHeaderException {
        try {
            int n3 = n2;
            while (n3 > 0) {
                int n4 = this.readInt(this.stream);
                String string = this.readString(this.stream);
                if (string.equals("stsd")) {
                    this.parseSTSD(n4 - 8);
                } else if (string.equals("stts")) {
                    this.parseSTTS(n4 - 8);
                } else if (string.equals("stss")) {
                    this.parseSTSS(n4 - 8);
                } else if (string.equals("stsc")) {
                    this.parseSTSC(n4 - 8);
                } else if (string.equals("stsz")) {
                    this.parseSTSZ(n4 - 8);
                } else if (string.equals("stco")) {
                    this.parseSTCO(n4 - 8);
                } else if (string.equals("stsh")) {
                    this.skipAtom(String.valueOf(string) + " [not implemented]", n4 - 8);
                } else {
                    this.skipAtom(String.valueOf(string) + " [UNKNOWN atom in stbl: ignored]", n4 - 8);
                }
                n3 -= n4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STBL atom");
        }
    }

    private void parseSTCO(int n2) throws BadHeaderException {
        if (this.debug2) {
            System.out.println("rtp:parseSTCO: " + n2);
        }
        try {
            int n3;
            if (n2 < 8) {
                throw new BadHeaderException("stco atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            this.currentTrack.numberOfChunks = n3 = this.readInt(this.stream);
            int[] nArray = new int[n3];
            int n4 = n2 - 8 - n3 * 4;
            if (n4 < 0) {
                throw new BadHeaderException("stco atom: inconsistent number_of_entries field");
            }
            int n5 = n3;
            int n6 = 1;
            int n7 = this.tmpIntBufferSize / n6;
            int n8 = 0;
            while (n5 > 0) {
                int n9 = n5 > n7 ? n7 : n5;
                this.readBytes(this.stream, this.tmpBuffer, n9 * n6 * 4);
                int n10 = 0;
                int n11 = 1;
                while (n11 <= n9) {
                    nArray[n8] = this.parseIntFromArray(this.tmpBuffer, n10, true);
                    n10 += 4;
                    ++n11;
                    ++n8;
                }
                n5 -= n9;
            }
            this.currentTrack.chunkOffsets = nArray;
            this.skip(this.stream, n4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STCO atom");
        }
    }

    private void parseSTSC(int n2) throws BadHeaderException {
        try {
            if (n2 < 8) {
                throw new BadHeaderException("stsc atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int n3 = this.readInt(this.stream);
            int n4 = n2 - 8 - n3 * 12;
            if (n4 < 0) {
                throw new BadHeaderException("stsc atom: inconsistent number_of_entries field");
            }
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            byte[] byArray = new byte[n3 * 4 * 3];
            this.readBytes(this.stream, byArray, n3 * 4 * 3);
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                nArray[n6] = this.parseIntFromArray(byArray, n5, true);
                nArray2[n6] = this.parseIntFromArray(byArray, n5 += 4, true);
                n5 += 4;
                n5 += 4;
                ++n6;
            }
            byArray = null;
            this.currentTrack.compactSamplesChunkNum = nArray;
            this.currentTrack.compactSamplesPerChunk = nArray2;
            this.skip(this.stream, n4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSC atom");
        }
    }

    private void parseSTSD(int n2) throws BadHeaderException {
        try {
            if (n2 < 8) {
                throw new BadHeaderException("stsd atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int n3 = this.readInt(this.stream);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.readInt(this.stream);
                String string = this.readString(this.stream);
                if (n4 != 0) {
                    this.skip(this.stream, n5 - 8);
                } else {
                    this.skip(this.stream, 6);
                    if (this.currentTrack.trackType.equals(VIDEO)) {
                        this.currentTrack.media = this.parseVideoSampleData(string, n5 - 4 - 4 - 6);
                    } else if (this.currentTrack.trackType.equals(AUDIO)) {
                        this.currentTrack.media = this.parseAudioSampleData(string, n5 - 4 - 4 - 6);
                    } else if (this.currentTrack.trackType.equals(HINT)) {
                        ++this.numberOfHintTracks;
                        this.currentTrack.media = this.parseHintSampleData(string, n5 - 4 - 4 - 6);
                    } else {
                        this.skip(this.stream, n5 - 4 - 4 - 6);
                    }
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSD atom");
        }
    }

    private void parseSTSS(int n2) throws BadHeaderException {
        try {
            if (n2 < 8) {
                throw new BadHeaderException("stss atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int n3 = this.readInt(this.stream);
            int n4 = n2 - 8 - n3 * 4;
            if (n4 < 0) {
                throw new BadHeaderException("stss atom: inconsistent number_of_entries field");
            }
            if (n3 < 1) {
                this.skip(this.stream, n4);
                return;
            }
            int[] nArray = new int[n3];
            int n5 = n3;
            int n6 = 1;
            int n7 = this.tmpIntBufferSize / n6;
            int n8 = 0;
            while (n5 > 0) {
                int n9 = n5 > n7 ? n7 : n5;
                this.readBytes(this.stream, this.tmpBuffer, n9 * n6 * 4);
                int n10 = 0;
                int n11 = 1;
                while (n11 <= n9) {
                    nArray[n8] = this.parseIntFromArray(this.tmpBuffer, n10, true);
                    n10 += 4;
                    ++n11;
                    ++n8;
                }
                n5 -= n9;
            }
            this.currentTrack.syncSamples = nArray;
            this.skip(this.stream, n4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSS atom");
        }
    }

    private void parseSTSZ(int n2) throws BadHeaderException {
        if (this.debug2) {
            System.out.println("parseSTSZ: " + n2);
        }
        try {
            int n3;
            if (n2 < 8) {
                throw new BadHeaderException("stsz atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            this.currentTrack.sampleSize = this.readInt(this.stream);
            if (this.currentTrack.sampleSize != 0) {
                this.skip(this.stream, n2 - 8);
                this.currentTrack.media.maxSampleSize = this.currentTrack.sampleSize;
                return;
            }
            if (n2 - 8 < 4) {
                throw new BadHeaderException("stsz atom: incorrect atom size");
            }
            int n4 = this.readInt(this.stream);
            if (this.currentTrack.numberOfSamples == 0) {
                this.currentTrack.numberOfSamples = n4;
            }
            if ((n3 = n2 - 8 - 4 - n4 * 4) < 0) {
                throw new BadHeaderException("stsz atom: inconsistent number_of_entries field");
            }
            int[] nArray = new int[n4];
            int n5 = Integer.MIN_VALUE;
            int n6 = n4;
            int n7 = 1;
            int n8 = this.tmpIntBufferSize / n7;
            int n9 = 0;
            while (n6 > 0) {
                int n10 = n6 > n8 ? n8 : n6;
                this.readBytes(this.stream, this.tmpBuffer, n10 * n7 * 4);
                int n11 = 0;
                int n12 = 1;
                while (n12 <= n10) {
                    int n13 = this.parseIntFromArray(this.tmpBuffer, n11, true);
                    n11 += 4;
                    if (n13 > n5) {
                        n5 = n13;
                    }
                    nArray[n9] = n13;
                    ++n12;
                    ++n9;
                }
                n6 -= n10;
            }
            this.currentTrack.sampleSizeArray = nArray;
            this.currentTrack.media.maxSampleSize = n5;
            this.skip(this.stream, n3);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSZ atom");
        }
    }

    private void parseSTTS(int n2) throws BadHeaderException {
        if (this.debug2) {
            System.out.println("parseSTTS: " + n2);
        }
        try {
            int n3;
            if (n2 < 8) {
                throw new BadHeaderException("stts atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int n4 = this.readInt(this.stream);
            if (this.debug2) {
                System.out.println("numEntries is " + n4);
            }
            if ((n3 = n2 - 8 - n4 * 8) < 0) {
                throw new BadHeaderException("stts atom: inconsistent number_of_entries field");
            }
            int n5 = 0;
            double d2 = 1.0 / (double)this.currentTrack.mediaTimeScale;
            if (n4 == 1) {
                n5 = this.readInt(this.stream);
                this.currentTrack.durationOfSamples = (double)this.readInt(this.stream) * d2;
            } else {
                int[] nArray = new int[n4];
                double[] dArray = new double[n4];
                nArray[0] = this.readInt(this.stream);
                n5 += nArray[0];
                dArray[0] = (double)this.readInt(this.stream) * d2 * (double)nArray[0];
                int n6 = n4 - 1;
                int n7 = 2;
                int n8 = this.tmpIntBufferSize / n7;
                int n9 = 1;
                while (n6 > 0) {
                    int n10 = n6 > n8 ? n8 : n6;
                    this.readBytes(this.stream, this.tmpBuffer, n10 * n7 * 4);
                    int n11 = 0;
                    int n12 = 1;
                    while (n12 <= n10) {
                        nArray[n9] = this.parseIntFromArray(this.tmpBuffer, n11, true);
                        int n13 = this.parseIntFromArray(this.tmpBuffer, n11 += 4, true);
                        n11 += 4;
                        int n14 = n9;
                        dArray[n14] = dArray[n14] + ((double)n13 * d2 * (double)nArray[n9] + dArray[n9 - 1]);
                        nArray[n9] = n5 += nArray[n9];
                        ++n12;
                        ++n9;
                    }
                    n6 -= n10;
                }
                this.currentTrack.timeToSampleIndices = nArray;
                this.currentTrack.cumulativeDurationOfSamples = dArray;
            }
            if (this.currentTrack.numberOfSamples == 0) {
                this.currentTrack.numberOfSamples = n5;
            }
            this.skip(this.stream, n3);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STTS atom");
        }
    }

    private void parseTKHD(int n2) throws BadHeaderException {
        try {
            if (n2 != 84) {
                throw new BadHeaderException("mvhd atom: header size is incorrect");
            }
            int n3 = this.readInt(this.stream);
            this.currentTrack.flag = n3 & 0xFFFFFF;
            this.skip(this.stream, 8);
            this.currentTrack.id = this.readInt(this.stream);
            this.skip(this.stream, 4);
            int n4 = this.readInt(this.stream);
            this.currentTrack.duration = new Time((double)n4 / (double)this.movieHeader.timeScale);
            this.skip(this.stream, n2 - 4 - 8 - 4 - 4 - 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past TKHD atom");
        }
    }

    private boolean parseTRAK(int n2) throws BadHeaderException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n3 = n2;
            int n4 = this.readInt(this.stream);
            String string = this.readString(this.stream);
            if (n4 < 8) {
                throw new BadHeaderException(String.valueOf(string) + ": Bad Atom size " + n4);
            }
            if (!string.equals("tkhd")) {
                throw new BadHeaderException("Expected tkhd atom but got " + string);
            }
            this.parseTKHD(n4 - 8);
            n3 -= n4;
            while (n3 > 0) {
                n4 = this.readInt(this.stream);
                string = this.readString(this.stream);
                if (string.equals("mdia")) {
                    bl2 = this.parseMDIA(n4 - 8);
                    bl = true;
                } else if (string.equals("tref")) {
                    this.parseTREF(n4 - 8);
                } else {
                    this.skipAtom(String.valueOf(string) + " [atom in trak: not implemented]", n4 - 8);
                }
                n3 -= n4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past TRAK atom");
        }
        if (!bl) {
            throw new BadHeaderException("mdia atom not present in trak atom container");
        }
        if (bl2 && this.currentTrack.media == null) {
            bl2 = false;
        }
        return bl2;
    }

    private void parseTREF(int n2) throws BadHeaderException {
        try {
            int n3 = this.readInt(this.stream);
            n2 -= 4;
            String string = this.readString(this.stream);
            n2 -= 4;
            if (string.equalsIgnoreCase(HINT)) {
                this.currentTrack.trackIdOfTrackBeingHinted = this.readInt(this.stream);
                n2 -= 4;
            }
            this.skip(this.stream, n2);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past HDLR atom");
        }
    }

    private Video parseVideoSampleData(String string, int n2) throws IOException, BadHeaderException {
        this.skip(this.stream, 2);
        this.skip(this.stream, 16);
        Video video = new Video();
        video.encoding = string;
        video.width = this.readShort(this.stream);
        video.height = this.readShort(this.stream);
        this.skip(this.stream, 14);
        this.skip(this.stream, 32);
        video.pixelDepth = this.readShort(this.stream);
        video.colorTableID = this.readShort(this.stream);
        int n3 = 0;
        if (video.colorTableID == 0) {
            n3 = this.readInt(this.stream);
            this.skip(this.stream, n3 - 4);
        }
        this.skip(this.stream, n2 - 2 - 70 - -n3);
        return video;
    }

    private void readHeader() throws IOException, BadHeaderException {
        while (this.parseAtom()) {
        }
        if (!this.moovAtomPresent) {
            throw new BadHeaderException("moov atom not present");
        }
        if (!this.mdatAtomPresent) {
            throw new BadHeaderException("mdat atom not present");
        }
        int n2 = 0;
        while (n2 < this.numSupportedTracks) {
            TrakList trakList = this.trakList[n2];
            if (trakList.buildSyncTable()) {
                this.keyFrameTrack = n2;
            }
            trakList.buildSamplePerChunkTable();
            if (!trakList.trackType.equals(AUDIO)) {
                float f2;
                trakList.buildSampleOffsetTable();
                trakList.buildStartTimeAndDurationTable();
                trakList.media.frameRate = f2 = (float)((double)trakList.numberOfSamples / trakList.duration.getSeconds());
            }
            trakList.buildCumulativeSamplePerChunkTable();
            trakList.media.createFormat();
            ++n2;
        }
    }

    public Time setPosition(Time time, int n2) {
        int n3;
        int n4;
        double d2 = time.getSeconds();
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if ((n4 = this.keyFrameTrack) != -1 && this.tracks[this.keyFrameTrack].isEnabled() || (n4 = this.hintAudioTrackNum) != -1 && this.tracks[this.hintAudioTrackNum].isEnabled()) {
            TrakList trakList = this.trakList[n4];
            int n5 = trakList.time2Index(d2);
            if (n5 < 0) {
                ((MediaTrack)this.tracks[n4]).setSampleIndex(trakList.numberOfSamples + 1);
            } else {
                double d3;
                if (n4 == this.keyFrameTrack) {
                    if (n5 >= trakList.syncSampleMapping.length) {
                        n5 = trakList.syncSampleMapping.length - 1;
                    }
                    if (trakList.syncSampleMapping != null) {
                        n3 = trakList.syncSampleMapping[n5];
                        d2 = d3 = trakList.index2TimeAndDuration((int)n3).startTime;
                    } else {
                        n3 = n5;
                    }
                } else {
                    n3 = n5;
                    d2 = d3 = trakList.index2TimeAndDuration((int)n3).startTime;
                }
                ((MediaTrack)this.tracks[n4]).setSampleIndex(n3);
            }
        }
        int n6 = 0;
        while (n6 < this.numSupportedTracks) {
            if (n6 != n4 && this.tracks[n6].isEnabled()) {
                TrakList trakList = this.trakList[n6];
                n3 = trakList.time2Index(d2);
                if (trakList.trackType.equals(VIDEO) || trakList.trackType.equals(HINT) && this.tracks[n6] instanceof HintVideoTrack) {
                    if (n3 < 0) {
                        ((MediaTrack)this.tracks[n6]).setSampleIndex(trakList.numberOfSamples + 1);
                    } else {
                        int n7 = trakList.syncSampleMapping != null ? trakList.syncSampleMapping[n3] : n3;
                        ((MediaTrack)this.tracks[n6]).setSampleIndex(n7);
                    }
                } else if (n3 < 0) {
                    ((MediaTrack)this.tracks[n6]).setChunkNumber(trakList.numberOfChunks + 1);
                } else {
                    ((MediaTrack)this.tracks[n6]).setSampleIndex(n3);
                    int n8 = trakList.index2Chunk(n3);
                    int n9 = n8 != 0 ? (trakList.constantSamplesPerChunk == -1 ? n3 - trakList.samplesPerChunk[n8 - 1] : n3 - n8 * trakList.constantSamplesPerChunk) : n3;
                    ((AudioTrack)this.tracks[n6]).setChunkNumberAndSampleOffset(n8, n9);
                }
            }
            ++n6;
        }
        if (this.cacheStream != null) {
            QuicktimeParser quicktimeParser = this;
            synchronized (quicktimeParser) {
                this.cacheStream.abortRead();
            }
        }
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set(d2);
        }
        return this.mediaTime;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        this.stream = (PullSourceStream)this.streams[0];
        this.seekableStream = (Seekable)((Object)this.streams[0]);
    }

    private void skipAtom(String string, int n2) throws IOException {
        if (this.debug2) {
            System.out.println("skip unsupported atom " + string);
        }
        this.skip(this.stream, n2);
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return this.seekable;
    }

    private class MovieHeader {
        int timeScale;
        Time duration = Duration.DURATION_UNKNOWN;
        long mdatStart;
        long mdatSize;

        MovieHeader() {
        }
    }

    private abstract class Media {
        String encoding;
        int maxSampleSize;
        float frameRate;

        Media() {
        }

        abstract Format createFormat();
    }

    private class Audio
    extends Media {
        int channels;
        int bitsPerSample;
        int sampleRate;
        AudioFormat format = null;
        int frameSizeInBits;
        int samplesPerBlock = 1;

        Audio() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String string = null;
            boolean bl = true;
            boolean bl2 = true;
            if (this.encoding.equals("ulaw") || this.encoding.equals("alaw")) {
                this.bitsPerSample = 8;
            }
            this.frameSizeInBits = this.channels * this.bitsPerSample;
            if (this.encoding.equals("ulaw")) {
                string = "ULAW";
                bl = false;
            } else if (this.encoding.equals("alaw")) {
                string = "alaw";
                bl = false;
            } else if (this.encoding.equals("twos")) {
                string = "LINEAR";
            } else if (this.encoding.equals("ima4")) {
                string = "ima4";
                this.samplesPerBlock = 64;
                this.frameSizeInBits = 34 * this.channels * 8;
            } else if (this.encoding.equals("raw ")) {
                string = "LINEAR";
                bl = false;
            } else if (this.encoding.equals("agsm")) {
                string = "gsm";
                this.samplesPerBlock = 33;
                this.frameSizeInBits = 264;
            } else {
                string = this.encoding.equals("mac3") ? "MAC3" : (this.encoding.equals("mac6") ? "MAC6" : this.encoding);
            }
            this.format = new AudioFormat(string, this.sampleRate, this.bitsPerSample, this.channels, bl2 ? 1 : 0, bl ? 1 : 0, this.frameSizeInBits, -1.0, Format.byteArray);
            return this.format;
        }

        public String toString() {
            String string = "Audio: " + this.format + "\n";
            string = String.valueOf(string) + "encoding is " + this.encoding + "\n";
            string = String.valueOf(string) + "Number of channels " + this.channels + "\n";
            string = String.valueOf(string) + "Bits per sample " + this.bitsPerSample + "\n";
            string = String.valueOf(string) + "sampleRate " + this.sampleRate + "\n";
            return string;
        }
    }

    private class Video
    extends Media {
        int width;
        int height;
        int pixelDepth;
        int colorTableID;
        VideoFormat format;

        Video() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            if (this.encoding.toLowerCase().startsWith("raw")) {
                this.encoding = "rgb";
                if (this.pixelDepth == 24) {
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 1, 2, 3, 3, this.width * 3, 0, 0);
                } else if (this.pixelDepth == 16) {
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 31744, 992, 31, 2, this.width * 2, 0, 0);
                } else if (this.pixelDepth == 32) {
                    this.encoding = "rgb";
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 2, 3, 4, 4, this.width * 4, 0, 0);
                }
            } else {
                this.format = this.encoding.toLowerCase().equals("8bps") ? new VideoFormat(this.encoding, new Dimension(this.width, this.height), this.maxSampleSize, Format.byteArray, this.frameRate) : (this.encoding.toLowerCase().equals("yuv2") ? new YUVFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, 96, this.width * 2, this.width * 2, 0, 1, 3) : new VideoFormat(this.encoding, new Dimension(this.width, this.height), this.maxSampleSize, Format.byteArray, this.frameRate));
            }
            return this.format;
        }

        public String toString() {
            String string = "Video: " + this.format + "\n";
            string = String.valueOf(string) + "encoding is " + this.encoding + "\n";
            string = String.valueOf(string) + "pixelDepth is " + this.pixelDepth + "\n";
            return string;
        }
    }

    private class Hint
    extends Media {
        Format format = null;

        Hint() {
        }

        Format createFormat() {
            return this.format;
        }
    }

    private class TrakList {
        int flag;
        int id;
        Time duration = Duration.DURATION_UNKNOWN;
        int mediaTimeScale;
        Time mediaDuration = Duration.DURATION_UNKNOWN;
        String trackType;
        int numberOfSamples;
        int sampleSize = 0;
        int[] sampleSizeArray;
        boolean supported;
        Media media;
        int numberOfChunks;
        int[] chunkOffsets = new int[0];
        int[] compactSamplesChunkNum = new int[0];
        int[] compactSamplesPerChunk = new int[0];
        int constantSamplesPerChunk = -1;
        int[] samplesPerChunk;
        double durationOfSamples = -1.0;
        int[] timeToSampleIndices = new int[0];
        double[] cumulativeDurationOfSamples = new double[0];
        double[] startTimeOfSampleArray = new double[0];
        double[] durationOfSampleArray = new double[0];
        long[] sampleOffsetTable;
        int[] syncSamples;
        int[] syncSampleMapping;
        TimeAndDuration timeAndDuration = new TimeAndDuration();
        int trackIdOfTrackBeingHinted = -1;
        int indexOfTrackBeingHinted = -1;
        int maxPacketSize = -1;

        TrakList() {
        }

        void buildCumulativeSamplePerChunkTable() {
            if (this.constantSamplesPerChunk == -1) {
                int n2 = 1;
                while (n2 < this.numberOfChunks) {
                    int n3 = n2;
                    this.samplesPerChunk[n3] = this.samplesPerChunk[n3] + this.samplesPerChunk[n2 - 1];
                    ++n2;
                }
            }
        }

        void buildSampleOffsetTable() {
            this.sampleOffsetTable = new long[this.numberOfSamples];
            int n2 = 0;
            if (this.sampleSize != 0) {
                if (this.constantSamplesPerChunk != -1) {
                    int n3 = 0;
                    while (n3 < this.numberOfChunks) {
                        long l2 = this.chunkOffsets[n3];
                        int n4 = 0;
                        while (n4 < this.constantSamplesPerChunk) {
                            this.sampleOffsetTable[n2++] = l2 + (long)(n4 * this.sampleSize);
                            ++n4;
                        }
                        ++n3;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this.numberOfChunks) {
                        long l3 = this.chunkOffsets[n5];
                        int n6 = 0;
                        while (n6 < this.samplesPerChunk[n5]) {
                            this.sampleOffsetTable[n2++] = l3 + (long)(n6 * this.sampleSize);
                            ++n6;
                        }
                        ++n5;
                    }
                }
            } else {
                int n7 = 0;
                if (this.constantSamplesPerChunk != -1) {
                    n7 = this.constantSamplesPerChunk;
                }
                int n8 = 0;
                while (n8 < this.numberOfChunks) {
                    long l4;
                    this.sampleOffsetTable[n2] = l4 = (long)this.chunkOffsets[n8];
                    ++n2;
                    if (this.constantSamplesPerChunk == -1) {
                        n7 = this.samplesPerChunk[n8];
                    }
                    int n9 = 1;
                    while (n9 < n7) {
                        this.sampleOffsetTable[n2] = this.sampleOffsetTable[n2 - 1] + (long)this.sampleSizeArray[n2 - 1];
                        ++n2;
                        ++n9;
                    }
                    ++n8;
                }
            }
        }

        void buildSamplePerChunkTable() {
            if (this.numberOfChunks <= 0) {
                return;
            }
            if (this.compactSamplesPerChunk.length == 1) {
                this.constantSamplesPerChunk = this.compactSamplesPerChunk[0];
                return;
            }
            this.samplesPerChunk = new int[this.numberOfChunks];
            int n2 = 1;
            int n3 = 0;
            while (n3 < this.compactSamplesChunkNum.length - 1) {
                int n4 = this.compactSamplesPerChunk[n3];
                while (n2 != this.compactSamplesChunkNum[n3 + 1]) {
                    this.samplesPerChunk[n2 - 1] = n4;
                    ++n2;
                }
                ++n3;
            }
            while (n2 <= this.numberOfChunks) {
                this.samplesPerChunk[n2 - 1] = this.compactSamplesPerChunk[n3];
                ++n2;
            }
        }

        void buildStartTimeAndDurationTable() {
            int n2;
            if (QuicktimeParser.this.debug2) {
                System.out.println("buildStartTimeAndDurationTable");
            }
            if ((n2 = this.timeToSampleIndices.length) == 0) {
                return;
            }
            this.startTimeOfSampleArray = new double[this.numberOfSamples];
            this.durationOfSampleArray = new double[this.numberOfSamples];
            int n3 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = this.timeToSampleIndices[n5];
                double d4 = (this.cumulativeDurationOfSamples[n5] - d2) / (double)(n6 - n3);
                int n7 = 0;
                while (n7 < n6 - n3) {
                    this.startTimeOfSampleArray[n4] = d3;
                    this.durationOfSampleArray[n4] = d4;
                    ++n4;
                    d3 += d4;
                    ++n7;
                }
                n3 = n6;
                d2 = this.cumulativeDurationOfSamples[n5];
                ++n5;
            }
        }

        boolean buildSyncTable() {
            int n2;
            int n3;
            if (this.syncSamples == null) {
                return false;
            }
            if (!this.trackType.equals(QuicktimeParser.VIDEO)) {
                return false;
            }
            int n4 = this.syncSamples.length;
            if (n4 == this.numberOfSamples) {
                this.syncSamples = null;
                return false;
            }
            this.syncSampleMapping = new int[this.numberOfSamples];
            int n5 = 0;
            if (this.syncSamples[0] != 1) {
                this.syncSampleMapping[0] = 0;
                n3 = 0;
            } else {
                this.syncSampleMapping[0] = 0;
                n3 = 0;
                ++n5;
            }
            while (n5 < this.syncSamples.length) {
                this.syncSampleMapping[n2] = n2 = this.syncSamples[n5] - 1;
                int n6 = n2 - n3 - 1;
                int n7 = n3 + 1;
                while (n7 < n2) {
                    this.syncSampleMapping[n7] = n3;
                    ++n7;
                }
                n3 = n2;
                ++n5;
            }
            n2 = this.syncSamples[this.syncSamples.length - 1] - 1;
            n5 = n2 + 1;
            while (n5 < this.numberOfSamples) {
                this.syncSampleMapping[n5] = n2;
                ++n5;
            }
            return true;
        }

        int index2Chunk(int n2) {
            int n3;
            if (this.constantSamplesPerChunk != -1) {
                int n4 = n2 / this.constantSamplesPerChunk;
                return n4;
            }
            int n5 = this.samplesPerChunk.length;
            int n6 = (int)((float)(n2 / this.numberOfSamples) * (float)n5);
            if (n6 == n5) {
                --n6;
            }
            if (this.samplesPerChunk[n6] < n2) {
                int n7 = n6 + 1;
                while (n7 < n5) {
                    if (this.samplesPerChunk[n7] >= n2) break;
                    ++n7;
                }
                n3 = n7;
            } else if (this.samplesPerChunk[n6] > n2) {
                int n8 = n6 - 1;
                while (n8 >= 0) {
                    if (this.samplesPerChunk[n8] < n2) break;
                    --n8;
                }
                n3 = n8 + 1;
            } else {
                n3 = n6;
            }
            return n3;
        }

        long index2Offset(int n2) {
            int n3;
            int n4;
            int n5 = this.index2Chunk(n2 + 1);
            if (QuicktimeParser.this.debug) {
                System.out.println(" index2Chunk chunk is " + n5);
            }
            if (n5 >= this.chunkOffsets.length) {
                return -2L;
            }
            long l2 = this.chunkOffsets[n5];
            if (QuicktimeParser.this.debug1) {
                System.out.println("index2Offset: index, chunk, chunkOffset " + n2 + " : " + n5 + " : " + l2);
            }
            if (this.constantSamplesPerChunk != -1) {
                n4 = n2 % this.constantSamplesPerChunk;
                n3 = n5 * this.constantSamplesPerChunk;
            } else {
                n3 = n5 == 0 ? 0 : this.samplesPerChunk[n5 - 1];
                n4 = n2 - n3;
                if (QuicktimeParser.this.debug1) {
                    System.out.println("index, start, sampleNumInChunk " + n2 + " : " + n3 + " : " + n4);
                    System.out.println("sampleSize is " + this.sampleSize);
                }
            }
            if (QuicktimeParser.this.debug1) {
                System.out.println("sampleSize is " + this.sampleSize);
            }
            if (this.sampleSize != 0) {
                l2 += (long)(this.sampleSize * n4);
            } else {
                int n6 = 0;
                while (n6 < n4) {
                    l2 += (long)this.sampleSizeArray[n3++];
                    ++n6;
                }
            }
            return l2;
        }

        TimeAndDuration index2TimeAndDuration(int n2) {
            double d2 = 0.0;
            double d3 = 0.0;
            try {
                if (n2 < 0) {
                    n2 = 0;
                } else if (n2 >= this.numberOfSamples) {
                    n2 = this.numberOfSamples - 1;
                }
                int n3 = this.timeToSampleIndices.length;
                if (n3 == 0) {
                    d3 = this.durationOfSamples;
                    d2 = d3 * (double)n2;
                } else if (this.startTimeOfSampleArray.length >= n2) {
                    d3 = this.durationOfSampleArray[n2];
                    d2 = this.startTimeOfSampleArray[n2];
                } else {
                    float f2 = (float)n3 / (float)this.numberOfSamples;
                    int n4 = (int)((float)n2 * f2);
                    d3 = 0.0;
                    d2 = 0.0;
                }
            }
            catch (Throwable throwable) {}
            TimeAndDuration timeAndDuration = this.timeAndDuration;
            synchronized (timeAndDuration) {
                this.timeAndDuration.startTime = d2;
                this.timeAndDuration.duration = d3;
                TimeAndDuration timeAndDuration2 = this.timeAndDuration;
                Object var8_9 = null;
                return timeAndDuration2;
            }
        }

        int time2Index(double d2) {
            double d3;
            int n2;
            int n3;
            int n4;
            int n5;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if ((n5 = this.timeToSampleIndices.length) == 0) {
                int n6 = (int)(d2 / this.mediaDuration.getSeconds() * (double)this.numberOfSamples + 0.5);
                if (n6 >= this.numberOfSamples) {
                    return -1;
                }
                return n6;
            }
            int n7 = (int)(d2 / this.mediaDuration.getSeconds() * (double)n5);
            if (n7 == n5) {
                --n7;
            }
            if (n7 >= this.cumulativeDurationOfSamples.length) {
                return -1;
            }
            if (this.cumulativeDurationOfSamples[n7] < d2) {
                int n8 = n7 + 1;
                while (n8 < n5) {
                    if (this.cumulativeDurationOfSamples[n8] >= d2) break;
                    ++n8;
                }
                n4 = n8;
            } else if (this.cumulativeDurationOfSamples[n7] > d2) {
                int n9 = n7 - 1;
                while (n9 >= 0) {
                    if (this.cumulativeDurationOfSamples[n9] < d2) break;
                    --n9;
                }
                n4 = n9 + 1;
            } else {
                n4 = n7;
            }
            if (n4 == n5) {
                --n4;
            }
            double d4 = this.cumulativeDurationOfSamples[n4] - d2;
            if (n4 == 0) {
                n2 = n3 = this.timeToSampleIndices[n4];
                d3 = this.cumulativeDurationOfSamples[n4];
            } else {
                n3 = this.timeToSampleIndices[n4];
                n2 = n3 - this.timeToSampleIndices[n4 - 1];
                d3 = this.cumulativeDurationOfSamples[n4] - this.cumulativeDurationOfSamples[n4 - 1];
            }
            double d5 = d4 / d3;
            n3 = (int)((double)n3 - (double)n2 * d5);
            return n3;
        }

        public String toString() {
            String string = "";
            string = String.valueOf(string) + "track id is " + this.id + "\n";
            string = String.valueOf(string) + "duration itrack is " + this.duration.getSeconds() + "\n";
            string = String.valueOf(string) + "duration of media is " + this.mediaDuration.getSeconds() + "\n";
            string = String.valueOf(string) + "trackType is " + this.trackType + "\n";
            string = String.valueOf(string) + this.media;
            return string;
        }
    }

    private abstract class MediaTrack
    implements Track {
        TrakList trakInfo;
        boolean enabled = true;
        int numBuffers = 4;
        Format format;
        long sequenceNumber = 0L;
        int chunkNumber = 0;
        int sampleIndex = 0;
        int useChunkNumber = 0;
        int useSampleIndex = 0;
        QuicktimeParser parser = QuicktimeParser.this;
        CachedStream cacheStream = QuicktimeParser.access$3(this.parser);
        int constantSamplesPerChunk;
        int[] samplesPerChunk;
        protected TrackListener listener;

        MediaTrack(TrakList trakList) {
            this.trakInfo = trakList;
            if (trakList != null) {
                this.enabled = (trakList.flag & 1) != 0;
                this.format = trakList.media.createFormat();
                this.samplesPerChunk = trakList.samplesPerChunk;
                this.constantSamplesPerChunk = trakList.constantSamplesPerChunk;
            }
        }

        abstract void doReadFrame(Buffer var1);

        public Time getDuration() {
            return this.trakInfo.duration;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n2) {
            return Track.TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        public void readFrame(Buffer buffer) {
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            MediaTrack mediaTrack = this;
            synchronized (mediaTrack) {
                this.useChunkNumber = this.chunkNumber;
                this.useSampleIndex = this.sampleIndex;
            }
            if (this.useChunkNumber >= this.trakInfo.numberOfChunks || this.useChunkNumber < 0) {
                buffer.setEOM(true);
                return;
            }
            buffer.setFormat(this.format);
            this.doReadFrame(buffer);
        }

        synchronized void setChunkNumber(int n2) {
            this.chunkNumber = n2;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        synchronized void setSampleIndex(int n2) {
            this.sampleIndex = n2;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }
    }

    private class AudioTrack
    extends MediaTrack {
        String encoding;
        int channels;
        int sampleOffsetInChunk = -1;
        int useSampleOffsetInChunk = 0;
        int frameSizeInBytes;
        int samplesPerBlock;
        int sampleRate;

        AudioTrack(TrakList trakList) {
            super(trakList);
            if (trakList != null) {
                this.channels = ((Audio)trakList.media).channels;
                this.encoding = trakList.media.encoding;
                this.frameSizeInBytes = ((Audio)trakList.media).frameSizeInBits / 8;
                this.samplesPerBlock = ((Audio)trakList.media).samplesPerBlock;
                this.sampleRate = ((Audio)trakList.media).sampleRate;
            }
        }

        AudioTrack(TrakList trakList, int n2, String string, int n3, int n4, int n5) {
            super(trakList);
            this.channels = n2;
            this.encoding = string;
            this.frameSizeInBytes = n3;
            this.samplesPerBlock = n4;
            this.sampleRate = n5;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] byArray;
            int n2;
            int n3;
            long l2;
            int n4;
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                if (this.sampleOffsetInChunk == -1) {
                    this.useSampleOffsetInChunk = 0;
                } else {
                    this.useSampleOffsetInChunk = this.sampleOffsetInChunk;
                    this.sampleOffsetInChunk = -1;
                }
            }
            if (this.constantSamplesPerChunk != -1) {
                n4 = this.constantSamplesPerChunk;
                l2 = this.constantSamplesPerChunk * this.useChunkNumber;
            } else if (this.useChunkNumber > 0) {
                n4 = this.samplesPerChunk[this.useChunkNumber] - this.samplesPerChunk[this.useChunkNumber - 1];
                l2 = this.samplesPerChunk[this.useChunkNumber];
            } else {
                n4 = this.samplesPerChunk[this.useChunkNumber];
                l2 = 0L;
            }
            if (this.samplesPerBlock > 1) {
                n3 = this.useSampleOffsetInChunk / this.samplesPerBlock;
                this.useSampleOffsetInChunk = n3 * this.samplesPerBlock;
                n2 = this.frameSizeInBytes * n3;
            } else {
                n2 = this.useSampleOffsetInChunk * this.frameSizeInBytes;
            }
            l2 += (long)this.useSampleOffsetInChunk;
            n3 = this.encoding.equals("ima4") ? n4 / this.samplesPerBlock * 34 * this.channels : (this.encoding.equals("agsm") ? n4 / 160 * this.samplesPerBlock : (n4 -= this.useSampleOffsetInChunk) * ((AudioFormat)this.format).getSampleSizeInBits() / 8 * this.channels);
            Object object = buffer.getData();
            if (object == null || !(object instanceof byte[]) || ((byte[])object).length < n3) {
                byArray = new byte[n3];
                buffer.setData(byArray);
            } else {
                byArray = (byte[])object;
            }
            try {
                int n5;
                Object object2 = QuicktimeParser.this.seekSync;
                synchronized (object2) {
                    long l3;
                    int n6 = this.trakInfo.chunkOffsets[this.useChunkNumber];
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(n6 + n2, n3)) {
                        this.listener.readHasBlocked(this);
                    }
                    if ((l3 = QuicktimeParser.this.seekableStream.seek(n6 + n2)) == -2L) {
                        buffer.setDiscard(true);
                        return;
                    }
                    n5 = this.parser.readBytes(QuicktimeParser.this.stream, byArray, n3);
                    if (n5 == -2) {
                        buffer.setDiscard(true);
                        return;
                    }
                }
                buffer.setLength(n5);
                buffer.setSequenceNumber(++this.sequenceNumber);
                if (this.sampleRate > 0) {
                    long l4 = l2 * 1000000000L / (long)this.sampleRate;
                    buffer.setTimeStamp(l4);
                    buffer.setDuration(-1L);
                }
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            AudioTrack audioTrack2 = this;
            synchronized (audioTrack2) {
                if (this.chunkNumber != this.useChunkNumber) return;
                ++this.chunkNumber;
                return;
            }
        }

        synchronized void setChunkNumberAndSampleOffset(int n2, int n3) {
            this.chunkNumber = n2;
            this.sampleOffsetInChunk = n3;
        }
    }

    private class VideoTrack
    extends MediaTrack {
        int needBufferSize;
        boolean variableSampleSize = true;

        VideoTrack(TrakList trakList) {
            super(trakList);
            if (trakList != null && trakList.sampleSize != 0) {
                this.variableSampleSize = false;
                this.needBufferSize = trakList.sampleSize;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] byArray;
            if (this.useSampleIndex >= this.trakInfo.numberOfSamples) {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
            if (this.variableSampleSize) {
                if (this.useSampleIndex >= this.trakInfo.sampleSizeArray.length) {
                    buffer.setLength(0);
                    buffer.setEOM(true);
                    return;
                }
                this.needBufferSize = this.trakInfo.sampleSizeArray[this.useSampleIndex];
            }
            long l2 = this.trakInfo.sampleOffsetTable[this.useSampleIndex];
            Object object = buffer.getData();
            if (object == null || !(object instanceof byte[]) || ((byte[])object).length < this.needBufferSize) {
                byArray = new byte[this.needBufferSize];
                buffer.setData(byArray);
            } else {
                byArray = (byte[])object;
            }
            try {
                int n2;
                Object object2 = QuicktimeParser.this.seekSync;
                synchronized (object2) {
                    long l3;
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(l2, this.needBufferSize)) {
                        this.listener.readHasBlocked(this);
                    }
                    if ((l3 = QuicktimeParser.this.seekableStream.seek(l2)) == -2L) {
                        buffer.setDiscard(true);
                        return;
                    }
                    n2 = this.parser.readBytes(QuicktimeParser.this.stream, byArray, this.needBufferSize);
                    if (n2 == -2) {
                        buffer.setDiscard(true);
                        return;
                    }
                }
                buffer.setLength(n2);
                object2 = this.trakInfo.syncSampleMapping;
                boolean bl = true;
                if (object2 != null) {
                    boolean bl2 = bl = object2[this.useSampleIndex] == this.useSampleIndex;
                }
                if (bl) {
                    buffer.setFlags(buffer.getFlags() | 0x10);
                }
                buffer.setSequenceNumber(++this.sequenceNumber);
                TimeAndDuration timeAndDuration = this.trakInfo.index2TimeAndDuration(this.useSampleIndex);
                buffer.setTimeStamp((long)(timeAndDuration.startTime * 1.0E9));
                buffer.setDuration((long)(timeAndDuration.duration * 1.0E9));
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            VideoTrack videoTrack = this;
            synchronized (videoTrack) {
                if (this.sampleIndex != this.useSampleIndex) return;
                ++this.sampleIndex;
                return;
            }
        }

        public Time mapFrameToTime(int n2) {
            if (n2 < 0 || n2 >= this.trakInfo.numberOfSamples) {
                return Track.TIME_UNKNOWN;
            }
            double d2 = (float)n2 / ((Video)this.trakInfo.media).frameRate;
            return new Time(d2);
        }

        public int mapTimeToFrame(Time time) {
            double d2 = time.getSeconds();
            if (d2 < 0.0) {
                return Integer.MAX_VALUE;
            }
            int n2 = this.trakInfo.time2Index(d2);
            if (n2 < 0) {
                return this.trakInfo.numberOfSamples - 1;
            }
            return n2;
        }
    }

    private class HintAudioTrack
    extends AudioTrack {
        int hintSampleSize;
        int indexOfTrackBeingHinted;
        int maxPacketSize;
        int currentPacketNumber;
        int numPacketsInSample;
        long offsetToStartOfPacketInfo;
        TrakList sampleTrakInfo;
        boolean variableSampleSize;

        HintAudioTrack(TrakList trakList, int n2, String string, int n3, int n4, int n5) {
            super(trakList, n2, string, n3, n4, n5);
            this.indexOfTrackBeingHinted = this.trakInfo.indexOfTrackBeingHinted;
            this.currentPacketNumber = 0;
            this.numPacketsInSample = -1;
            this.offsetToStartOfPacketInfo = -1L;
            this.variableSampleSize = true;
            this.format = ((Hint)trakList.media).format;
            this.maxPacketSize = trakList.maxPacketSize;
            if (this.indexOfTrackBeingHinted >= 0) {
                this.sampleTrakInfo = QuicktimeParser.this.trakList[this.indexOfTrackBeingHinted];
            } else if (QuicktimeParser.this.debug) {
                System.out.println("sampleTrakInfo is not set " + this.indexOfTrackBeingHinted);
            }
            if (trakList.sampleSize != 0) {
                this.variableSampleSize = false;
                this.hintSampleSize = trakList.sampleSize;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] byArray;
            Object object;
            if (QuicktimeParser.this.debug1) {
                System.out.println("audio: hint doReadFrame: " + this.useChunkNumber + " : " + this.sampleOffsetInChunk);
            }
            boolean bl = false;
            if (this.indexOfTrackBeingHinted < 0) {
                buffer.setDiscard(true);
                return;
            }
            int n2 = 0;
            if (this.variableSampleSize) {
                this.hintSampleSize = this.useSampleIndex >= this.trakInfo.sampleSizeArray.length ? this.trakInfo.sampleSizeArray[this.trakInfo.sampleSizeArray.length - 1] : this.trakInfo.sampleSizeArray[this.useSampleIndex];
            }
            int n3 = this.hintSampleSize;
            if (QuicktimeParser.this.debug1) {
                System.out.println("hintSampleSize is " + this.hintSampleSize);
            }
            if ((object = buffer.getData()) == null || !(object instanceof byte[]) || ((byte[])object).length < this.maxPacketSize) {
                byArray = new byte[this.maxPacketSize];
                buffer.setData(byArray);
            } else {
                byArray = (byte[])object;
            }
            try {
                int n4;
                int n5;
                long l2;
                Object object2 = QuicktimeParser.this.seekSync;
                synchronized (object2) {
                    int n6;
                    boolean bl2;
                    long l3;
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        this.currentPacketNumber = 0;
                        this.numPacketsInSample = -1;
                        this.offsetToStartOfPacketInfo = -1L;
                        return;
                    }
                    l2 = this.trakInfo.index2Offset(this.useChunkNumber);
                    if (QuicktimeParser.this.debug) {
                        System.out.println("audio: Calling index2Offset on hint track with arg " + this.useChunkNumber);
                        System.out.println("offset is " + l2);
                    }
                    if (l2 == -2L) {
                        buffer.setLength(0);
                        buffer.setEOM(true);
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(l2, this.hintSampleSize)) {
                        this.listener.readHasBlocked(this);
                    }
                    if (QuicktimeParser.this.debug1) {
                        System.out.println("currentPacketNumber is " + this.currentPacketNumber);
                    }
                    if (this.offsetToStartOfPacketInfo < 0L) {
                        if (QuicktimeParser.this.debug1) {
                            System.out.println("NEW SEEK");
                        }
                        if ((l3 = QuicktimeParser.this.seekableStream.seek(l2)) == -2L) {
                            buffer.setDiscard(true);
                            return;
                        }
                        this.numPacketsInSample = this.parser.readShort(QuicktimeParser.this.stream);
                        if (QuicktimeParser.this.debug) {
                            System.out.println("num packets in sample " + this.numPacketsInSample);
                        }
                        if (this.numPacketsInSample < 1) {
                            buffer.setDiscard(true);
                            return;
                        }
                        n3 -= 2;
                        this.parser.readShort(QuicktimeParser.this.stream);
                        n3 -= 2;
                    } else {
                        l3 = QuicktimeParser.this.seekableStream.seek(this.offsetToStartOfPacketInfo);
                        if (l3 == -2L) {
                            buffer.setDiscard(true);
                            return;
                        }
                    }
                    int n7 = this.parser.readInt(QuicktimeParser.this.stream);
                    n3 -= 4;
                    int n8 = this.parser.readShort(QuicktimeParser.this.stream);
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtpHeaderInfo is " + Integer.toHexString(n8));
                    }
                    bl = (n8 & 0x80) > 0;
                    n3 -= 2;
                    n5 = this.parser.readShort(QuicktimeParser.this.stream);
                    n3 -= 2;
                    boolean bl3 = (n8 & 0x2000) > 0;
                    boolean bl4 = (n8 & 0x1000) > 0;
                    int n9 = this.parser.readShort(QuicktimeParser.this.stream);
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtp marker present? " + bl);
                        System.out.println("rtp payload type " + (n8 & 0x7F));
                        System.out.println("padding? " + bl3);
                        System.out.println("extension header? " + bl4);
                        System.out.println("audio hint: flags is " + Integer.toHexString(n9));
                    }
                    n3 -= 2;
                    int n10 = this.parser.readShort(QuicktimeParser.this.stream);
                    n3 -= 2;
                    boolean bl5 = bl2 = (n9 & 4) > 0;
                    if (bl2) {
                        n6 = this.parser.readInt(QuicktimeParser.this.stream);
                        QuicktimeParser.this.skip(QuicktimeParser.this.stream, n6 - 4);
                        if (QuicktimeParser.this.debug) {
                            System.err.println("audio: extraInfoTLVPresent: Skipped");
                            System.out.println("tlvTableSize is " + n6);
                        }
                    }
                    if (QuicktimeParser.this.debug) {
                        System.out.println("Packet # " + this.currentPacketNumber);
                        System.out.println("  relativeTransmissionTime is " + n7);
                        System.out.println("  rtpSequenceNumber is " + n5);
                        System.out.println("  entriesInDataTable is " + n10);
                    }
                    n6 = 0;
                    while (true) {
                        int n11;
                        if (n6 >= n10) {
                            n4 = n2;
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("Actual size of packet sent " + n2);
                            }
                            n2 = 0;
                            this.offsetToStartOfPacketInfo = this.parser.getLocation(QuicktimeParser.this.stream);
                            if (n4 != -2) break;
                            buffer.setDiscard(true);
                            return;
                        }
                        int n12 = this.parser.readByte(QuicktimeParser.this.stream);
                        --n3;
                        if (QuicktimeParser.this.debug1) {
                            System.out.println("    dataBlockSource is " + n12);
                        }
                        if (n12 == 1) {
                            n11 = this.parser.readByte(QuicktimeParser.this.stream);
                            --n3;
                            this.parser.readBytes(QuicktimeParser.this.stream, byArray, n2, n11);
                            n2 += n11;
                            this.parser.skip(QuicktimeParser.this.stream, 14 - n11);
                            n3 -= 14;
                        } else if (n12 == 2) {
                            long l4;
                            TrakList trakList;
                            n11 = this.parser.readByte(QuicktimeParser.this.stream);
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("     audio:trackRefIndex is " + n11);
                            }
                            if (n11 > 0) {
                                System.err.println("     Currently we don't support hint tracks that refer to multiple media tracks: " + n11);
                                buffer.setDiscard(true);
                                return;
                            }
                            int n13 = this.parser.readShort(QuicktimeParser.this.stream);
                            int n14 = this.parser.readInt(QuicktimeParser.this.stream);
                            int n15 = this.parser.readInt(QuicktimeParser.this.stream);
                            int n16 = this.parser.readShort(QuicktimeParser.this.stream);
                            int n17 = this.parser.readShort(QuicktimeParser.this.stream);
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("     sample Number is " + n14);
                                System.out.println("     numBytesToCopy is " + n13);
                                System.out.println("     byteOffset is " + n15);
                                System.out.println("     bytesPerCompresionBlock is " + n16);
                                System.out.println("     samplesPerCompresionBlock is " + n17);
                            }
                            n3 -= 15;
                            long l5 = this.parser.getLocation(QuicktimeParser.this.stream);
                            if (n11 == 0) {
                                trakList = this.sampleTrakInfo;
                                if (QuicktimeParser.this.debug2) {
                                    System.out.println("set useTrakInfo as sampleTrakInfo");
                                }
                            } else {
                                trakList = this.trakInfo;
                            }
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("useTrakInfo is " + trakList);
                                System.out.println("useTrakInfo.sampleOffsetTable is " + trakList.sampleOffsetTable);
                            }
                            if (trakList.sampleOffsetTable == null) {
                                l4 = trakList.index2Offset(n14 - 1);
                                if (QuicktimeParser.this.debug1) {
                                    System.out.println("chunkOffsets size is " + trakList.chunkOffsets.length);
                                    System.out.println("sampleOffset from index2Offset " + l4);
                                }
                            } else {
                                l4 = trakList.sampleOffsetTable[n14 - 1];
                            }
                            if ((l3 = QuicktimeParser.this.seekableStream.seek(l4 += (long)n15)) == -2L) {
                                buffer.setDiscard(true);
                                this.offsetToStartOfPacketInfo = -1L;
                                return;
                            }
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("Audio: Seek to " + l4 + " and read " + n13 + " bytes into buffer with offset " + n2);
                            }
                            this.parser.readBytes(QuicktimeParser.this.stream, byArray, n2, n13);
                            n2 += n13;
                            l3 = QuicktimeParser.this.seekableStream.seek(l5);
                            if (l3 == -2L) {
                                buffer.setDiscard(true);
                                this.offsetToStartOfPacketInfo = -1L;
                                return;
                            }
                        } else {
                            if (n12 != 0) {
                                System.err.println("DISCARD: dataBlockSource " + n12 + " not supported");
                                buffer.setDiscard(true);
                                this.offsetToStartOfPacketInfo = -1L;
                                return;
                            }
                            n11 = this.parser.readByte(QuicktimeParser.this.stream);
                            this.parser.skip(QuicktimeParser.this.stream, n11);
                            n3 -= n11;
                        }
                        ++n6;
                    }
                }
                buffer.setLength(n4);
                if (bl) {
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtpMarkerSet: true");
                    }
                    buffer.setFlags(buffer.getFlags() | 0x800);
                } else {
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtpMarkerSet: false");
                    }
                    buffer.setFlags(buffer.getFlags() & 0xFFFFF7FF);
                }
                buffer.setSequenceNumber(n5);
                double d2 = this.trakInfo.index2TimeAndDuration((int)this.useChunkNumber).startTime;
                l2 = (long)(d2 * 1.0E9);
                buffer.setTimeStamp(l2);
                buffer.setDuration(-1L);
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            HintAudioTrack hintAudioTrack = this;
            synchronized (hintAudioTrack) {
                if (this.chunkNumber != this.useChunkNumber) {
                    this.currentPacketNumber = 0;
                    this.numPacketsInSample = -1;
                    this.offsetToStartOfPacketInfo = -1L;
                    return;
                }
                ++this.currentPacketNumber;
                if (this.currentPacketNumber < this.numPacketsInSample) return;
                ++this.chunkNumber;
                this.currentPacketNumber = 0;
                this.numPacketsInSample = -1;
                this.offsetToStartOfPacketInfo = -1L;
                return;
            }
        }

        public void readFrame(Buffer buffer) {
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            HintAudioTrack hintAudioTrack = this;
            synchronized (hintAudioTrack) {
                this.useChunkNumber = this.chunkNumber;
                this.useSampleIndex = this.sampleIndex;
            }
            buffer.setFormat(this.format);
            this.doReadFrame(buffer);
        }

        synchronized void setSampleIndex(int n2) {
            this.chunkNumber = n2;
            this.sampleIndex = n2;
        }
    }

    private class HintVideoTrack
    extends VideoTrack {
        int hintSampleSize;
        int indexOfTrackBeingHinted;
        int maxPacketSize;
        int currentPacketNumber;
        int numPacketsInSample;
        long offsetToStartOfPacketInfo;
        TrakList sampleTrakInfo;

        HintVideoTrack(TrakList trakList) {
            super(trakList);
            this.indexOfTrackBeingHinted = this.trakInfo.indexOfTrackBeingHinted;
            this.currentPacketNumber = 0;
            this.numPacketsInSample = -1;
            this.offsetToStartOfPacketInfo = -1L;
            this.sampleTrakInfo = null;
            this.format = ((Hint)trakList.media).format;
            this.hintSampleSize = this.needBufferSize;
            this.maxPacketSize = trakList.maxPacketSize;
            if (QuicktimeParser.this.debug1) {
                System.out.println("HintVideoTrack: Index of hinted track: " + trakList.indexOfTrackBeingHinted);
                System.out.println("HintVideoTrack: packet size is " + this.maxPacketSize);
            }
            if (this.indexOfTrackBeingHinted >= 0) {
                this.sampleTrakInfo = QuicktimeParser.this.trakList[this.indexOfTrackBeingHinted];
            } else if (QuicktimeParser.this.debug) {
                System.out.println("sampleTrakInfo is not set " + this.indexOfTrackBeingHinted);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] byArray;
            Object object;
            boolean bl = false;
            if (this.indexOfTrackBeingHinted < 0) {
                buffer.setDiscard(true);
                return;
            }
            if (this.useSampleIndex >= this.trakInfo.numberOfSamples) {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
            int n2 = 0;
            if (this.variableSampleSize) {
                this.hintSampleSize = this.trakInfo.sampleSizeArray[this.useSampleIndex];
            }
            int n3 = this.hintSampleSize;
            long l2 = this.trakInfo.sampleOffsetTable[this.useSampleIndex];
            if (QuicktimeParser.this.debug1) {
                System.out.println("hintSampleSize is " + this.hintSampleSize);
                System.out.println("useSampleIndex, offset " + this.useSampleIndex + " : " + l2);
            }
            if ((object = buffer.getData()) == null || !(object instanceof byte[]) || ((byte[])object).length < this.maxPacketSize) {
                byArray = new byte[this.maxPacketSize];
                buffer.setData(byArray);
            } else {
                byArray = (byte[])object;
            }
            try {
                int n4;
                int n5;
                Object object2 = QuicktimeParser.this.seekSync;
                synchronized (object2) {
                    int n6;
                    boolean bl2;
                    long l3;
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        this.currentPacketNumber = 0;
                        this.numPacketsInSample = -1;
                        this.offsetToStartOfPacketInfo = -1L;
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(l2, this.hintSampleSize)) {
                        this.listener.readHasBlocked(this);
                    }
                    if (this.offsetToStartOfPacketInfo < 0L) {
                        l3 = QuicktimeParser.this.seekableStream.seek(l2);
                        if (l3 == -2L) {
                            buffer.setDiscard(true);
                            return;
                        }
                        this.numPacketsInSample = this.parser.readShort(QuicktimeParser.this.stream);
                        if (QuicktimeParser.this.debug) {
                            System.out.println("video: num packets in sample " + this.numPacketsInSample);
                        }
                        if (this.numPacketsInSample < 1) {
                            buffer.setDiscard(true);
                            return;
                        }
                        n3 -= 2;
                        this.parser.readShort(QuicktimeParser.this.stream);
                        n3 -= 2;
                    } else {
                        l3 = QuicktimeParser.this.seekableStream.seek(this.offsetToStartOfPacketInfo);
                        if (l3 == -2L) {
                            buffer.setDiscard(true);
                            return;
                        }
                    }
                    int n7 = this.parser.readInt(QuicktimeParser.this.stream);
                    n3 -= 4;
                    short s = (short)this.parser.readShort(QuicktimeParser.this.stream);
                    bl = (s & 0x80) > 0;
                    n3 -= 2;
                    n5 = this.parser.readShort(QuicktimeParser.this.stream);
                    n3 -= 2;
                    boolean bl3 = (s & 0x2000) > 0;
                    boolean bl4 = (s & 0x1000) > 0;
                    int n8 = this.parser.readShort(QuicktimeParser.this.stream);
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtp marker present? " + bl);
                        System.out.println("rtp payload type " + (s & 0x7F));
                        System.out.println("padding? " + bl3);
                        System.out.println("extension header? " + bl4);
                        System.out.println("video hint: flags is " + Integer.toHexString(n8));
                    }
                    n3 -= 2;
                    int n9 = this.parser.readShort(QuicktimeParser.this.stream);
                    n3 -= 2;
                    boolean bl5 = bl2 = (n8 & 4) > 0;
                    if (bl2) {
                        n6 = this.parser.readInt(QuicktimeParser.this.stream);
                        QuicktimeParser.this.skip(QuicktimeParser.this.stream, n6 - 4);
                        if (QuicktimeParser.this.debug) {
                            System.err.println("video: extraInfoTLVPresent: Skipped");
                            System.out.println("tlvTableSize is " + n6);
                        }
                    }
                    if (QuicktimeParser.this.debug) {
                        System.out.println("Packet # " + this.currentPacketNumber);
                        System.out.println("  relativeTransmissionTime is " + n7);
                        System.out.println("$$$ relativeTransmissionTime is in timescale " + this.trakInfo.mediaTimeScale);
                        System.out.println("  rtpSequenceNumber is " + n5);
                        System.out.println("  entriesInDataTable is " + n9);
                    }
                    n6 = 0;
                    while (true) {
                        int n10;
                        if (n6 >= n9) {
                            n4 = n2;
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("Actual size of packet sent " + n2);
                            }
                            n2 = 0;
                            this.offsetToStartOfPacketInfo = this.parser.getLocation(QuicktimeParser.this.stream);
                            if (n4 != -2) break;
                            buffer.setDiscard(true);
                            return;
                        }
                        int n11 = this.parser.readByte(QuicktimeParser.this.stream);
                        --n3;
                        if (QuicktimeParser.this.debug1) {
                            System.out.println("    dataBlockSource is " + n11);
                        }
                        if (n11 == 1) {
                            n10 = this.parser.readByte(QuicktimeParser.this.stream);
                            --n3;
                            this.parser.readBytes(QuicktimeParser.this.stream, byArray, n2, n10);
                            n2 += n10;
                            this.parser.skip(QuicktimeParser.this.stream, 14 - n10);
                            n3 -= 14;
                        } else if (n11 == 2) {
                            n10 = this.parser.readByte(QuicktimeParser.this.stream);
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("     video: trackRefIndex is " + n10);
                            }
                            if (n10 > 0) {
                                System.err.println("     Currently we don't support hint tracks that refer to multiple media tracks");
                                buffer.setDiscard(true);
                                return;
                            }
                            int n12 = this.parser.readShort(QuicktimeParser.this.stream);
                            int n13 = this.parser.readInt(QuicktimeParser.this.stream);
                            int n14 = this.parser.readInt(QuicktimeParser.this.stream);
                            int n15 = this.parser.readShort(QuicktimeParser.this.stream);
                            int n16 = this.parser.readShort(QuicktimeParser.this.stream);
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("     sample Number is " + n13);
                                System.out.println("     numBytesToCopy is " + n12);
                                System.out.println("     byteOffset is " + n14);
                                System.out.println("     bytesPerCompresionBlock is " + n15);
                                System.out.println("     samplesPerCompresionBlock is " + n16);
                            }
                            n3 -= 15;
                            long l4 = this.parser.getLocation(QuicktimeParser.this.stream);
                            TrakList trakList = n10 == 0 ? this.sampleTrakInfo : this.trakInfo;
                            long l5 = trakList.sampleOffsetTable[n13 - 1];
                            l3 = QuicktimeParser.this.seekableStream.seek(l5 += (long)n14);
                            if (l3 == -2L) {
                                buffer.setDiscard(true);
                                this.offsetToStartOfPacketInfo = -1L;
                                return;
                            }
                            if (QuicktimeParser.this.debug1) {
                                System.out.println("     read " + n12 + " bytes from offset " + n2);
                            }
                            this.parser.readBytes(QuicktimeParser.this.stream, byArray, n2, n12);
                            n2 += n12;
                            l3 = QuicktimeParser.this.seekableStream.seek(l4);
                            if (l3 == -2L) {
                                buffer.setDiscard(true);
                                this.offsetToStartOfPacketInfo = -1L;
                                return;
                            }
                        } else {
                            buffer.setDiscard(true);
                            this.offsetToStartOfPacketInfo = -1L;
                            return;
                        }
                        ++n6;
                    }
                }
                buffer.setLength(n4);
                if (bl) {
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtpMarkerSet: true");
                    }
                    buffer.setFlags(buffer.getFlags() | 0x800);
                } else {
                    if (QuicktimeParser.this.debug) {
                        System.out.println("rtpMarkerSet: false");
                    }
                    buffer.setFlags(buffer.getFlags() & 0xFFFFF7FF);
                }
                buffer.setSequenceNumber(n5);
                object2 = this.trakInfo.index2TimeAndDuration(this.useSampleIndex);
                double d2 = ((TimeAndDuration)object2).startTime;
                long l6 = (long)(d2 * 1.0E9);
                buffer.setTimeStamp(l6);
                buffer.setDuration((long)(((TimeAndDuration)object2).duration * 1.0E9));
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            HintVideoTrack hintVideoTrack = this;
            synchronized (hintVideoTrack) {
                if (this.sampleIndex != this.useSampleIndex) {
                    this.currentPacketNumber = 0;
                    this.numPacketsInSample = -1;
                    this.offsetToStartOfPacketInfo = -1L;
                    return;
                }
                ++this.currentPacketNumber;
                if (this.currentPacketNumber < this.numPacketsInSample) return;
                ++this.sampleIndex;
                this.currentPacketNumber = 0;
                this.numPacketsInSample = -1;
                this.offsetToStartOfPacketInfo = -1L;
                return;
            }
        }
    }

    private class TimeAndDuration {
        double startTime;
        double duration;

        TimeAndDuration() {
        }
    }
}

