/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.parser.RawStreamParser;
import com.sun.media.protocol.DelegateDataSource;
import com.sun.media.rtp.Depacketizer;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;

public class RawBufferParser
extends RawStreamParser {
    static final String NAMEBUFFER = "Raw video/audio buffer stream parser";
    private boolean started = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static VideoFormat jpegVideo = new VideoFormat("jpeg/rtp");
    static VideoFormat h261Video = new VideoFormat("h261/rtp");
    static VideoFormat h263Video = new VideoFormat("h263/rtp");
    static VideoFormat h263_1998Video = new VideoFormat("h263-1998/rtp");
    final int[] h261Widths = new int[]{176, 352};
    final int[] h261Heights = new int[]{144, 288};
    final int[] h263Widths;
    final int[] h263Heights;
    final float[] MPEGRateTbl;
    public static int[][] MPASampleTbl;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[4];
        nArray[0] = 22050;
        nArray[1] = 24000;
        nArray[2] = 16000;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 44100;
        nArray2[1] = 48000;
        nArray2[2] = 32000;
        nArrayArray[1] = nArray2;
        MPASampleTbl = nArrayArray;
    }

    public RawBufferParser() {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        this.h263Widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        this.h263Heights = nArray2;
        float[] fArray = new float[9];
        fArray[1] = 23.976f;
        fArray[2] = 24.0f;
        fArray[3] = 25.0f;
        fArray[4] = 29.97f;
        fArray[5] = 30.0f;
        fArray[6] = 50.0f;
        fArray[7] = 59.94f;
        fArray[8] = 60.0f;
        this.MPEGRateTbl = fArray;
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                int n2 = 0;
                while (n2 < this.tracks.length) {
                    ((FrameTrack)this.tracks[n2]).stop();
                    ((FrameTrack)this.tracks[n2]).close();
                    ++n2;
                }
                this.source.disconnect();
            }
            catch (Exception exception) {}
            this.source = null;
        }
        this.started = false;
    }

    public String getName() {
        return NAMEBUFFER;
    }

    public Track[] getTracks() {
        int n2 = 0;
        while (n2 < this.tracks.length) {
            ((FrameTrack)this.tracks[n2]).parse();
            ++n2;
        }
        return this.tracks;
    }

    boolean isRTPFormat(Format format) {
        return format != null && format.getEncoding() != null && (format.getEncoding().endsWith("rtp") || format.getEncoding().endsWith("RTP"));
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int n2 = 0;
        while (n2 < this.streams.length) {
            this.tracks[n2] = new FrameTrack(this, (PushBufferStream)this.streams[n2], 1);
            ++n2;
        }
    }

    public void reset() {
        int n2 = 0;
        while (n2 < this.tracks.length) {
            ((FrameTrack)this.tracks[n2]).reset();
            ++n2;
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.streams = ((PushBufferDataSource)dataSource).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = this.streams;
    }

    public void start() throws IOException {
        int n2 = 0;
        while (n2 < this.tracks.length) {
            ((FrameTrack)this.tracks[n2]).start();
            ++n2;
        }
        this.source.start();
        this.started = true;
    }

    public void stop() {
        try {
            this.source.stop();
            int n2 = 0;
            while (n2 < this.tracks.length) {
                ((FrameTrack)this.tracks[n2]).stop();
                ++n2;
            }
        }
        catch (Exception exception) {}
        this.started = false;
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PushBufferStream;
    }

    class FrameTrack
    implements Track,
    BufferTransferHandler {
        Demultiplexer parser;
        PushBufferStream pbs;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        boolean stopped = true;
        boolean closed = false;
        boolean keyFrameFound = false;
        boolean checkDepacketizer = false;
        Depacketizer depacketizer = null;
        Object keyFrameLock = new Object();

        public FrameTrack(Demultiplexer demultiplexer, PushBufferStream pushBufferStream, int n2) {
            this.pbs = pushBufferStream;
            this.format = pushBufferStream.getFormat();
            if (RawBufferParser.this.source instanceof DelegateDataSource || !RawBufferParser.this.isRTPFormat(this.format)) {
                this.keyFrameFound = true;
            }
            this.bufferQ = new CircularBuffer(n2);
            pushBufferStream.setTransferHandler(this);
        }

        public void close() {
            this.setEnabled(false);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.closed = true;
                this.bufferQ.notifyAll();
            }
        }

        private Depacketizer findDepacketizer(String string, Format format) {
            try {
                Class clazz = BasicPlugIn.getClassForName(string);
                Object t = clazz.newInstance();
                if (!(t instanceof Depacketizer)) {
                    return null;
                }
                Depacketizer depacketizer = (Depacketizer)t;
                if (depacketizer.setInputFormat(format) == null) {
                    return null;
                }
                depacketizer.open();
                return depacketizer;
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
            return null;
        }

        public boolean findH261Key(Buffer buffer) {
            int n2;
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n3 = buffer.getOffset();
            if (byArray[n3 + (n2 = 4)] != 0 || byArray[n3 + n2 + 1] != 1 || (byArray[n3 + n2 + 2] & 0xFC) != 0) {
                return false;
            }
            int n4 = byArray[n3 + n2 + 3] >> 3 & 1;
            int n5 = RawBufferParser.this.h261Widths[n4];
            int n6 = RawBufferParser.this.h261Heights[n4];
            this.format = new VideoFormat("h261/rtp", new Dimension(n5, n6), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findH263Key(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n2 = this.getH263PayloadHeaderLength(byArray, buffer.getOffset());
            int n3 = buffer.getOffset();
            if (byArray[n3 + n2] != 0 || byArray[n3 + n2 + 1] != 0 || (byArray[n3 + n2 + 2] & 0xFC) != 128) {
                return false;
            }
            int n4 = byArray[n3 + n2 + 4] >> 2 & 7;
            int n5 = RawBufferParser.this.h263Widths[n4];
            int n6 = RawBufferParser.this.h263Heights[n4];
            this.format = new VideoFormat("h263/rtp", new Dimension(n5, n6), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findH263_1998Key(Buffer buffer) {
            int n2 = -1;
            int n3 = -1;
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n4 = buffer.getOffset();
            int n5 = 2 + ((byArray[n4] & 1) << 5 | (byArray[n4 + 1] & 0xF8) >> 3);
            if ((byArray[n4] & 2) != 0) {
                ++n5;
            }
            n3 = -1;
            if (n5 > 5) {
                if ((byArray[n4] & 2) == 2 && (byArray[n4 + 3] & 0xFC) == 128) {
                    n3 = n4 + 3;
                } else if ((byArray[n4 + 2] & 0xFC) == 128) {
                    n3 = n4 + 2;
                }
            } else if ((byArray[n4] & 4) == 4 && (byArray[n4 + n5] & 0xFC) == 128) {
                n3 = n4 + n5;
            }
            if (n3 < 0) {
                return false;
            }
            n2 = byArray[n3 + 2] >> 2 & 7;
            if (n2 == 7) {
                if ((byArray[n3 + 3] >> 1 & 7) == 1) {
                    n2 = byArray[n3 + 3] << 2 & 4 | byArray[n3 + 4] >> 6 & 3;
                } else {
                    return false;
                }
            }
            if (n2 < 0) {
                return false;
            }
            int n6 = RawBufferParser.this.h263Widths[n2];
            int n7 = RawBufferParser.this.h263Heights[n2];
            this.format = new VideoFormat("h263-1998/rtp", new Dimension(n6, n7), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findJPEGKey(Buffer buffer) {
            if ((buffer.getFlags() & 0x800) == 0) {
                return false;
            }
            byte[] byArray = (byte[])buffer.getData();
            int n2 = (byArray[buffer.getOffset() + 6] & 0xFF) * 8;
            int n3 = (byArray[buffer.getOffset() + 7] & 0xFF) * 8;
            this.format = new VideoFormat("jpeg/rtp", new Dimension(n2, n3), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        private boolean findKeyFrame(Buffer buffer) {
            Cloneable cloneable;
            if (!this.checkDepacketizer) {
                cloneable = PlugInManager.getPlugInList(buffer.getFormat(), null, 6);
                if (((Vector)cloneable).size() != 0) {
                    this.depacketizer = this.findDepacketizer((String)((Vector)cloneable).elementAt(0), buffer.getFormat());
                }
                this.checkDepacketizer = true;
            }
            if ((cloneable = buffer.getFormat()) == null) {
                return false;
            }
            if (((Format)cloneable).getEncoding() == null) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
                return true;
            }
            boolean bl = true;
            if (jpegVideo.matches((Format)cloneable)) {
                bl = this.findJPEGKey(buffer);
            } else if (h261Video.matches((Format)cloneable)) {
                bl = this.findH261Key(buffer);
            } else if (h263Video.matches((Format)cloneable)) {
                bl = this.findH263Key(buffer);
            } else if (h263_1998Video.matches((Format)cloneable)) {
                bl = this.findH263_1998Key(buffer);
            } else if (mpegVideo.matches((Format)cloneable)) {
                bl = this.findMPEGKey(buffer);
            } else if (mpegAudio.matches((Format)cloneable)) {
                bl = this.findMPAKey(buffer);
            } else if (this.depacketizer != null) {
                cloneable = this.depacketizer.parse(buffer);
                if (cloneable != null) {
                    this.format = cloneable;
                    buffer.setFormat(this.format);
                    this.depacketizer.close();
                    this.depacketizer = null;
                } else {
                    bl = false;
                }
            }
            if (bl) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
            }
            return this.keyFrameFound;
        }

        public boolean findMPAKey(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n2 = buffer.getOffset();
            if (buffer.getLength() < 8) {
                return false;
            }
            if (byArray[n2 + 2] != 0 || byArray[n2 + 3] != 0) {
                return false;
            }
            if ((byArray[n2 += 4] & 0xFF) != 255 || (byArray[n2 + 1] & 0xF6) <= 240 || (byArray[n2 + 2] & 0xF0) == 240 || (byArray[n2 + 2] & 0xC) == 12 || (byArray[n2 + 3] & 3) == 2) {
                return false;
            }
            int n3 = byArray[n2 + 1] >> 3 & 1;
            int n4 = byArray[n2 + 2] >> 2 & 3;
            int n5 = (byArray[n2 + 3] >> 6 & 3) == 3 ? 1 : 2;
            double d2 = MPASampleTbl[n3][n4];
            this.format = new AudioFormat("mpegaudio/rtp", d2, 16, n5, 0, 1);
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findMPEGKey(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n2 = buffer.getOffset();
            if (buffer.getLength() < 12) {
                return false;
            }
            if ((byArray[n2 + 2] & 0x20) != 32) {
                return false;
            }
            if (byArray[n2 + 4] != 0 || byArray[n2 + 5] != 0 || byArray[n2 + 6] != 1 || (byArray[n2 + 7] & 0xFF) != 179) {
                return false;
            }
            int n3 = byArray[n2 + 11] & 0xF;
            if (n3 == 0 || n3 > 8) {
                return false;
            }
            int n4 = (byArray[n2 + 8] & 0xFF) << 4 | (byArray[n2 + 9] & 0xF0) >> 4;
            int n5 = (byArray[n2 + 9] & 0xF) << 8 | byArray[n2 + 10] & 0xFF;
            float f2 = RawBufferParser.this.MPEGRateTbl[n3];
            this.format = new VideoFormat("mpeg/rtp", new Dimension(n4, n5), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), f2);
            buffer.setFormat(this.format);
            return true;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        int getH263PayloadHeaderLength(byte[] byArray, int n2) {
            int n3 = 0;
            byte by = byArray[n2];
            n3 = (by & 0x80) != 0 ? ((by & 0x40) != 0 ? 12 : 8) : 4;
            return n3;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n2) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        public void parse() {
            try {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    while (!this.keyFrameFound) {
                        this.keyFrameLock.wait();
                    }
                }
            }
            catch (Exception exception) {}
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readFrame(Buffer buffer) {
            Buffer buffer2;
            if (this.stopped) {
                buffer.setDiscard(true);
                buffer.setFormat(this.format);
                return;
            }
            Object object = this.bufferQ;
            synchronized (object) {
                while (true) {
                    if (this.bufferQ.canRead()) {
                        buffer2 = this.bufferQ.read();
                        break;
                    }
                    try {
                        this.bufferQ.wait();
                        if (!this.stopped) continue;
                        buffer.setDiscard(true);
                        buffer.setFormat(this.format);
                        return;
                    }
                    catch (Exception exception) {}
                }
            }
            object = buffer.getHeader();
            buffer.copy(buffer2, true);
            buffer2.setHeader(object);
            this.format = buffer2.getFormat();
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        public void reset() {
        }

        public void setEnabled(boolean bl) {
            if (bl) {
                this.pbs.setTransferHandler(this);
            } else {
                this.pbs.setTransferHandler(null);
            }
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        public void start() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = false;
                if (RawBufferParser.this.source instanceof CaptureDevice) {
                    while (this.bufferQ.canRead()) {
                        this.bufferQ.read();
                        this.bufferQ.readReport();
                    }
                }
                this.bufferQ.notifyAll();
            }
        }

        public void stop() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferData(PushBufferStream pushBufferStream) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (true) {
                    if (this.bufferQ.canWrite() || this.closed) {
                        if (!this.closed) break;
                        return;
                    }
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            try {
                pushBufferStream.read(buffer);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
            if (!this.keyFrameFound && !this.findKeyFrame(buffer)) {
                circularBuffer = this.bufferQ;
                synchronized (circularBuffer) {
                    this.bufferQ.writeReport();
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                    return;
                }
            }
            circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
                return;
            }
        }
    }
}

