/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class AviVideoFormat
extends VideoFormat {
    protected int planes = -1;
    protected int bitsPerPixel = -1;
    protected int imageSize = -1;
    protected int xPelsPerMeter = -1;
    protected int yPelsPerMeter = -1;
    protected int clrUsed = -1;
    protected int clrImportant = -1;
    protected byte[] codecSpecificHeader = null;

    public AviVideoFormat(String string) {
        super(string);
    }

    public AviVideoFormat(String string, Dimension dimension, int n2, Class clazz, float f2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray) {
        super(string, dimension, n2, clazz, f2);
        this.planes = n3;
        this.bitsPerPixel = n4;
        this.imageSize = n5;
        this.xPelsPerMeter = n6;
        this.yPelsPerMeter = n7;
        this.clrUsed = n8;
        this.clrImportant = n9;
        this.codecSpecificHeader = byArray;
    }

    public Object clone() {
        AviVideoFormat aviVideoFormat = new AviVideoFormat(this.encoding);
        aviVideoFormat.copy(this);
        return aviVideoFormat;
    }

    protected void copy(Format format) {
        super.copy(format);
        if (format instanceof AviVideoFormat) {
            AviVideoFormat aviVideoFormat = (AviVideoFormat)format;
            this.planes = aviVideoFormat.planes;
            this.bitsPerPixel = aviVideoFormat.bitsPerPixel;
            this.imageSize = aviVideoFormat.imageSize;
            this.xPelsPerMeter = aviVideoFormat.xPelsPerMeter;
            this.yPelsPerMeter = aviVideoFormat.yPelsPerMeter;
            this.clrUsed = aviVideoFormat.clrUsed;
            this.clrImportant = aviVideoFormat.clrImportant;
            this.codecSpecificHeader = aviVideoFormat.codecSpecificHeader;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AviVideoFormat) {
            boolean bl;
            AviVideoFormat aviVideoFormat = (AviVideoFormat)object;
            boolean bl2 = bl = super.equals(object) && this.planes == aviVideoFormat.planes && this.bitsPerPixel == aviVideoFormat.bitsPerPixel && this.imageSize == aviVideoFormat.imageSize && this.xPelsPerMeter == aviVideoFormat.xPelsPerMeter && this.yPelsPerMeter == aviVideoFormat.yPelsPerMeter && this.clrUsed == aviVideoFormat.clrUsed && this.clrImportant == aviVideoFormat.clrImportant;
            if (!bl) {
                return false;
            }
            if (this.codecSpecificHeader == aviVideoFormat.codecSpecificHeader) {
                return true;
            }
            if (this.codecSpecificHeader == null || aviVideoFormat.codecSpecificHeader == null) {
                return false;
            }
            if (this.codecSpecificHeader.length != aviVideoFormat.codecSpecificHeader.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.codecSpecificHeader.length) {
                if (this.codecSpecificHeader[n2] != aviVideoFormat.codecSpecificHeader[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getClrImportant() {
        return this.clrImportant;
    }

    public int getClrUsed() {
        return this.clrUsed;
    }

    public byte[] getCodecSpecificHeader() {
        return this.codecSpecificHeader;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getXPelsPerMeter() {
        return this.xPelsPerMeter;
    }

    public int getYPelsPerMeter() {
        return this.yPelsPerMeter;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof AviVideoFormat)) {
            return format2;
        }
        AviVideoFormat aviVideoFormat = (AviVideoFormat)format;
        AviVideoFormat aviVideoFormat2 = (AviVideoFormat)format2;
        aviVideoFormat2.planes = this.planes != -1 ? this.planes : aviVideoFormat.planes;
        aviVideoFormat2.bitsPerPixel = this.bitsPerPixel != -1 ? this.bitsPerPixel : aviVideoFormat.bitsPerPixel;
        aviVideoFormat2.imageSize = this.imageSize != -1 ? this.imageSize : aviVideoFormat.imageSize;
        aviVideoFormat2.xPelsPerMeter = this.xPelsPerMeter != -1 ? this.xPelsPerMeter : aviVideoFormat.xPelsPerMeter;
        aviVideoFormat2.yPelsPerMeter = this.yPelsPerMeter != -1 ? this.yPelsPerMeter : aviVideoFormat.yPelsPerMeter;
        aviVideoFormat2.clrUsed = this.clrUsed != -1 ? this.clrUsed : aviVideoFormat.clrUsed;
        aviVideoFormat2.clrImportant = this.clrImportant != -1 ? this.clrImportant : aviVideoFormat.clrImportant;
        aviVideoFormat2.codecSpecificHeader = this.codecSpecificHeader != null ? this.codecSpecificHeader : aviVideoFormat.codecSpecificHeader;
        return aviVideoFormat2;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AviVideoFormat)) {
            return true;
        }
        AviVideoFormat aviVideoFormat = (AviVideoFormat)format;
        boolean bl = !(this.planes != -1 && aviVideoFormat.planes != -1 && this.planes != aviVideoFormat.planes || this.bitsPerPixel != -1 && aviVideoFormat.bitsPerPixel != -1 && this.bitsPerPixel != aviVideoFormat.bitsPerPixel || this.imageSize != -1 && aviVideoFormat.imageSize != -1 && this.imageSize != aviVideoFormat.imageSize || this.xPelsPerMeter != -1 && aviVideoFormat.xPelsPerMeter != -1 && this.xPelsPerMeter != aviVideoFormat.xPelsPerMeter || this.yPelsPerMeter != -1 && aviVideoFormat.yPelsPerMeter != -1 && this.yPelsPerMeter != aviVideoFormat.yPelsPerMeter || this.clrUsed != -1 && aviVideoFormat.clrUsed != -1 && this.clrUsed != aviVideoFormat.clrUsed || this.clrImportant != -1 && aviVideoFormat.clrImportant != -1 && this.clrImportant != aviVideoFormat.clrImportant || this.codecSpecificHeader != null && aviVideoFormat.codecSpecificHeader != null && this.codecSpecificHeader != aviVideoFormat.codecSpecificHeader && !this.codecSpecificHeader.equals(this.codecSpecificHeader));
        return bl;
    }

    public Format relax() {
        AviVideoFormat aviVideoFormat = (AviVideoFormat)super.relax();
        if (aviVideoFormat == null) {
            return null;
        }
        aviVideoFormat.imageSize = -1;
        return aviVideoFormat;
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + " " + (this.codecSpecificHeader != null ? this.codecSpecificHeader.length : 0) + " extra bytes";
        return string;
    }
}

